/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event.validation.datarule;

import cdm.observable.event.FeaturePayment;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;

@RosettaDataRule(value="FeaturePaymentAmount")
@ImplementedBy(value=Default.class)
public interface FeaturePaymentAmount
extends Validator<FeaturePayment> {
    public static final String NAME = "FeaturePaymentAmount";
    public static final String DEFINITION = "if amount exists then amount >= 0.0";

    public ValidationResult<FeaturePayment> validate(RosettaPath var1, FeaturePayment var2);

    public static class NoOp
    implements FeaturePaymentAmount {
        @Override
        public ValidationResult<FeaturePayment> validate(RosettaPath path, FeaturePayment featurePayment) {
            return ValidationResult.success((String)FeaturePaymentAmount.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FeaturePayment", (RosettaPath)path, (String)FeaturePaymentAmount.DEFINITION);
        }
    }

    public static class Default
    implements FeaturePaymentAmount {
        @Override
        public ValidationResult<FeaturePayment> validate(RosettaPath path, FeaturePayment featurePayment) {
            ComparisonResult result = this.executeDataRule(featurePayment);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)FeaturePaymentAmount.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FeaturePayment", (RosettaPath)path, (String)FeaturePaymentAmount.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition FeaturePaymentAmount failed.";
            }
            return ValidationResult.failure((String)FeaturePaymentAmount.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FeaturePayment", (RosettaPath)path, (String)FeaturePaymentAmount.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(FeaturePayment featurePayment) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)featurePayment).map("getAmount", _featurePayment -> _featurePayment.getAmount())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)featurePayment).map("getAmount", _featurePayment -> _featurePayment.getAmount()), (Mapper)MapperS.of((Object)new BigDecimal("0.0")), (CardinalityOperator)CardinalityOperator.All);
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

