/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event;

import cdm.observable.event.CreditEvents;
import cdm.observable.event.TriggerTimeTypeEnum;
import cdm.observable.event.TriggerTypeEnum;
import cdm.observable.event.meta.TriggerMeta;
import cdm.observable.event.metafields.ReferenceWithMetaCreditEvents;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface Trigger
extends RosettaModelObject {
    public static final TriggerMeta metaData = new TriggerMeta();

    public Trigger build();

    public TriggerBuilder toBuilder();

    public CreditEvents getCreditEvents();

    public ReferenceWithMetaCreditEvents getCreditEventsReference();

    public BigDecimal getLevel();

    public BigDecimal getLevelPercentage();

    public TriggerTimeTypeEnum getTriggerTimeType();

    public TriggerTypeEnum getTriggerType();

    default public RosettaMetaData<? extends Trigger> metaData() {
        return metaData;
    }

    public static TriggerBuilder builder() {
        return new TriggerBuilderImpl();
    }

    default public Class<? extends Trigger> getType() {
        return Trigger.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("level"), BigDecimal.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("levelPercentage"), BigDecimal.class, (Object)this.getLevelPercentage(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("triggerTimeType"), TriggerTimeTypeEnum.class, (Object)this.getTriggerTimeType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("triggerType"), TriggerTypeEnum.class, (Object)this.getTriggerType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditEvents"), processor, CreditEvents.class, this.getCreditEvents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditEventsReference"), processor, ReferenceWithMetaCreditEvents.class, this.getCreditEventsReference(), new AttributeMeta[0]);
    }

    public static class TriggerBuilderImpl
    implements TriggerBuilder {
        protected CreditEvents.CreditEventsBuilder creditEvents;
        protected ReferenceWithMetaCreditEvents.ReferenceWithMetaCreditEventsBuilder creditEventsReference;
        protected BigDecimal level;
        protected BigDecimal levelPercentage;
        protected TriggerTimeTypeEnum triggerTimeType;
        protected TriggerTypeEnum triggerType;

        @Override
        public CreditEvents.CreditEventsBuilder getCreditEvents() {
            return this.creditEvents;
        }

        @Override
        public CreditEvents.CreditEventsBuilder getOrCreateCreditEvents() {
            CreditEvents.CreditEventsBuilder result = this.creditEvents != null ? this.creditEvents : (this.creditEvents = CreditEvents.builder());
            return result;
        }

        @Override
        public ReferenceWithMetaCreditEvents.ReferenceWithMetaCreditEventsBuilder getCreditEventsReference() {
            return this.creditEventsReference;
        }

        @Override
        public ReferenceWithMetaCreditEvents.ReferenceWithMetaCreditEventsBuilder getOrCreateCreditEventsReference() {
            ReferenceWithMetaCreditEvents.ReferenceWithMetaCreditEventsBuilder result = this.creditEventsReference != null ? this.creditEventsReference : (this.creditEventsReference = ReferenceWithMetaCreditEvents.builder());
            return result;
        }

        @Override
        public BigDecimal getLevel() {
            return this.level;
        }

        @Override
        public BigDecimal getLevelPercentage() {
            return this.levelPercentage;
        }

        @Override
        public TriggerTimeTypeEnum getTriggerTimeType() {
            return this.triggerTimeType;
        }

        @Override
        public TriggerTypeEnum getTriggerType() {
            return this.triggerType;
        }

        @Override
        public TriggerBuilder setCreditEvents(CreditEvents creditEvents) {
            this.creditEvents = creditEvents == null ? null : creditEvents.toBuilder();
            return this;
        }

        @Override
        public TriggerBuilder setCreditEventsReference(ReferenceWithMetaCreditEvents creditEventsReference) {
            this.creditEventsReference = creditEventsReference == null ? null : creditEventsReference.toBuilder();
            return this;
        }

        @Override
        public TriggerBuilder setCreditEventsReferenceValue(CreditEvents creditEventsReference) {
            this.getOrCreateCreditEventsReference().setValue(creditEventsReference);
            return this;
        }

        @Override
        public TriggerBuilder setLevel(BigDecimal level) {
            this.level = level == null ? null : level;
            return this;
        }

        @Override
        public TriggerBuilder setLevelPercentage(BigDecimal levelPercentage) {
            this.levelPercentage = levelPercentage == null ? null : levelPercentage;
            return this;
        }

        @Override
        public TriggerBuilder setTriggerTimeType(TriggerTimeTypeEnum triggerTimeType) {
            this.triggerTimeType = triggerTimeType == null ? null : triggerTimeType;
            return this;
        }

        @Override
        public TriggerBuilder setTriggerType(TriggerTypeEnum triggerType) {
            this.triggerType = triggerType == null ? null : triggerType;
            return this;
        }

        @Override
        public Trigger build() {
            return new TriggerImpl(this);
        }

        @Override
        public TriggerBuilder toBuilder() {
            return this;
        }

        @Override
        public TriggerBuilder prune() {
            if (this.creditEvents != null && !this.creditEvents.prune().hasData()) {
                this.creditEvents = null;
            }
            if (this.creditEventsReference != null && !this.creditEventsReference.prune().hasData()) {
                this.creditEventsReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCreditEvents() != null && this.getCreditEvents().hasData()) {
                return true;
            }
            if (this.getCreditEventsReference() != null && this.getCreditEventsReference().hasData()) {
                return true;
            }
            if (this.getLevel() != null) {
                return true;
            }
            if (this.getLevelPercentage() != null) {
                return true;
            }
            if (this.getTriggerTimeType() != null) {
                return true;
            }
            return this.getTriggerType() != null;
        }

        public TriggerBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TriggerBuilder o = (TriggerBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditEvents(), (RosettaModelObjectBuilder)o.getCreditEvents(), this::setCreditEvents);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditEventsReference(), (RosettaModelObjectBuilder)o.getCreditEventsReference(), this::setCreditEventsReference);
            merger.mergeBasic((Object)this.getLevel(), (Object)o.getLevel(), this::setLevel, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLevelPercentage(), (Object)o.getLevelPercentage(), this::setLevelPercentage, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTriggerTimeType(), (Object)o.getTriggerTimeType(), this::setTriggerTimeType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTriggerType(), (Object)o.getTriggerType(), this::setTriggerType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Trigger _that = this.getType().cast(o);
            if (!Objects.equals(this.creditEvents, _that.getCreditEvents())) {
                return false;
            }
            if (!Objects.equals(this.creditEventsReference, _that.getCreditEventsReference())) {
                return false;
            }
            if (!Objects.equals(this.level, _that.getLevel())) {
                return false;
            }
            if (!Objects.equals(this.levelPercentage, _that.getLevelPercentage())) {
                return false;
            }
            if (!Objects.equals((Object)this.triggerTimeType, (Object)_that.getTriggerTimeType())) {
                return false;
            }
            return Objects.equals((Object)this.triggerType, (Object)_that.getTriggerType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.creditEvents != null ? this.creditEvents.hashCode() : 0);
            _result = 31 * _result + (this.creditEventsReference != null ? this.creditEventsReference.hashCode() : 0);
            _result = 31 * _result + (this.level != null ? this.level.hashCode() : 0);
            _result = 31 * _result + (this.levelPercentage != null ? this.levelPercentage.hashCode() : 0);
            _result = 31 * _result + (this.triggerTimeType != null ? ((Object)((Object)this.triggerTimeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.triggerType != null ? ((Object)((Object)this.triggerType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TriggerBuilder {creditEvents=" + this.creditEvents + ", creditEventsReference=" + this.creditEventsReference + ", level=" + this.level + ", levelPercentage=" + this.levelPercentage + ", triggerTimeType=" + (Object)((Object)this.triggerTimeType) + ", triggerType=" + (Object)((Object)this.triggerType) + '}';
        }
    }

    public static class TriggerImpl
    implements Trigger {
        private final CreditEvents creditEvents;
        private final ReferenceWithMetaCreditEvents creditEventsReference;
        private final BigDecimal level;
        private final BigDecimal levelPercentage;
        private final TriggerTimeTypeEnum triggerTimeType;
        private final TriggerTypeEnum triggerType;

        protected TriggerImpl(TriggerBuilder builder) {
            this.creditEvents = Optional.ofNullable(builder.getCreditEvents()).map(f -> f.build()).orElse(null);
            this.creditEventsReference = Optional.ofNullable(builder.getCreditEventsReference()).map(f -> f.build()).orElse(null);
            this.level = builder.getLevel();
            this.levelPercentage = builder.getLevelPercentage();
            this.triggerTimeType = builder.getTriggerTimeType();
            this.triggerType = builder.getTriggerType();
        }

        @Override
        public CreditEvents getCreditEvents() {
            return this.creditEvents;
        }

        @Override
        public ReferenceWithMetaCreditEvents getCreditEventsReference() {
            return this.creditEventsReference;
        }

        @Override
        public BigDecimal getLevel() {
            return this.level;
        }

        @Override
        public BigDecimal getLevelPercentage() {
            return this.levelPercentage;
        }

        @Override
        public TriggerTimeTypeEnum getTriggerTimeType() {
            return this.triggerTimeType;
        }

        @Override
        public TriggerTypeEnum getTriggerType() {
            return this.triggerType;
        }

        @Override
        public Trigger build() {
            return this;
        }

        @Override
        public TriggerBuilder toBuilder() {
            TriggerBuilder builder = Trigger.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TriggerBuilder builder) {
            Optional.ofNullable(this.getCreditEvents()).ifPresent(builder::setCreditEvents);
            Optional.ofNullable(this.getCreditEventsReference()).ifPresent(builder::setCreditEventsReference);
            Optional.ofNullable(this.getLevel()).ifPresent(builder::setLevel);
            Optional.ofNullable(this.getLevelPercentage()).ifPresent(builder::setLevelPercentage);
            Optional.ofNullable(this.getTriggerTimeType()).ifPresent(builder::setTriggerTimeType);
            Optional.ofNullable(this.getTriggerType()).ifPresent(builder::setTriggerType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Trigger _that = this.getType().cast(o);
            if (!Objects.equals(this.creditEvents, _that.getCreditEvents())) {
                return false;
            }
            if (!Objects.equals(this.creditEventsReference, _that.getCreditEventsReference())) {
                return false;
            }
            if (!Objects.equals(this.level, _that.getLevel())) {
                return false;
            }
            if (!Objects.equals(this.levelPercentage, _that.getLevelPercentage())) {
                return false;
            }
            if (!Objects.equals((Object)this.triggerTimeType, (Object)_that.getTriggerTimeType())) {
                return false;
            }
            return Objects.equals((Object)this.triggerType, (Object)_that.getTriggerType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.creditEvents != null ? this.creditEvents.hashCode() : 0);
            _result = 31 * _result + (this.creditEventsReference != null ? this.creditEventsReference.hashCode() : 0);
            _result = 31 * _result + (this.level != null ? this.level.hashCode() : 0);
            _result = 31 * _result + (this.levelPercentage != null ? this.levelPercentage.hashCode() : 0);
            _result = 31 * _result + (this.triggerTimeType != null ? ((Object)((Object)this.triggerTimeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.triggerType != null ? ((Object)((Object)this.triggerType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Trigger {creditEvents=" + this.creditEvents + ", creditEventsReference=" + this.creditEventsReference + ", level=" + this.level + ", levelPercentage=" + this.levelPercentage + ", triggerTimeType=" + (Object)((Object)this.triggerTimeType) + ", triggerType=" + (Object)((Object)this.triggerType) + '}';
        }
    }

    public static interface TriggerBuilder
    extends Trigger,
    RosettaModelObjectBuilder {
        public CreditEvents.CreditEventsBuilder getOrCreateCreditEvents();

        @Override
        public CreditEvents.CreditEventsBuilder getCreditEvents();

        public ReferenceWithMetaCreditEvents.ReferenceWithMetaCreditEventsBuilder getOrCreateCreditEventsReference();

        @Override
        public ReferenceWithMetaCreditEvents.ReferenceWithMetaCreditEventsBuilder getCreditEventsReference();

        public TriggerBuilder setCreditEvents(CreditEvents var1);

        public TriggerBuilder setCreditEventsReference(ReferenceWithMetaCreditEvents var1);

        public TriggerBuilder setCreditEventsReferenceValue(CreditEvents var1);

        public TriggerBuilder setLevel(BigDecimal var1);

        public TriggerBuilder setLevelPercentage(BigDecimal var1);

        public TriggerBuilder setTriggerTimeType(TriggerTimeTypeEnum var1);

        public TriggerBuilder setTriggerType(TriggerTypeEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("level"), BigDecimal.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("levelPercentage"), BigDecimal.class, (Object)this.getLevelPercentage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("triggerTimeType"), TriggerTimeTypeEnum.class, (Object)this.getTriggerTimeType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("triggerType"), TriggerTypeEnum.class, (Object)this.getTriggerType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditEvents"), processor, CreditEvents.CreditEventsBuilder.class, this.getCreditEvents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditEventsReference"), processor, ReferenceWithMetaCreditEvents.ReferenceWithMetaCreditEventsBuilder.class, this.getCreditEventsReference(), new AttributeMeta[0]);
        }

        public TriggerBuilder prune();
    }
}

