/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event;

import cdm.observable.event.RestructuringEnum;
import cdm.observable.event.meta.RestructuringMeta;
import cdm.observable.event.metafields.FieldWithMetaRestructuringEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface Restructuring
extends RosettaModelObject {
    public static final RestructuringMeta metaData = new RestructuringMeta();

    public Restructuring build();

    public RestructuringBuilder toBuilder();

    public Boolean getApplicable();

    public Boolean getMultipleCreditEventNotices();

    public Boolean getMultipleHolderObligation();

    public FieldWithMetaRestructuringEnum getRestructuringType();

    default public RosettaMetaData<? extends Restructuring> metaData() {
        return metaData;
    }

    public static RestructuringBuilder builder() {
        return new RestructuringBuilderImpl();
    }

    default public Class<? extends Restructuring> getType() {
        return Restructuring.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("applicable"), Boolean.class, (Object)this.getApplicable(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("multipleCreditEventNotices"), Boolean.class, (Object)this.getMultipleCreditEventNotices(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("multipleHolderObligation"), Boolean.class, (Object)this.getMultipleHolderObligation(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("restructuringType"), processor, FieldWithMetaRestructuringEnum.class, this.getRestructuringType(), new AttributeMeta[0]);
    }

    public static class RestructuringBuilderImpl
    implements RestructuringBuilder {
        protected Boolean applicable;
        protected Boolean multipleCreditEventNotices;
        protected Boolean multipleHolderObligation;
        protected FieldWithMetaRestructuringEnum.FieldWithMetaRestructuringEnumBuilder restructuringType;

        @Override
        public Boolean getApplicable() {
            return this.applicable;
        }

        @Override
        public Boolean getMultipleCreditEventNotices() {
            return this.multipleCreditEventNotices;
        }

        @Override
        public Boolean getMultipleHolderObligation() {
            return this.multipleHolderObligation;
        }

        @Override
        public FieldWithMetaRestructuringEnum.FieldWithMetaRestructuringEnumBuilder getRestructuringType() {
            return this.restructuringType;
        }

        @Override
        public FieldWithMetaRestructuringEnum.FieldWithMetaRestructuringEnumBuilder getOrCreateRestructuringType() {
            FieldWithMetaRestructuringEnum.FieldWithMetaRestructuringEnumBuilder result = this.restructuringType != null ? this.restructuringType : (this.restructuringType = FieldWithMetaRestructuringEnum.builder());
            return result;
        }

        @Override
        public RestructuringBuilder setApplicable(Boolean applicable) {
            this.applicable = applicable == null ? null : applicable;
            return this;
        }

        @Override
        public RestructuringBuilder setMultipleCreditEventNotices(Boolean multipleCreditEventNotices) {
            this.multipleCreditEventNotices = multipleCreditEventNotices == null ? null : multipleCreditEventNotices;
            return this;
        }

        @Override
        public RestructuringBuilder setMultipleHolderObligation(Boolean multipleHolderObligation) {
            this.multipleHolderObligation = multipleHolderObligation == null ? null : multipleHolderObligation;
            return this;
        }

        @Override
        public RestructuringBuilder setRestructuringType(FieldWithMetaRestructuringEnum restructuringType) {
            this.restructuringType = restructuringType == null ? null : restructuringType.toBuilder();
            return this;
        }

        @Override
        public RestructuringBuilder setRestructuringTypeValue(RestructuringEnum restructuringType) {
            this.getOrCreateRestructuringType().setValue(restructuringType);
            return this;
        }

        @Override
        public Restructuring build() {
            return new RestructuringImpl(this);
        }

        @Override
        public RestructuringBuilder toBuilder() {
            return this;
        }

        @Override
        public RestructuringBuilder prune() {
            if (this.restructuringType != null && !this.restructuringType.prune().hasData()) {
                this.restructuringType = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getApplicable() != null) {
                return true;
            }
            if (this.getMultipleCreditEventNotices() != null) {
                return true;
            }
            if (this.getMultipleHolderObligation() != null) {
                return true;
            }
            return this.getRestructuringType() != null;
        }

        public RestructuringBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RestructuringBuilder o = (RestructuringBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRestructuringType(), (RosettaModelObjectBuilder)o.getRestructuringType(), this::setRestructuringType);
            merger.mergeBasic((Object)this.getApplicable(), (Object)o.getApplicable(), this::setApplicable, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMultipleCreditEventNotices(), (Object)o.getMultipleCreditEventNotices(), this::setMultipleCreditEventNotices, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMultipleHolderObligation(), (Object)o.getMultipleHolderObligation(), this::setMultipleHolderObligation, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Restructuring _that = this.getType().cast(o);
            if (!Objects.equals(this.applicable, _that.getApplicable())) {
                return false;
            }
            if (!Objects.equals(this.multipleCreditEventNotices, _that.getMultipleCreditEventNotices())) {
                return false;
            }
            if (!Objects.equals(this.multipleHolderObligation, _that.getMultipleHolderObligation())) {
                return false;
            }
            return Objects.equals(this.restructuringType, _that.getRestructuringType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.applicable != null ? this.applicable.hashCode() : 0);
            _result = 31 * _result + (this.multipleCreditEventNotices != null ? this.multipleCreditEventNotices.hashCode() : 0);
            _result = 31 * _result + (this.multipleHolderObligation != null ? this.multipleHolderObligation.hashCode() : 0);
            _result = 31 * _result + (this.restructuringType != null ? this.restructuringType.getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RestructuringBuilder {applicable=" + this.applicable + ", multipleCreditEventNotices=" + this.multipleCreditEventNotices + ", multipleHolderObligation=" + this.multipleHolderObligation + ", restructuringType=" + this.restructuringType + '}';
        }
    }

    public static class RestructuringImpl
    implements Restructuring {
        private final Boolean applicable;
        private final Boolean multipleCreditEventNotices;
        private final Boolean multipleHolderObligation;
        private final FieldWithMetaRestructuringEnum restructuringType;

        protected RestructuringImpl(RestructuringBuilder builder) {
            this.applicable = builder.getApplicable();
            this.multipleCreditEventNotices = builder.getMultipleCreditEventNotices();
            this.multipleHolderObligation = builder.getMultipleHolderObligation();
            this.restructuringType = Optional.ofNullable(builder.getRestructuringType()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Boolean getApplicable() {
            return this.applicable;
        }

        @Override
        public Boolean getMultipleCreditEventNotices() {
            return this.multipleCreditEventNotices;
        }

        @Override
        public Boolean getMultipleHolderObligation() {
            return this.multipleHolderObligation;
        }

        @Override
        public FieldWithMetaRestructuringEnum getRestructuringType() {
            return this.restructuringType;
        }

        @Override
        public Restructuring build() {
            return this;
        }

        @Override
        public RestructuringBuilder toBuilder() {
            RestructuringBuilder builder = Restructuring.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RestructuringBuilder builder) {
            Optional.ofNullable(this.getApplicable()).ifPresent(builder::setApplicable);
            Optional.ofNullable(this.getMultipleCreditEventNotices()).ifPresent(builder::setMultipleCreditEventNotices);
            Optional.ofNullable(this.getMultipleHolderObligation()).ifPresent(builder::setMultipleHolderObligation);
            Optional.ofNullable(this.getRestructuringType()).ifPresent(builder::setRestructuringType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Restructuring _that = this.getType().cast(o);
            if (!Objects.equals(this.applicable, _that.getApplicable())) {
                return false;
            }
            if (!Objects.equals(this.multipleCreditEventNotices, _that.getMultipleCreditEventNotices())) {
                return false;
            }
            if (!Objects.equals(this.multipleHolderObligation, _that.getMultipleHolderObligation())) {
                return false;
            }
            return Objects.equals(this.restructuringType, _that.getRestructuringType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.applicable != null ? this.applicable.hashCode() : 0);
            _result = 31 * _result + (this.multipleCreditEventNotices != null ? this.multipleCreditEventNotices.hashCode() : 0);
            _result = 31 * _result + (this.multipleHolderObligation != null ? this.multipleHolderObligation.hashCode() : 0);
            _result = 31 * _result + (this.restructuringType != null ? this.restructuringType.getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Restructuring {applicable=" + this.applicable + ", multipleCreditEventNotices=" + this.multipleCreditEventNotices + ", multipleHolderObligation=" + this.multipleHolderObligation + ", restructuringType=" + this.restructuringType + '}';
        }
    }

    public static interface RestructuringBuilder
    extends Restructuring,
    RosettaModelObjectBuilder {
        public FieldWithMetaRestructuringEnum.FieldWithMetaRestructuringEnumBuilder getOrCreateRestructuringType();

        @Override
        public FieldWithMetaRestructuringEnum.FieldWithMetaRestructuringEnumBuilder getRestructuringType();

        public RestructuringBuilder setApplicable(Boolean var1);

        public RestructuringBuilder setMultipleCreditEventNotices(Boolean var1);

        public RestructuringBuilder setMultipleHolderObligation(Boolean var1);

        public RestructuringBuilder setRestructuringType(FieldWithMetaRestructuringEnum var1);

        public RestructuringBuilder setRestructuringTypeValue(RestructuringEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("applicable"), Boolean.class, (Object)this.getApplicable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("multipleCreditEventNotices"), Boolean.class, (Object)this.getMultipleCreditEventNotices(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("multipleHolderObligation"), Boolean.class, (Object)this.getMultipleHolderObligation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("restructuringType"), processor, FieldWithMetaRestructuringEnum.FieldWithMetaRestructuringEnumBuilder.class, this.getRestructuringType(), new AttributeMeta[0]);
        }

        public RestructuringBuilder prune();
    }
}

