/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event;

import cdm.observable.event.meta.RepresentationsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface Representations
extends RosettaModelObject {
    public static final RepresentationsMeta metaData = new RepresentationsMeta();

    public Representations build();

    public RepresentationsBuilder toBuilder();

    public Boolean getAdditionalAcknowledgements();

    public Boolean getAgreementsRegardingHedging();

    public Boolean getIndexDisclaimer();

    public Boolean getNonReliance();

    default public RosettaMetaData<? extends Representations> metaData() {
        return metaData;
    }

    public static RepresentationsBuilder builder() {
        return new RepresentationsBuilderImpl();
    }

    default public Class<? extends Representations> getType() {
        return Representations.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("additionalAcknowledgements"), Boolean.class, (Object)this.getAdditionalAcknowledgements(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("agreementsRegardingHedging"), Boolean.class, (Object)this.getAgreementsRegardingHedging(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexDisclaimer"), Boolean.class, (Object)this.getIndexDisclaimer(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonReliance"), Boolean.class, (Object)this.getNonReliance(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class RepresentationsBuilderImpl
    implements RepresentationsBuilder {
        protected Boolean additionalAcknowledgements;
        protected Boolean agreementsRegardingHedging;
        protected Boolean indexDisclaimer;
        protected Boolean nonReliance;

        @Override
        public Boolean getAdditionalAcknowledgements() {
            return this.additionalAcknowledgements;
        }

        @Override
        public Boolean getAgreementsRegardingHedging() {
            return this.agreementsRegardingHedging;
        }

        @Override
        public Boolean getIndexDisclaimer() {
            return this.indexDisclaimer;
        }

        @Override
        public Boolean getNonReliance() {
            return this.nonReliance;
        }

        @Override
        public RepresentationsBuilder setAdditionalAcknowledgements(Boolean additionalAcknowledgements) {
            this.additionalAcknowledgements = additionalAcknowledgements == null ? null : additionalAcknowledgements;
            return this;
        }

        @Override
        public RepresentationsBuilder setAgreementsRegardingHedging(Boolean agreementsRegardingHedging) {
            this.agreementsRegardingHedging = agreementsRegardingHedging == null ? null : agreementsRegardingHedging;
            return this;
        }

        @Override
        public RepresentationsBuilder setIndexDisclaimer(Boolean indexDisclaimer) {
            this.indexDisclaimer = indexDisclaimer == null ? null : indexDisclaimer;
            return this;
        }

        @Override
        public RepresentationsBuilder setNonReliance(Boolean nonReliance) {
            this.nonReliance = nonReliance == null ? null : nonReliance;
            return this;
        }

        @Override
        public Representations build() {
            return new RepresentationsImpl(this);
        }

        @Override
        public RepresentationsBuilder toBuilder() {
            return this;
        }

        @Override
        public RepresentationsBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getAdditionalAcknowledgements() != null) {
                return true;
            }
            if (this.getAgreementsRegardingHedging() != null) {
                return true;
            }
            if (this.getIndexDisclaimer() != null) {
                return true;
            }
            return this.getNonReliance() != null;
        }

        public RepresentationsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RepresentationsBuilder o = (RepresentationsBuilder)other;
            merger.mergeBasic((Object)this.getAdditionalAcknowledgements(), (Object)o.getAdditionalAcknowledgements(), this::setAdditionalAcknowledgements, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAgreementsRegardingHedging(), (Object)o.getAgreementsRegardingHedging(), this::setAgreementsRegardingHedging, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIndexDisclaimer(), (Object)o.getIndexDisclaimer(), this::setIndexDisclaimer, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNonReliance(), (Object)o.getNonReliance(), this::setNonReliance, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Representations _that = this.getType().cast(o);
            if (!Objects.equals(this.additionalAcknowledgements, _that.getAdditionalAcknowledgements())) {
                return false;
            }
            if (!Objects.equals(this.agreementsRegardingHedging, _that.getAgreementsRegardingHedging())) {
                return false;
            }
            if (!Objects.equals(this.indexDisclaimer, _that.getIndexDisclaimer())) {
                return false;
            }
            return Objects.equals(this.nonReliance, _that.getNonReliance());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.additionalAcknowledgements != null ? this.additionalAcknowledgements.hashCode() : 0);
            _result = 31 * _result + (this.agreementsRegardingHedging != null ? this.agreementsRegardingHedging.hashCode() : 0);
            _result = 31 * _result + (this.indexDisclaimer != null ? this.indexDisclaimer.hashCode() : 0);
            _result = 31 * _result + (this.nonReliance != null ? this.nonReliance.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RepresentationsBuilder {additionalAcknowledgements=" + this.additionalAcknowledgements + ", agreementsRegardingHedging=" + this.agreementsRegardingHedging + ", indexDisclaimer=" + this.indexDisclaimer + ", nonReliance=" + this.nonReliance + '}';
        }
    }

    public static class RepresentationsImpl
    implements Representations {
        private final Boolean additionalAcknowledgements;
        private final Boolean agreementsRegardingHedging;
        private final Boolean indexDisclaimer;
        private final Boolean nonReliance;

        protected RepresentationsImpl(RepresentationsBuilder builder) {
            this.additionalAcknowledgements = builder.getAdditionalAcknowledgements();
            this.agreementsRegardingHedging = builder.getAgreementsRegardingHedging();
            this.indexDisclaimer = builder.getIndexDisclaimer();
            this.nonReliance = builder.getNonReliance();
        }

        @Override
        public Boolean getAdditionalAcknowledgements() {
            return this.additionalAcknowledgements;
        }

        @Override
        public Boolean getAgreementsRegardingHedging() {
            return this.agreementsRegardingHedging;
        }

        @Override
        public Boolean getIndexDisclaimer() {
            return this.indexDisclaimer;
        }

        @Override
        public Boolean getNonReliance() {
            return this.nonReliance;
        }

        @Override
        public Representations build() {
            return this;
        }

        @Override
        public RepresentationsBuilder toBuilder() {
            RepresentationsBuilder builder = Representations.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RepresentationsBuilder builder) {
            Optional.ofNullable(this.getAdditionalAcknowledgements()).ifPresent(builder::setAdditionalAcknowledgements);
            Optional.ofNullable(this.getAgreementsRegardingHedging()).ifPresent(builder::setAgreementsRegardingHedging);
            Optional.ofNullable(this.getIndexDisclaimer()).ifPresent(builder::setIndexDisclaimer);
            Optional.ofNullable(this.getNonReliance()).ifPresent(builder::setNonReliance);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Representations _that = this.getType().cast(o);
            if (!Objects.equals(this.additionalAcknowledgements, _that.getAdditionalAcknowledgements())) {
                return false;
            }
            if (!Objects.equals(this.agreementsRegardingHedging, _that.getAgreementsRegardingHedging())) {
                return false;
            }
            if (!Objects.equals(this.indexDisclaimer, _that.getIndexDisclaimer())) {
                return false;
            }
            return Objects.equals(this.nonReliance, _that.getNonReliance());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.additionalAcknowledgements != null ? this.additionalAcknowledgements.hashCode() : 0);
            _result = 31 * _result + (this.agreementsRegardingHedging != null ? this.agreementsRegardingHedging.hashCode() : 0);
            _result = 31 * _result + (this.indexDisclaimer != null ? this.indexDisclaimer.hashCode() : 0);
            _result = 31 * _result + (this.nonReliance != null ? this.nonReliance.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Representations {additionalAcknowledgements=" + this.additionalAcknowledgements + ", agreementsRegardingHedging=" + this.agreementsRegardingHedging + ", indexDisclaimer=" + this.indexDisclaimer + ", nonReliance=" + this.nonReliance + '}';
        }
    }

    public static interface RepresentationsBuilder
    extends Representations,
    RosettaModelObjectBuilder {
        public RepresentationsBuilder setAdditionalAcknowledgements(Boolean var1);

        public RepresentationsBuilder setAgreementsRegardingHedging(Boolean var1);

        public RepresentationsBuilder setIndexDisclaimer(Boolean var1);

        public RepresentationsBuilder setNonReliance(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("additionalAcknowledgements"), Boolean.class, (Object)this.getAdditionalAcknowledgements(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("agreementsRegardingHedging"), Boolean.class, (Object)this.getAgreementsRegardingHedging(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexDisclaimer"), Boolean.class, (Object)this.getIndexDisclaimer(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonReliance"), Boolean.class, (Object)this.getNonReliance(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public RepresentationsBuilder prune();
    }
}

