/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event;

import cdm.observable.event.meta.PubliclyAvailableInformationMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface PubliclyAvailableInformation
extends RosettaModelObject {
    public static final PubliclyAvailableInformationMeta metaData = new PubliclyAvailableInformationMeta();

    public PubliclyAvailableInformation build();

    public PubliclyAvailableInformationBuilder toBuilder();

    public List<String> getPublicSource();

    public Integer getSpecifiedNumber();

    public Boolean getStandardPublicSources();

    default public RosettaMetaData<? extends PubliclyAvailableInformation> metaData() {
        return metaData;
    }

    public static PubliclyAvailableInformationBuilder builder() {
        return new PubliclyAvailableInformationBuilderImpl();
    }

    default public Class<? extends PubliclyAvailableInformation> getType() {
        return PubliclyAvailableInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("publicSource"), String.class, this.getPublicSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("specifiedNumber"), Integer.class, (Object)this.getSpecifiedNumber(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("standardPublicSources"), Boolean.class, (Object)this.getStandardPublicSources(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PubliclyAvailableInformationBuilderImpl
    implements PubliclyAvailableInformationBuilder {
        protected List<String> publicSource = new ArrayList<String>();
        protected Integer specifiedNumber;
        protected Boolean standardPublicSources;

        @Override
        public List<String> getPublicSource() {
            return this.publicSource;
        }

        @Override
        public Integer getSpecifiedNumber() {
            return this.specifiedNumber;
        }

        @Override
        public Boolean getStandardPublicSources() {
            return this.standardPublicSources;
        }

        @Override
        public PubliclyAvailableInformationBuilder addPublicSource(String publicSource) {
            if (publicSource != null) {
                this.publicSource.add(publicSource);
            }
            return this;
        }

        @Override
        public PubliclyAvailableInformationBuilder addPublicSource(String publicSource, int _idx) {
            this.getIndex(this.publicSource, _idx, () -> publicSource);
            return this;
        }

        @Override
        public PubliclyAvailableInformationBuilder addPublicSource(List<? extends String> publicSources) {
            if (publicSources != null) {
                for (String string : publicSources) {
                    this.publicSource.add(string);
                }
            }
            return this;
        }

        @Override
        public PubliclyAvailableInformationBuilder setPublicSource(List<? extends String> publicSources) {
            this.publicSource = publicSources == null ? new ArrayList<String>() : (List)publicSources.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PubliclyAvailableInformationBuilder setSpecifiedNumber(Integer specifiedNumber) {
            this.specifiedNumber = specifiedNumber == null ? null : specifiedNumber;
            return this;
        }

        @Override
        public PubliclyAvailableInformationBuilder setStandardPublicSources(Boolean standardPublicSources) {
            this.standardPublicSources = standardPublicSources == null ? null : standardPublicSources;
            return this;
        }

        @Override
        public PubliclyAvailableInformation build() {
            return new PubliclyAvailableInformationImpl(this);
        }

        @Override
        public PubliclyAvailableInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public PubliclyAvailableInformationBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getPublicSource() != null && !this.getPublicSource().isEmpty()) {
                return true;
            }
            if (this.getSpecifiedNumber() != null) {
                return true;
            }
            return this.getStandardPublicSources() != null;
        }

        public PubliclyAvailableInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PubliclyAvailableInformationBuilder o = (PubliclyAvailableInformationBuilder)other;
            merger.mergeBasic(this.getPublicSource(), o.getPublicSource(), this::addPublicSource);
            merger.mergeBasic((Object)this.getSpecifiedNumber(), (Object)o.getSpecifiedNumber(), this::setSpecifiedNumber, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getStandardPublicSources(), (Object)o.getStandardPublicSources(), this::setStandardPublicSources, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PubliclyAvailableInformation _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.publicSource, _that.getPublicSource())) {
                return false;
            }
            if (!Objects.equals(this.specifiedNumber, _that.getSpecifiedNumber())) {
                return false;
            }
            return Objects.equals(this.standardPublicSources, _that.getStandardPublicSources());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.publicSource != null ? this.publicSource.hashCode() : 0);
            _result = 31 * _result + (this.specifiedNumber != null ? this.specifiedNumber.hashCode() : 0);
            _result = 31 * _result + (this.standardPublicSources != null ? this.standardPublicSources.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PubliclyAvailableInformationBuilder {publicSource=" + this.publicSource + ", specifiedNumber=" + this.specifiedNumber + ", standardPublicSources=" + this.standardPublicSources + '}';
        }
    }

    public static class PubliclyAvailableInformationImpl
    implements PubliclyAvailableInformation {
        private final List<String> publicSource;
        private final Integer specifiedNumber;
        private final Boolean standardPublicSources;

        protected PubliclyAvailableInformationImpl(PubliclyAvailableInformationBuilder builder) {
            this.publicSource = Optional.ofNullable(builder.getPublicSource()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.specifiedNumber = builder.getSpecifiedNumber();
            this.standardPublicSources = builder.getStandardPublicSources();
        }

        @Override
        public List<String> getPublicSource() {
            return this.publicSource;
        }

        @Override
        public Integer getSpecifiedNumber() {
            return this.specifiedNumber;
        }

        @Override
        public Boolean getStandardPublicSources() {
            return this.standardPublicSources;
        }

        @Override
        public PubliclyAvailableInformation build() {
            return this;
        }

        @Override
        public PubliclyAvailableInformationBuilder toBuilder() {
            PubliclyAvailableInformationBuilder builder = PubliclyAvailableInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PubliclyAvailableInformationBuilder builder) {
            Optional.ofNullable(this.getPublicSource()).ifPresent(builder::setPublicSource);
            Optional.ofNullable(this.getSpecifiedNumber()).ifPresent(builder::setSpecifiedNumber);
            Optional.ofNullable(this.getStandardPublicSources()).ifPresent(builder::setStandardPublicSources);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PubliclyAvailableInformation _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.publicSource, _that.getPublicSource())) {
                return false;
            }
            if (!Objects.equals(this.specifiedNumber, _that.getSpecifiedNumber())) {
                return false;
            }
            return Objects.equals(this.standardPublicSources, _that.getStandardPublicSources());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.publicSource != null ? this.publicSource.hashCode() : 0);
            _result = 31 * _result + (this.specifiedNumber != null ? this.specifiedNumber.hashCode() : 0);
            _result = 31 * _result + (this.standardPublicSources != null ? this.standardPublicSources.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PubliclyAvailableInformation {publicSource=" + this.publicSource + ", specifiedNumber=" + this.specifiedNumber + ", standardPublicSources=" + this.standardPublicSources + '}';
        }
    }

    public static interface PubliclyAvailableInformationBuilder
    extends PubliclyAvailableInformation,
    RosettaModelObjectBuilder {
        public PubliclyAvailableInformationBuilder addPublicSource(String var1);

        public PubliclyAvailableInformationBuilder addPublicSource(String var1, int var2);

        public PubliclyAvailableInformationBuilder addPublicSource(List<? extends String> var1);

        public PubliclyAvailableInformationBuilder setPublicSource(List<? extends String> var1);

        public PubliclyAvailableInformationBuilder setSpecifiedNumber(Integer var1);

        public PubliclyAvailableInformationBuilder setStandardPublicSources(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("publicSource"), String.class, this.getPublicSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("specifiedNumber"), Integer.class, (Object)this.getSpecifiedNumber(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("standardPublicSources"), Boolean.class, (Object)this.getStandardPublicSources(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PubliclyAvailableInformationBuilder prune();
    }
}

