/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event;

import cdm.base.datetime.TimeZone;
import cdm.observable.asset.InformationSource;
import cdm.observable.asset.Observable;
import cdm.observable.event.DeterminationMethodology;
import cdm.observable.event.meta.ObservationIdentifierMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface ObservationIdentifier
extends RosettaModelObject {
    public static final ObservationIdentifierMeta metaData = new ObservationIdentifierMeta();

    public ObservationIdentifier build();

    public ObservationIdentifierBuilder toBuilder();

    public DeterminationMethodology getDeterminationMethodology();

    public InformationSource getInformationSource();

    public Observable getObservable();

    public Date getObservationDate();

    public TimeZone getObservationTime();

    default public RosettaMetaData<? extends ObservationIdentifier> metaData() {
        return metaData;
    }

    public static ObservationIdentifierBuilder builder() {
        return new ObservationIdentifierBuilderImpl();
    }

    default public Class<? extends ObservationIdentifier> getType() {
        return ObservationIdentifier.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("observationDate"), Date.class, (Object)this.getObservationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("determinationMethodology"), processor, DeterminationMethodology.class, this.getDeterminationMethodology(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.class, this.getInformationSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observable"), processor, Observable.class, this.getObservable(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationTime"), processor, TimeZone.class, this.getObservationTime(), new AttributeMeta[0]);
    }

    public static class ObservationIdentifierBuilderImpl
    implements ObservationIdentifierBuilder {
        protected DeterminationMethodology.DeterminationMethodologyBuilder determinationMethodology;
        protected InformationSource.InformationSourceBuilder informationSource;
        protected Observable.ObservableBuilder observable;
        protected Date observationDate;
        protected TimeZone.TimeZoneBuilder observationTime;

        @Override
        public DeterminationMethodology.DeterminationMethodologyBuilder getDeterminationMethodology() {
            return this.determinationMethodology;
        }

        @Override
        public DeterminationMethodology.DeterminationMethodologyBuilder getOrCreateDeterminationMethodology() {
            DeterminationMethodology.DeterminationMethodologyBuilder result = this.determinationMethodology != null ? this.determinationMethodology : (this.determinationMethodology = DeterminationMethodology.builder());
            return result;
        }

        @Override
        public InformationSource.InformationSourceBuilder getInformationSource() {
            return this.informationSource;
        }

        @Override
        public InformationSource.InformationSourceBuilder getOrCreateInformationSource() {
            InformationSource.InformationSourceBuilder result = this.informationSource != null ? this.informationSource : (this.informationSource = InformationSource.builder());
            return result;
        }

        @Override
        public Observable.ObservableBuilder getObservable() {
            return this.observable;
        }

        @Override
        public Observable.ObservableBuilder getOrCreateObservable() {
            Observable.ObservableBuilder result = this.observable != null ? this.observable : (this.observable = Observable.builder());
            return result;
        }

        @Override
        public Date getObservationDate() {
            return this.observationDate;
        }

        @Override
        public TimeZone.TimeZoneBuilder getObservationTime() {
            return this.observationTime;
        }

        @Override
        public TimeZone.TimeZoneBuilder getOrCreateObservationTime() {
            TimeZone.TimeZoneBuilder result = this.observationTime != null ? this.observationTime : (this.observationTime = TimeZone.builder());
            return result;
        }

        @Override
        public ObservationIdentifierBuilder setDeterminationMethodology(DeterminationMethodology determinationMethodology) {
            this.determinationMethodology = determinationMethodology == null ? null : determinationMethodology.toBuilder();
            return this;
        }

        @Override
        public ObservationIdentifierBuilder setInformationSource(InformationSource informationSource) {
            this.informationSource = informationSource == null ? null : informationSource.toBuilder();
            return this;
        }

        @Override
        public ObservationIdentifierBuilder setObservable(Observable observable) {
            this.observable = observable == null ? null : observable.toBuilder();
            return this;
        }

        @Override
        public ObservationIdentifierBuilder setObservationDate(Date observationDate) {
            this.observationDate = observationDate == null ? null : observationDate;
            return this;
        }

        @Override
        public ObservationIdentifierBuilder setObservationTime(TimeZone observationTime) {
            this.observationTime = observationTime == null ? null : observationTime.toBuilder();
            return this;
        }

        @Override
        public ObservationIdentifier build() {
            return new ObservationIdentifierImpl(this);
        }

        @Override
        public ObservationIdentifierBuilder toBuilder() {
            return this;
        }

        @Override
        public ObservationIdentifierBuilder prune() {
            if (this.determinationMethodology != null && !this.determinationMethodology.prune().hasData()) {
                this.determinationMethodology = null;
            }
            if (this.informationSource != null && !this.informationSource.prune().hasData()) {
                this.informationSource = null;
            }
            if (this.observable != null && !this.observable.prune().hasData()) {
                this.observable = null;
            }
            if (this.observationTime != null && !this.observationTime.prune().hasData()) {
                this.observationTime = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDeterminationMethodology() != null && this.getDeterminationMethodology().hasData()) {
                return true;
            }
            if (this.getInformationSource() != null && this.getInformationSource().hasData()) {
                return true;
            }
            if (this.getObservable() != null && this.getObservable().hasData()) {
                return true;
            }
            if (this.getObservationDate() != null) {
                return true;
            }
            return this.getObservationTime() != null && this.getObservationTime().hasData();
        }

        public ObservationIdentifierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ObservationIdentifierBuilder o = (ObservationIdentifierBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeterminationMethodology(), (RosettaModelObjectBuilder)o.getDeterminationMethodology(), this::setDeterminationMethodology);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInformationSource(), (RosettaModelObjectBuilder)o.getInformationSource(), this::setInformationSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservable(), (RosettaModelObjectBuilder)o.getObservable(), this::setObservable);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservationTime(), (RosettaModelObjectBuilder)o.getObservationTime(), this::setObservationTime);
            merger.mergeBasic((Object)this.getObservationDate(), (Object)o.getObservationDate(), this::setObservationDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationIdentifier _that = this.getType().cast(o);
            if (!Objects.equals(this.determinationMethodology, _that.getDeterminationMethodology())) {
                return false;
            }
            if (!Objects.equals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.observable, _that.getObservable())) {
                return false;
            }
            if (!Objects.equals(this.observationDate, _that.getObservationDate())) {
                return false;
            }
            return Objects.equals(this.observationTime, _that.getObservationTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.determinationMethodology != null ? this.determinationMethodology.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.observable != null ? this.observable.hashCode() : 0);
            _result = 31 * _result + (this.observationDate != null ? this.observationDate.hashCode() : 0);
            _result = 31 * _result + (this.observationTime != null ? this.observationTime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationIdentifierBuilder {determinationMethodology=" + this.determinationMethodology + ", informationSource=" + this.informationSource + ", observable=" + this.observable + ", observationDate=" + this.observationDate + ", observationTime=" + this.observationTime + '}';
        }
    }

    public static class ObservationIdentifierImpl
    implements ObservationIdentifier {
        private final DeterminationMethodology determinationMethodology;
        private final InformationSource informationSource;
        private final Observable observable;
        private final Date observationDate;
        private final TimeZone observationTime;

        protected ObservationIdentifierImpl(ObservationIdentifierBuilder builder) {
            this.determinationMethodology = Optional.ofNullable(builder.getDeterminationMethodology()).map(f -> f.build()).orElse(null);
            this.informationSource = Optional.ofNullable(builder.getInformationSource()).map(f -> f.build()).orElse(null);
            this.observable = Optional.ofNullable(builder.getObservable()).map(f -> f.build()).orElse(null);
            this.observationDate = builder.getObservationDate();
            this.observationTime = Optional.ofNullable(builder.getObservationTime()).map(f -> f.build()).orElse(null);
        }

        @Override
        public DeterminationMethodology getDeterminationMethodology() {
            return this.determinationMethodology;
        }

        @Override
        public InformationSource getInformationSource() {
            return this.informationSource;
        }

        @Override
        public Observable getObservable() {
            return this.observable;
        }

        @Override
        public Date getObservationDate() {
            return this.observationDate;
        }

        @Override
        public TimeZone getObservationTime() {
            return this.observationTime;
        }

        @Override
        public ObservationIdentifier build() {
            return this;
        }

        @Override
        public ObservationIdentifierBuilder toBuilder() {
            ObservationIdentifierBuilder builder = ObservationIdentifier.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObservationIdentifierBuilder builder) {
            Optional.ofNullable(this.getDeterminationMethodology()).ifPresent(builder::setDeterminationMethodology);
            Optional.ofNullable(this.getInformationSource()).ifPresent(builder::setInformationSource);
            Optional.ofNullable(this.getObservable()).ifPresent(builder::setObservable);
            Optional.ofNullable(this.getObservationDate()).ifPresent(builder::setObservationDate);
            Optional.ofNullable(this.getObservationTime()).ifPresent(builder::setObservationTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationIdentifier _that = this.getType().cast(o);
            if (!Objects.equals(this.determinationMethodology, _that.getDeterminationMethodology())) {
                return false;
            }
            if (!Objects.equals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.observable, _that.getObservable())) {
                return false;
            }
            if (!Objects.equals(this.observationDate, _that.getObservationDate())) {
                return false;
            }
            return Objects.equals(this.observationTime, _that.getObservationTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.determinationMethodology != null ? this.determinationMethodology.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.observable != null ? this.observable.hashCode() : 0);
            _result = 31 * _result + (this.observationDate != null ? this.observationDate.hashCode() : 0);
            _result = 31 * _result + (this.observationTime != null ? this.observationTime.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationIdentifier {determinationMethodology=" + this.determinationMethodology + ", informationSource=" + this.informationSource + ", observable=" + this.observable + ", observationDate=" + this.observationDate + ", observationTime=" + this.observationTime + '}';
        }
    }

    public static interface ObservationIdentifierBuilder
    extends ObservationIdentifier,
    RosettaModelObjectBuilder {
        public DeterminationMethodology.DeterminationMethodologyBuilder getOrCreateDeterminationMethodology();

        @Override
        public DeterminationMethodology.DeterminationMethodologyBuilder getDeterminationMethodology();

        public InformationSource.InformationSourceBuilder getOrCreateInformationSource();

        @Override
        public InformationSource.InformationSourceBuilder getInformationSource();

        public Observable.ObservableBuilder getOrCreateObservable();

        @Override
        public Observable.ObservableBuilder getObservable();

        public TimeZone.TimeZoneBuilder getOrCreateObservationTime();

        @Override
        public TimeZone.TimeZoneBuilder getObservationTime();

        public ObservationIdentifierBuilder setDeterminationMethodology(DeterminationMethodology var1);

        public ObservationIdentifierBuilder setInformationSource(InformationSource var1);

        public ObservationIdentifierBuilder setObservable(Observable var1);

        public ObservationIdentifierBuilder setObservationDate(Date var1);

        public ObservationIdentifierBuilder setObservationTime(TimeZone var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("observationDate"), Date.class, (Object)this.getObservationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("determinationMethodology"), processor, DeterminationMethodology.DeterminationMethodologyBuilder.class, this.getDeterminationMethodology(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.InformationSourceBuilder.class, this.getInformationSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observable"), processor, Observable.ObservableBuilder.class, this.getObservable(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationTime"), processor, TimeZone.TimeZoneBuilder.class, this.getObservationTime(), new AttributeMeta[0]);
        }

        public ObservationIdentifierBuilder prune();
    }
}

