/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event;

import cdm.observable.asset.Price;
import cdm.observable.event.ObservationIdentifier;
import cdm.observable.event.meta.ObservationMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface Observation
extends RosettaModelObject,
GlobalKey {
    public static final ObservationMeta metaData = new ObservationMeta();

    public Observation build();

    public ObservationBuilder toBuilder();

    public MetaFields getMeta();

    public ObservationIdentifier getObservationIdentifier();

    public Price getObservedValue();

    default public RosettaMetaData<? extends Observation> metaData() {
        return metaData;
    }

    public static ObservationBuilder builder() {
        return new ObservationBuilderImpl();
    }

    default public Class<? extends Observation> getType() {
        return Observation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationIdentifier"), processor, ObservationIdentifier.class, this.getObservationIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observedValue"), processor, Price.class, this.getObservedValue(), new AttributeMeta[0]);
    }

    public static class ObservationBuilderImpl
    implements ObservationBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected MetaFields.MetaFieldsBuilder meta;
        protected ObservationIdentifier.ObservationIdentifierBuilder observationIdentifier;
        protected Price.PriceBuilder observedValue;

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public ObservationIdentifier.ObservationIdentifierBuilder getObservationIdentifier() {
            return this.observationIdentifier;
        }

        @Override
        public ObservationIdentifier.ObservationIdentifierBuilder getOrCreateObservationIdentifier() {
            ObservationIdentifier.ObservationIdentifierBuilder result = this.observationIdentifier != null ? this.observationIdentifier : (this.observationIdentifier = ObservationIdentifier.builder());
            return result;
        }

        @Override
        public Price.PriceBuilder getObservedValue() {
            return this.observedValue;
        }

        @Override
        public Price.PriceBuilder getOrCreateObservedValue() {
            Price.PriceBuilder result = this.observedValue != null ? this.observedValue : (this.observedValue = Price.builder());
            return result;
        }

        @Override
        public ObservationBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public ObservationBuilder setObservationIdentifier(ObservationIdentifier observationIdentifier) {
            this.observationIdentifier = observationIdentifier == null ? null : observationIdentifier.toBuilder();
            return this;
        }

        @Override
        public ObservationBuilder setObservedValue(Price observedValue) {
            this.observedValue = observedValue == null ? null : observedValue.toBuilder();
            return this;
        }

        @Override
        public Observation build() {
            return new ObservationImpl(this);
        }

        @Override
        public ObservationBuilder toBuilder() {
            return this;
        }

        @Override
        public ObservationBuilder prune() {
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.observationIdentifier != null && !this.observationIdentifier.prune().hasData()) {
                this.observationIdentifier = null;
            }
            if (this.observedValue != null && !this.observedValue.prune().hasData()) {
                this.observedValue = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getObservationIdentifier() != null && this.getObservationIdentifier().hasData()) {
                return true;
            }
            return this.getObservedValue() != null && this.getObservedValue().hasData();
        }

        public ObservationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ObservationBuilder o = (ObservationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservationIdentifier(), (RosettaModelObjectBuilder)o.getObservationIdentifier(), this::setObservationIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservedValue(), (RosettaModelObjectBuilder)o.getObservedValue(), this::setObservedValue);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Observation _that = this.getType().cast(o);
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.observationIdentifier, _that.getObservationIdentifier())) {
                return false;
            }
            return Objects.equals(this.observedValue, _that.getObservedValue());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.observationIdentifier != null ? this.observationIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.observedValue != null ? this.observedValue.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationBuilder {meta=" + this.meta + ", observationIdentifier=" + this.observationIdentifier + ", observedValue=" + this.observedValue + '}';
        }
    }

    public static class ObservationImpl
    implements Observation {
        private final MetaFields meta;
        private final ObservationIdentifier observationIdentifier;
        private final Price observedValue;

        protected ObservationImpl(ObservationBuilder builder) {
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.observationIdentifier = Optional.ofNullable(builder.getObservationIdentifier()).map(f -> f.build()).orElse(null);
            this.observedValue = Optional.ofNullable(builder.getObservedValue()).map(f -> f.build()).orElse(null);
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public ObservationIdentifier getObservationIdentifier() {
            return this.observationIdentifier;
        }

        @Override
        public Price getObservedValue() {
            return this.observedValue;
        }

        @Override
        public Observation build() {
            return this;
        }

        @Override
        public ObservationBuilder toBuilder() {
            ObservationBuilder builder = Observation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObservationBuilder builder) {
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getObservationIdentifier()).ifPresent(builder::setObservationIdentifier);
            Optional.ofNullable(this.getObservedValue()).ifPresent(builder::setObservedValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Observation _that = this.getType().cast(o);
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.observationIdentifier, _that.getObservationIdentifier())) {
                return false;
            }
            return Objects.equals(this.observedValue, _that.getObservedValue());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.observationIdentifier != null ? this.observationIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.observedValue != null ? this.observedValue.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Observation {meta=" + this.meta + ", observationIdentifier=" + this.observationIdentifier + ", observedValue=" + this.observedValue + '}';
        }
    }

    public static interface ObservationBuilder
    extends Observation,
    RosettaModelObjectBuilder {
        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public ObservationIdentifier.ObservationIdentifierBuilder getOrCreateObservationIdentifier();

        @Override
        public ObservationIdentifier.ObservationIdentifierBuilder getObservationIdentifier();

        public Price.PriceBuilder getOrCreateObservedValue();

        @Override
        public Price.PriceBuilder getObservedValue();

        public ObservationBuilder setMeta(MetaFields var1);

        public ObservationBuilder setObservationIdentifier(ObservationIdentifier var1);

        public ObservationBuilder setObservedValue(Price var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationIdentifier"), processor, ObservationIdentifier.ObservationIdentifierBuilder.class, this.getObservationIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observedValue"), processor, Price.PriceBuilder.class, this.getObservedValue(), new AttributeMeta[0]);
        }

        public ObservationBuilder prune();
    }
}

