/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.staticdata.party.PartyReferencePayerReceiver;
import cdm.observable.common.TimeTypeEnum;
import cdm.observable.event.meta.FeaturePaymentMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface FeaturePayment
extends RosettaModelObject,
GlobalKey {
    public static final FeaturePaymentMeta metaData = new FeaturePaymentMeta();

    public FeaturePayment build();

    public FeaturePaymentBuilder toBuilder();

    public BigDecimal getAmount();

    public FieldWithMetaString getCurrency();

    public BigDecimal getLevelPercentage();

    public MetaFields getMeta();

    public PartyReferencePayerReceiver getPayerReceiver();

    public AdjustableOrRelativeDate getPaymentDate();

    public TimeTypeEnum getTime();

    default public RosettaMetaData<? extends FeaturePayment> metaData() {
        return metaData;
    }

    public static FeaturePaymentBuilder builder() {
        return new FeaturePaymentBuilderImpl();
    }

    default public Class<? extends FeaturePayment> getType() {
        return FeaturePayment.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("levelPercentage"), BigDecimal.class, (Object)this.getLevelPercentage(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("time"), TimeTypeEnum.class, (Object)this.getTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, FieldWithMetaString.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PartyReferencePayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.class, this.getPaymentDate(), new AttributeMeta[0]);
    }

    public static class FeaturePaymentBuilderImpl
    implements FeaturePaymentBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected BigDecimal amount;
        protected FieldWithMetaString.FieldWithMetaStringBuilder currency;
        protected BigDecimal levelPercentage;
        protected MetaFields.MetaFieldsBuilder meta;
        protected PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder payerReceiver;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder paymentDate;
        protected TimeTypeEnum time;

        @Override
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCurrency() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.currency != null ? this.currency : (this.currency = FieldWithMetaString.builder());
            return result;
        }

        @Override
        public BigDecimal getLevelPercentage() {
            return this.levelPercentage;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        public PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder getOrCreatePayerReceiver() {
            PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder result = this.payerReceiver != null ? this.payerReceiver : (this.payerReceiver = PartyReferencePayerReceiver.builder());
            return result;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreatePaymentDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.paymentDate != null ? this.paymentDate : (this.paymentDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        public TimeTypeEnum getTime() {
            return this.time;
        }

        @Override
        public FeaturePaymentBuilder setAmount(BigDecimal amount) {
            this.amount = amount == null ? null : amount;
            return this;
        }

        @Override
        public FeaturePaymentBuilder setCurrency(FieldWithMetaString currency) {
            this.currency = currency == null ? null : currency.toBuilder();
            return this;
        }

        @Override
        public FeaturePaymentBuilder setCurrencyValue(String currency) {
            this.getOrCreateCurrency().setValue(currency);
            return this;
        }

        @Override
        public FeaturePaymentBuilder setLevelPercentage(BigDecimal levelPercentage) {
            this.levelPercentage = levelPercentage == null ? null : levelPercentage;
            return this;
        }

        @Override
        public FeaturePaymentBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public FeaturePaymentBuilder setPayerReceiver(PartyReferencePayerReceiver payerReceiver) {
            this.payerReceiver = payerReceiver == null ? null : payerReceiver.toBuilder();
            return this;
        }

        @Override
        public FeaturePaymentBuilder setPaymentDate(AdjustableOrRelativeDate paymentDate) {
            this.paymentDate = paymentDate == null ? null : paymentDate.toBuilder();
            return this;
        }

        @Override
        public FeaturePaymentBuilder setTime(TimeTypeEnum time) {
            this.time = time == null ? null : time;
            return this;
        }

        @Override
        public FeaturePayment build() {
            return new FeaturePaymentImpl(this);
        }

        @Override
        public FeaturePaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public FeaturePaymentBuilder prune() {
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.payerReceiver != null && !this.payerReceiver.prune().hasData()) {
                this.payerReceiver = null;
            }
            if (this.paymentDate != null && !this.paymentDate.prune().hasData()) {
                this.paymentDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAmount() != null) {
                return true;
            }
            if (this.getCurrency() != null) {
                return true;
            }
            if (this.getLevelPercentage() != null) {
                return true;
            }
            if (this.getPayerReceiver() != null && this.getPayerReceiver().hasData()) {
                return true;
            }
            if (this.getPaymentDate() != null && this.getPaymentDate().hasData()) {
                return true;
            }
            return this.getTime() != null;
        }

        public FeaturePaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FeaturePaymentBuilder o = (FeaturePaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiver(), (RosettaModelObjectBuilder)o.getPayerReceiver(), this::setPayerReceiver);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDate(), (RosettaModelObjectBuilder)o.getPaymentDate(), this::setPaymentDate);
            merger.mergeBasic((Object)this.getAmount(), (Object)o.getAmount(), this::setAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLevelPercentage(), (Object)o.getLevelPercentage(), this::setLevelPercentage, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTime(), (Object)o.getTime(), this::setTime, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FeaturePayment _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.levelPercentage, _that.getLevelPercentage())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            return Objects.equals((Object)this.time, (Object)_that.getTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.levelPercentage != null ? this.levelPercentage.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.time != null ? ((Object)((Object)this.time)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FeaturePaymentBuilder {amount=" + this.amount + ", currency=" + this.currency + ", levelPercentage=" + this.levelPercentage + ", meta=" + this.meta + ", payerReceiver=" + this.payerReceiver + ", paymentDate=" + this.paymentDate + ", time=" + (Object)((Object)this.time) + '}';
        }
    }

    public static class FeaturePaymentImpl
    implements FeaturePayment {
        private final BigDecimal amount;
        private final FieldWithMetaString currency;
        private final BigDecimal levelPercentage;
        private final MetaFields meta;
        private final PartyReferencePayerReceiver payerReceiver;
        private final AdjustableOrRelativeDate paymentDate;
        private final TimeTypeEnum time;

        protected FeaturePaymentImpl(FeaturePaymentBuilder builder) {
            this.amount = builder.getAmount();
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
            this.levelPercentage = builder.getLevelPercentage();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.payerReceiver = Optional.ofNullable(builder.getPayerReceiver()).map(f -> f.build()).orElse(null);
            this.paymentDate = Optional.ofNullable(builder.getPaymentDate()).map(f -> f.build()).orElse(null);
            this.time = builder.getTime();
        }

        @Override
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        public FieldWithMetaString getCurrency() {
            return this.currency;
        }

        @Override
        public BigDecimal getLevelPercentage() {
            return this.levelPercentage;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PartyReferencePayerReceiver getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        public AdjustableOrRelativeDate getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public TimeTypeEnum getTime() {
            return this.time;
        }

        @Override
        public FeaturePayment build() {
            return this;
        }

        @Override
        public FeaturePaymentBuilder toBuilder() {
            FeaturePaymentBuilder builder = FeaturePayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FeaturePaymentBuilder builder) {
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getLevelPercentage()).ifPresent(builder::setLevelPercentage);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getPayerReceiver()).ifPresent(builder::setPayerReceiver);
            Optional.ofNullable(this.getPaymentDate()).ifPresent(builder::setPaymentDate);
            Optional.ofNullable(this.getTime()).ifPresent(builder::setTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FeaturePayment _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.levelPercentage, _that.getLevelPercentage())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            return Objects.equals((Object)this.time, (Object)_that.getTime());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.levelPercentage != null ? this.levelPercentage.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.time != null ? ((Object)((Object)this.time)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FeaturePayment {amount=" + this.amount + ", currency=" + this.currency + ", levelPercentage=" + this.levelPercentage + ", meta=" + this.meta + ", payerReceiver=" + this.payerReceiver + ", paymentDate=" + this.paymentDate + ", time=" + (Object)((Object)this.time) + '}';
        }
    }

    public static interface FeaturePaymentBuilder
    extends FeaturePayment,
    RosettaModelObjectBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCurrency();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getCurrency();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder getOrCreatePayerReceiver();

        @Override
        public PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder getPayerReceiver();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreatePaymentDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getPaymentDate();

        public FeaturePaymentBuilder setAmount(BigDecimal var1);

        public FeaturePaymentBuilder setCurrency(FieldWithMetaString var1);

        public FeaturePaymentBuilder setCurrencyValue(String var1);

        public FeaturePaymentBuilder setLevelPercentage(BigDecimal var1);

        public FeaturePaymentBuilder setMeta(MetaFields var1);

        public FeaturePaymentBuilder setPayerReceiver(PartyReferencePayerReceiver var1);

        public FeaturePaymentBuilder setPaymentDate(AdjustableOrRelativeDate var1);

        public FeaturePaymentBuilder setTime(TimeTypeEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("levelPercentage"), BigDecimal.class, (Object)this.getLevelPercentage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("time"), TimeTypeEnum.class, (Object)this.getTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PartyReferencePayerReceiver.PartyReferencePayerReceiverBuilder.class, this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getPaymentDate(), new AttributeMeta[0]);
        }

        public FeaturePaymentBuilder prune();
    }
}

