/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.observable.event.PubliclyAvailableInformation;
import cdm.observable.event.meta.CreditEventNoticeMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface CreditEventNotice
extends RosettaModelObject {
    public static final CreditEventNoticeMeta metaData = new CreditEventNoticeMeta();

    public CreditEventNotice build();

    public CreditEventNoticeBuilder toBuilder();

    public BusinessCenterEnum getBusinessCenter();

    public List<CounterpartyRoleEnum> getNotifyingParty();

    public PubliclyAvailableInformation getPubliclyAvailableInformation();

    default public RosettaMetaData<? extends CreditEventNotice> metaData() {
        return metaData;
    }

    public static CreditEventNoticeBuilder builder() {
        return new CreditEventNoticeBuilderImpl();
    }

    default public Class<? extends CreditEventNotice> getType() {
        return CreditEventNotice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("businessCenter"), BusinessCenterEnum.class, (Object)this.getBusinessCenter(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notifyingParty"), CounterpartyRoleEnum.class, this.getNotifyingParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("publiclyAvailableInformation"), processor, PubliclyAvailableInformation.class, this.getPubliclyAvailableInformation(), new AttributeMeta[0]);
    }

    public static class CreditEventNoticeBuilderImpl
    implements CreditEventNoticeBuilder {
        protected BusinessCenterEnum businessCenter;
        protected List<CounterpartyRoleEnum> notifyingParty = new ArrayList<CounterpartyRoleEnum>();
        protected PubliclyAvailableInformation.PubliclyAvailableInformationBuilder publiclyAvailableInformation;

        @Override
        public BusinessCenterEnum getBusinessCenter() {
            return this.businessCenter;
        }

        @Override
        public List<CounterpartyRoleEnum> getNotifyingParty() {
            return this.notifyingParty;
        }

        @Override
        public PubliclyAvailableInformation.PubliclyAvailableInformationBuilder getPubliclyAvailableInformation() {
            return this.publiclyAvailableInformation;
        }

        @Override
        public PubliclyAvailableInformation.PubliclyAvailableInformationBuilder getOrCreatePubliclyAvailableInformation() {
            PubliclyAvailableInformation.PubliclyAvailableInformationBuilder result = this.publiclyAvailableInformation != null ? this.publiclyAvailableInformation : (this.publiclyAvailableInformation = PubliclyAvailableInformation.builder());
            return result;
        }

        @Override
        public CreditEventNoticeBuilder setBusinessCenter(BusinessCenterEnum businessCenter) {
            this.businessCenter = businessCenter == null ? null : businessCenter;
            return this;
        }

        @Override
        public CreditEventNoticeBuilder addNotifyingParty(CounterpartyRoleEnum notifyingParty) {
            if (notifyingParty != null) {
                this.notifyingParty.add(notifyingParty);
            }
            return this;
        }

        @Override
        public CreditEventNoticeBuilder addNotifyingParty(CounterpartyRoleEnum notifyingParty, int _idx) {
            this.getIndex(this.notifyingParty, _idx, () -> notifyingParty);
            return this;
        }

        @Override
        public CreditEventNoticeBuilder addNotifyingParty(List<? extends CounterpartyRoleEnum> notifyingPartys) {
            if (notifyingPartys != null) {
                for (CounterpartyRoleEnum counterpartyRoleEnum : notifyingPartys) {
                    this.notifyingParty.add(counterpartyRoleEnum);
                }
            }
            return this;
        }

        @Override
        public CreditEventNoticeBuilder setNotifyingParty(List<? extends CounterpartyRoleEnum> notifyingPartys) {
            this.notifyingParty = notifyingPartys == null ? new ArrayList<CounterpartyRoleEnum>() : (List)notifyingPartys.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CreditEventNoticeBuilder setPubliclyAvailableInformation(PubliclyAvailableInformation publiclyAvailableInformation) {
            this.publiclyAvailableInformation = publiclyAvailableInformation == null ? null : publiclyAvailableInformation.toBuilder();
            return this;
        }

        @Override
        public CreditEventNotice build() {
            return new CreditEventNoticeImpl(this);
        }

        @Override
        public CreditEventNoticeBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditEventNoticeBuilder prune() {
            if (this.publiclyAvailableInformation != null && !this.publiclyAvailableInformation.prune().hasData()) {
                this.publiclyAvailableInformation = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBusinessCenter() != null) {
                return true;
            }
            if (this.getNotifyingParty() != null && !this.getNotifyingParty().isEmpty()) {
                return true;
            }
            return this.getPubliclyAvailableInformation() != null && this.getPubliclyAvailableInformation().hasData();
        }

        public CreditEventNoticeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CreditEventNoticeBuilder o = (CreditEventNoticeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPubliclyAvailableInformation(), (RosettaModelObjectBuilder)o.getPubliclyAvailableInformation(), this::setPubliclyAvailableInformation);
            merger.mergeBasic((Object)this.getBusinessCenter(), (Object)o.getBusinessCenter(), this::setBusinessCenter, new AttributeMeta[0]);
            merger.mergeBasic(this.getNotifyingParty(), o.getNotifyingParty(), this::addNotifyingParty);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditEventNotice _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.businessCenter, (Object)_that.getBusinessCenter())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notifyingParty, _that.getNotifyingParty())) {
                return false;
            }
            return Objects.equals(this.publiclyAvailableInformation, _that.getPubliclyAvailableInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.businessCenter != null ? ((Object)((Object)this.businessCenter)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notifyingParty != null ? this.notifyingParty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.publiclyAvailableInformation != null ? this.publiclyAvailableInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditEventNoticeBuilder {businessCenter=" + (Object)((Object)this.businessCenter) + ", notifyingParty=" + this.notifyingParty + ", publiclyAvailableInformation=" + this.publiclyAvailableInformation + '}';
        }
    }

    public static class CreditEventNoticeImpl
    implements CreditEventNotice {
        private final BusinessCenterEnum businessCenter;
        private final List<CounterpartyRoleEnum> notifyingParty;
        private final PubliclyAvailableInformation publiclyAvailableInformation;

        protected CreditEventNoticeImpl(CreditEventNoticeBuilder builder) {
            this.businessCenter = builder.getBusinessCenter();
            this.notifyingParty = Optional.ofNullable(builder.getNotifyingParty()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.publiclyAvailableInformation = Optional.ofNullable(builder.getPubliclyAvailableInformation()).map(f -> f.build()).orElse(null);
        }

        @Override
        public BusinessCenterEnum getBusinessCenter() {
            return this.businessCenter;
        }

        @Override
        public List<CounterpartyRoleEnum> getNotifyingParty() {
            return this.notifyingParty;
        }

        @Override
        public PubliclyAvailableInformation getPubliclyAvailableInformation() {
            return this.publiclyAvailableInformation;
        }

        @Override
        public CreditEventNotice build() {
            return this;
        }

        @Override
        public CreditEventNoticeBuilder toBuilder() {
            CreditEventNoticeBuilder builder = CreditEventNotice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditEventNoticeBuilder builder) {
            Optional.ofNullable(this.getBusinessCenter()).ifPresent(builder::setBusinessCenter);
            Optional.ofNullable(this.getNotifyingParty()).ifPresent(builder::setNotifyingParty);
            Optional.ofNullable(this.getPubliclyAvailableInformation()).ifPresent(builder::setPubliclyAvailableInformation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditEventNotice _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.businessCenter, (Object)_that.getBusinessCenter())) {
                return false;
            }
            if (!ListEquals.listEquals(this.notifyingParty, _that.getNotifyingParty())) {
                return false;
            }
            return Objects.equals(this.publiclyAvailableInformation, _that.getPubliclyAvailableInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.businessCenter != null ? ((Object)((Object)this.businessCenter)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.notifyingParty != null ? this.notifyingParty.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.publiclyAvailableInformation != null ? this.publiclyAvailableInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditEventNotice {businessCenter=" + (Object)((Object)this.businessCenter) + ", notifyingParty=" + this.notifyingParty + ", publiclyAvailableInformation=" + this.publiclyAvailableInformation + '}';
        }
    }

    public static interface CreditEventNoticeBuilder
    extends CreditEventNotice,
    RosettaModelObjectBuilder {
        public PubliclyAvailableInformation.PubliclyAvailableInformationBuilder getOrCreatePubliclyAvailableInformation();

        @Override
        public PubliclyAvailableInformation.PubliclyAvailableInformationBuilder getPubliclyAvailableInformation();

        public CreditEventNoticeBuilder setBusinessCenter(BusinessCenterEnum var1);

        public CreditEventNoticeBuilder addNotifyingParty(CounterpartyRoleEnum var1);

        public CreditEventNoticeBuilder addNotifyingParty(CounterpartyRoleEnum var1, int var2);

        public CreditEventNoticeBuilder addNotifyingParty(List<? extends CounterpartyRoleEnum> var1);

        public CreditEventNoticeBuilder setNotifyingParty(List<? extends CounterpartyRoleEnum> var1);

        public CreditEventNoticeBuilder setPubliclyAvailableInformation(PubliclyAvailableInformation var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("businessCenter"), BusinessCenterEnum.class, (Object)this.getBusinessCenter(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notifyingParty"), CounterpartyRoleEnum.class, this.getNotifyingParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("publiclyAvailableInformation"), processor, PubliclyAvailableInformation.PubliclyAvailableInformationBuilder.class, this.getPubliclyAvailableInformation(), new AttributeMeta[0]);
        }

        public CreditEventNoticeBuilder prune();
    }
}

