/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.common.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.functions.FilterQuantityByCurrencyExists;
import cdm.base.math.functions.FilterQuantityByFinancialUnit;
import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.math.BigDecimal;
import java.util.List;

@ImplementedBy(value=CashPriceQuantityNoOfUnitsTriangulationDefault.class)
public abstract class CashPriceQuantityNoOfUnitsTriangulation
implements RosettaFunction {
    @Inject
    protected FilterQuantityByCurrencyExists filterQuantityByCurrencyExists;
    @Inject
    protected FilterQuantityByFinancialUnit filterQuantityByFinancialUnit;

    public Boolean evaluate(List<? extends NonNegativeQuantitySchedule> quantity, List<? extends PriceSchedule> price) {
        Boolean success = this.doEvaluate(quantity, price);
        return success;
    }

    protected abstract Boolean doEvaluate(List<? extends NonNegativeQuantitySchedule> var1, List<? extends PriceSchedule> var2);

    protected abstract Mapper<BigDecimal> notional(List<? extends NonNegativeQuantitySchedule> var1, List<? extends PriceSchedule> var2);

    protected abstract Mapper<BigDecimal> noOfUnits(List<? extends NonNegativeQuantitySchedule> var1, List<? extends PriceSchedule> var2);

    protected abstract Mapper<BigDecimal> cashPrice(List<? extends NonNegativeQuantitySchedule> var1, List<? extends PriceSchedule> var2);

    public static class CashPriceQuantityNoOfUnitsTriangulationDefault
    extends CashPriceQuantityNoOfUnitsTriangulation {
        @Override
        protected Boolean doEvaluate(List<? extends NonNegativeQuantitySchedule> quantity, List<? extends PriceSchedule> price) {
            Boolean success = null;
            return this.assignOutput(success, quantity, price);
        }

        protected Boolean assignOutput(Boolean success, List<? extends NonNegativeQuantitySchedule> quantity, List<? extends PriceSchedule> price) {
            success = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.cashPrice(quantity, price).get()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.noOfUnits(quantity, price).get())))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.notional(quantity, price).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperMaths.multiply((Mapper)MapperS.of((Object)((BigDecimal)this.cashPrice(quantity, price).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.noOfUnits(quantity, price).get()))), (Mapper)MapperS.of((Object)((BigDecimal)this.notional(quantity, price).get())), (CardinalityOperator)CardinalityOperator.All);
                }
                return MapperS.ofNull();
            })).get();
            return success;
        }

        @Override
        protected Mapper<BigDecimal> notional(List<? extends NonNegativeQuantitySchedule> quantity, List<? extends PriceSchedule> price) {
            return (Mapper)((MapperC)MapperC.of(this.filterQuantityByCurrencyExists.evaluate(MapperC.of(quantity).getMulti())).mapItem(item -> item.map("getValue", measureBase -> measureBase.getValue())).apply(item -> ExpressionOperators.distinct((Mapper)item))).apply(item -> MapperS.of((Object)((BigDecimal)item.get())));
        }

        @Override
        protected Mapper<BigDecimal> noOfUnits(List<? extends NonNegativeQuantitySchedule> quantity, List<? extends PriceSchedule> price) {
            return (Mapper)MapperC.of(this.filterQuantityByFinancialUnit.evaluate(MapperC.of(quantity).getMulti(), (FinancialUnitEnum)((Object)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)).get()))).mapItem(item -> item.map("getValue", measureBase -> measureBase.getValue())).apply(item -> MapperS.of((Object)((BigDecimal)item.get())));
        }

        @Override
        protected Mapper<BigDecimal> cashPrice(List<? extends NonNegativeQuantitySchedule> quantity, List<? extends PriceSchedule> price) {
            return MapperS.of((Object)((BigDecimal)MapperC.of(price).map("getValue", measureBase -> measureBase.getValue()).get()));
        }
    }
}

