/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PriceScheduleUnitOfAmountExists")
@ImplementedBy(value=Default.class)
public interface PriceScheduleUnitOfAmountExists
extends Validator<PriceSchedule> {
    public static final String NAME = "PriceScheduleUnitOfAmountExists";
    public static final String DEFINITION = "if priceExpression -> priceType = PriceTypeEnum -> Variance or priceExpression -> priceType = PriceTypeEnum -> Volatility or priceExpression -> priceType = PriceTypeEnum -> Correlation then unit is absent and perUnitOf is absent else unit exists and perUnitOf exists";

    public ValidationResult<PriceSchedule> validate(RosettaPath var1, PriceSchedule var2);

    public static class NoOp
    implements PriceScheduleUnitOfAmountExists {
        @Override
        public ValidationResult<PriceSchedule> validate(RosettaPath path, PriceSchedule priceSchedule) {
            return ValidationResult.success((String)PriceScheduleUnitOfAmountExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleUnitOfAmountExists.DEFINITION);
        }
    }

    public static class Default
    implements PriceScheduleUnitOfAmountExists {
        @Override
        public ValidationResult<PriceSchedule> validate(RosettaPath path, PriceSchedule priceSchedule) {
            ComparisonResult result = this.executeDataRule(priceSchedule);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PriceScheduleUnitOfAmountExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleUnitOfAmountExists.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PriceScheduleUnitOfAmountExists failed.";
            }
            return ValidationResult.failure((String)PriceScheduleUnitOfAmountExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleUnitOfAmountExists.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PriceSchedule priceSchedule) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceSchedule).map("getPriceExpression", _priceSchedule -> _priceSchedule.getPriceExpression()).map("getPriceType", priceExpression -> priceExpression.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.VARIANCE)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceSchedule).map("getPriceExpression", _priceSchedule -> _priceSchedule.getPriceExpression()).map("getPriceType", priceExpression -> priceExpression.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.VOLATILITY)), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceSchedule).map("getPriceExpression", _priceSchedule -> _priceSchedule.getPriceExpression()).map("getPriceType", priceExpression -> priceExpression.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.CORRELATION)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notExists((Mapper)MapperS.of((Object)priceSchedule).map("getUnit", measureBase -> measureBase.getUnit())).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)priceSchedule).map("getPerUnitOf", _priceSchedule -> _priceSchedule.getPerUnitOf())));
                    }
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)priceSchedule).map("getUnit", measureBase -> measureBase.getUnit())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)priceSchedule).map("getPerUnitOf", _priceSchedule -> _priceSchedule.getPerUnitOf()))).asMapper();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

