/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PriceSchedulePositiveCashPrice")
@ImplementedBy(value=Default.class)
public interface PriceSchedulePositiveCashPrice
extends Validator<PriceSchedule> {
    public static final String NAME = "PriceSchedulePositiveCashPrice";
    public static final String DEFINITION = "if priceExpression -> priceType = PriceTypeEnum -> CashPrice then value > 0";

    public ValidationResult<PriceSchedule> validate(RosettaPath var1, PriceSchedule var2);

    public static class NoOp
    implements PriceSchedulePositiveCashPrice {
        @Override
        public ValidationResult<PriceSchedule> validate(RosettaPath path, PriceSchedule priceSchedule) {
            return ValidationResult.success((String)PriceSchedulePositiveCashPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceSchedulePositiveCashPrice.DEFINITION);
        }
    }

    public static class Default
    implements PriceSchedulePositiveCashPrice {
        @Override
        public ValidationResult<PriceSchedule> validate(RosettaPath path, PriceSchedule priceSchedule) {
            ComparisonResult result = this.executeDataRule(priceSchedule);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PriceSchedulePositiveCashPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceSchedulePositiveCashPrice.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PriceSchedulePositiveCashPrice failed.";
            }
            return ValidationResult.failure((String)PriceSchedulePositiveCashPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceSchedulePositiveCashPrice.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PriceSchedule priceSchedule) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceSchedule).map("getPriceExpression", _priceSchedule -> _priceSchedule.getPriceExpression()).map("getPriceType", priceExpression -> priceExpression.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.CASH_PRICE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)priceSchedule).map("getValue", measureBase -> measureBase.getValue()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All);
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

