/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PriceScheduleCurrencyUnitForInterestRate")
@ImplementedBy(value=Default.class)
public interface PriceScheduleCurrencyUnitForInterestRate
extends Validator<PriceSchedule> {
    public static final String NAME = "PriceScheduleCurrencyUnitForInterestRate";
    public static final String DEFINITION = "if priceExpression -> priceType = PriceTypeEnum -> InterestRate then unit -> currency exists";

    public ValidationResult<PriceSchedule> validate(RosettaPath var1, PriceSchedule var2);

    public static class NoOp
    implements PriceScheduleCurrencyUnitForInterestRate {
        @Override
        public ValidationResult<PriceSchedule> validate(RosettaPath path, PriceSchedule priceSchedule) {
            return ValidationResult.success((String)PriceScheduleCurrencyUnitForInterestRate.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleCurrencyUnitForInterestRate.DEFINITION);
        }
    }

    public static class Default
    implements PriceScheduleCurrencyUnitForInterestRate {
        @Override
        public ValidationResult<PriceSchedule> validate(RosettaPath path, PriceSchedule priceSchedule) {
            ComparisonResult result = this.executeDataRule(priceSchedule);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PriceScheduleCurrencyUnitForInterestRate.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleCurrencyUnitForInterestRate.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PriceScheduleCurrencyUnitForInterestRate failed.";
            }
            return ValidationResult.failure((String)PriceScheduleCurrencyUnitForInterestRate.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleCurrencyUnitForInterestRate.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PriceSchedule priceSchedule) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceSchedule).map("getPriceExpression", _priceSchedule -> _priceSchedule.getPriceExpression()).map("getPriceType", priceExpression -> priceExpression.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)priceSchedule).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue()));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

