/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.PriceExpression;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PriceExpressionSpreadPrice")
@ImplementedBy(value=Default.class)
public interface PriceExpressionSpreadPrice
extends Validator<PriceExpression> {
    public static final String NAME = "PriceExpressionSpreadPrice";
    public static final String DEFINITION = "if spreadType exists then priceType = PriceTypeEnum -> AssetPrice or priceType = PriceTypeEnum -> ExchangeRate or priceType = PriceTypeEnum -> InterestRate";

    public ValidationResult<PriceExpression> validate(RosettaPath var1, PriceExpression var2);

    public static class NoOp
    implements PriceExpressionSpreadPrice {
        @Override
        public ValidationResult<PriceExpression> validate(RosettaPath path, PriceExpression priceExpression) {
            return ValidationResult.success((String)PriceExpressionSpreadPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceExpression", (RosettaPath)path, (String)PriceExpressionSpreadPrice.DEFINITION);
        }
    }

    public static class Default
    implements PriceExpressionSpreadPrice {
        @Override
        public ValidationResult<PriceExpression> validate(RosettaPath path, PriceExpression priceExpression) {
            ComparisonResult result = this.executeDataRule(priceExpression);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PriceExpressionSpreadPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceExpression", (RosettaPath)path, (String)PriceExpressionSpreadPrice.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PriceExpressionSpreadPrice failed.";
            }
            return ValidationResult.failure((String)PriceExpressionSpreadPrice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceExpression", (RosettaPath)path, (String)PriceExpressionSpreadPrice.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PriceExpression priceExpression) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)priceExpression).map("getSpreadType", _priceExpression -> _priceExpression.getSpreadType())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceExpression).map("getPriceType", _priceExpression -> _priceExpression.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.ASSET_PRICE)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceExpression).map("getPriceType", _priceExpression -> _priceExpression.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.EXCHANGE_RATE)), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)priceExpression).map("getPriceType", _priceExpression -> _priceExpression.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE)), (CardinalityOperator)CardinalityOperator.All));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

