/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.PriceExpression;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;

@RosettaDataRule(value="PriceExpressionChoice")
@ImplementedBy(value=Default.class)
public interface PriceExpressionChoice
extends Validator<PriceExpression> {
    public static final String NAME = "PriceExpressionChoice";
    public static final String DEFINITION = "optional choice cashPrice, cleanOrDirty, capFloor";

    public ValidationResult<PriceExpression> validate(RosettaPath var1, PriceExpression var2);

    public static class NoOp
    implements PriceExpressionChoice {
        @Override
        public ValidationResult<PriceExpression> validate(RosettaPath path, PriceExpression priceExpression) {
            return ValidationResult.success((String)PriceExpressionChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceExpression", (RosettaPath)path, (String)PriceExpressionChoice.DEFINITION);
        }
    }

    public static class Default
    implements PriceExpressionChoice {
        @Override
        public ValidationResult<PriceExpression> validate(RosettaPath path, PriceExpression priceExpression) {
            ComparisonResult result = this.executeDataRule(priceExpression);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PriceExpressionChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceExpression", (RosettaPath)path, (String)PriceExpressionChoice.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PriceExpressionChoice failed.";
            }
            return ValidationResult.failure((String)PriceExpressionChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceExpression", (RosettaPath)path, (String)PriceExpressionChoice.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PriceExpression priceExpression) {
            try {
                ComparisonResult result = ExpressionOperators.choice((Mapper)MapperS.of((Object)priceExpression), Arrays.asList("cashPrice", "cleanOrDirty", "capFloor"), (ValidationResult.ChoiceRuleValidationMethod)ValidationResult.ChoiceRuleValidationMethod.OPTIONAL);
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

