/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.ObservationSource;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="ObservationSourceCurveInformationSource")
@ImplementedBy(value=Default.class)
public interface ObservationSourceCurveInformationSource
extends Validator<ObservationSource> {
    public static final String NAME = "ObservationSourceCurveInformationSource";
    public static final String DEFINITION = "(curve exists and informationSource exists) or curve exists or informationSource exists";

    public ValidationResult<ObservationSource> validate(RosettaPath var1, ObservationSource var2);

    public static class NoOp
    implements ObservationSourceCurveInformationSource {
        @Override
        public ValidationResult<ObservationSource> validate(RosettaPath path, ObservationSource observationSource) {
            return ValidationResult.success((String)ObservationSourceCurveInformationSource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ObservationSource", (RosettaPath)path, (String)ObservationSourceCurveInformationSource.DEFINITION);
        }
    }

    public static class Default
    implements ObservationSourceCurveInformationSource {
        @Override
        public ValidationResult<ObservationSource> validate(RosettaPath path, ObservationSource observationSource) {
            ComparisonResult result = this.executeDataRule(observationSource);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)ObservationSourceCurveInformationSource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ObservationSource", (RosettaPath)path, (String)ObservationSourceCurveInformationSource.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition ObservationSourceCurveInformationSource failed.";
            }
            return ValidationResult.failure((String)ObservationSourceCurveInformationSource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ObservationSource", (RosettaPath)path, (String)ObservationSourceCurveInformationSource.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(ObservationSource observationSource) {
            try {
                ComparisonResult result = ExpressionOperators.exists((Mapper)MapperS.of((Object)observationSource).map("getCurve", _observationSource -> _observationSource.getCurve())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)observationSource).map("getInformationSource", _observationSource -> _observationSource.getInformationSource()))).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)observationSource).map("getCurve", _observationSource -> _observationSource.getCurve()))).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)observationSource).map("getInformationSource", _observationSource -> _observationSource.getInformationSource())));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

