/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.Curve;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;

@RosettaDataRule(value="CurveCurve")
@ImplementedBy(value=Default.class)
public interface CurveCurve
extends Validator<Curve> {
    public static final String NAME = "CurveCurve";
    public static final String DEFINITION = "one-of";

    public ValidationResult<Curve> validate(RosettaPath var1, Curve var2);

    public static class NoOp
    implements CurveCurve {
        @Override
        public ValidationResult<Curve> validate(RosettaPath path, Curve curve) {
            return ValidationResult.success((String)CurveCurve.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Curve", (RosettaPath)path, (String)CurveCurve.DEFINITION);
        }
    }

    public static class Default
    implements CurveCurve {
        @Override
        public ValidationResult<Curve> validate(RosettaPath path, Curve curve) {
            ComparisonResult result = this.executeDataRule(curve);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)CurveCurve.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Curve", (RosettaPath)path, (String)CurveCurve.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition CurveCurve failed.";
            }
            return ValidationResult.failure((String)CurveCurve.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Curve", (RosettaPath)path, (String)CurveCurve.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Curve curve) {
            try {
                ComparisonResult result = ExpressionOperators.choice((Mapper)MapperS.of((Object)curve), Arrays.asList("interestRateCurve", "commodityCurve"), (ValidationResult.ChoiceRuleValidationMethod)ValidationResult.ChoiceRuleValidationMethod.REQUIRED);
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

