/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.processor;

import cdm.base.math.CapacityUnitEnum;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.UnitType;
import cdm.observable.asset.PriceExpression;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.SpreadTypeEnum;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.translation.SynonymToEnumMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.MetaFields;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class PriceUnitTypeHelper {
    private final RosettaPath modelPath;
    private final List<Mapping> mappings;
    private final SynonymToEnumMap synonymToEnumMap;
    private final RosettaPath unitCurrencyModelPath;
    private final RosettaPath perUnitOfCurrencyModelPath;
    private final RosettaPath perUnitOfCapacityModelPath;

    public PriceUnitTypeHelper(RosettaPath modelPath, MappingContext context) {
        this.modelPath = modelPath;
        this.mappings = context.getMappings();
        this.synonymToEnumMap = context.getSynonymToEnumMap();
        this.unitCurrencyModelPath = modelPath.getParent().newSubPath("unit").newSubPath("currency").newSubPath("value");
        this.perUnitOfCurrencyModelPath = modelPath.getParent().newSubPath("perUnitOf").newSubPath("currency").newSubPath("value");
        this.perUnitOfCapacityModelPath = modelPath.getParent().newSubPath("perUnitOf").newSubPath("capacityUnit");
    }

    public boolean mapUnitType(Path synonymPath, PriceSchedule.PriceScheduleBuilder priceScheduleBuilder) {
        if (!Optional.ofNullable(priceScheduleBuilder.getPriceExpression()).map(PriceExpression::getPriceType).isPresent()) {
            return false;
        }
        return this.updateCurrencyPerCurrencyUnit(priceScheduleBuilder, synonymPath, "swapStream", "notionalSchedule", "notionalStepSchedule", "currency") || this.updateCurrencyPerCurrencyUnit(priceScheduleBuilder, synonymPath, "capFloorStream", "notionalSchedule", "notionalStepSchedule", "currency") || this.updateCurrencyPerCurrencyUnit(priceScheduleBuilder, synonymPath, "bondOption", "notionalAmount", "currency") || this.updateCurrencyPerCurrencyUnit(priceScheduleBuilder, synonymPath, "fra", "notional", "currency") || this.updateCurrencyPerCurrencyUnit(priceScheduleBuilder, synonymPath, "fixedAmountCalculation", "calculationAmount", "currency") || this.updateCurrencyPerCurrencyUnit(priceScheduleBuilder, synonymPath, "creditDefaultSwap", "protectionTerms", "calculationAmount", "currency") || this.updateCurrencyPerCurrencyUnit(priceScheduleBuilder, synonymPath, "creditDefaultSwapOption", "notionalReference", "href") || this.updateCurrencyPerCurrencyUnit(priceScheduleBuilder, synonymPath, "creditDefaultSwapOption", "creditDefaultSwap", "protectionTerms", "calculationAmount", "currency") || this.updateCurrencyPerCurrencyUnit(priceScheduleBuilder, synonymPath, "interestLeg", "notional", "relativeNotionalAmount", "href") || this.updateCurrencyPerFinancialUnit(priceScheduleBuilder, synonymPath, "netPrice", Collections.singletonList("currency"), FinancialUnitEnum.SHARE) || this.updateCurrencyPerFinancialUnit(priceScheduleBuilder, synonymPath, "returnLeg", Arrays.asList("notional", "notionalAmount", "currency"), FinancialUnitEnum.SHARE) || this.updateCurrencyPerFinancialUnit(priceScheduleBuilder, synonymPath, "equityOption", Arrays.asList("strike", "currency"), this.getPerUnitOfIndexOrShare()) || this.updateCurrencyPerFinancialUnit(priceScheduleBuilder, synonymPath, "equityOption", Arrays.asList("strikePricePerUnit", "currency"), this.getPerUnitOfIndexOrShare()) || this.updateCurrencyPerFinancialUnit(priceScheduleBuilder, synonymPath, "equityOption", Arrays.asList("equityExercise", "settlementCurrency"), this.getPerUnitOfIndexOrShare()) || this.updateFxOption(priceScheduleBuilder, synonymPath) || this.updateCurrencyPerCurrencyUnitFromQuotedCurrencyPair(priceScheduleBuilder, synonymPath, "fxVarianceSwap", Arrays.asList("quotedCurrencyPair", "quoteBasis")) || this.updateCurrencyPerCurrencyUnitFromQuotedCurrencyPair(priceScheduleBuilder, synonymPath, "fxVolatilitySwap", Arrays.asList("quotedCurrencyPair", "quoteBasis")) || this.updateCurrencyPerCurrencyUnit(priceScheduleBuilder, synonymPath, "repo", "nearLeg", "settlementAmount", "currency") || this.updateCurrencyPerCapacityUnit(priceScheduleBuilder, synonymPath, "commodityOption", Arrays.asList("strikePricePerUnit", "currency"), Arrays.asList("notionalQuantity", "quantityUnit")) || this.updateCurrencyPerCapacityUnit(priceScheduleBuilder, synonymPath, "commodityOption", Arrays.asList("strikePricePerUnit", "currency"), Arrays.asList("notionalQuantitySchedule", "notionalStep", "quantityUnit")) || this.updateCurrencyPerCapacityUnit(priceScheduleBuilder, synonymPath, "floatingLeg", Arrays.asList("calculation", "spread", "currency"), Arrays.asList("notionalQuantity", "quantityUnit")) || this.updateCurrencyPerCapacityUnit(priceScheduleBuilder, synonymPath, "floatingLeg", Arrays.asList("calculation", "spread", "currency"), Arrays.asList("notionalQuantitySchedule", "notionalStep", "quantityUnit")) || this.updatePackagePrice(priceScheduleBuilder, synonymPath) || this.updatePackageSpread(priceScheduleBuilder, synonymPath);
    }

    protected FinancialUnitEnum getPerUnitOfIndexOrShare() {
        return this.exists(Arrays.asList("underlyer", "singleUnderlyer", "index", "instrumentId")) ? FinancialUnitEnum.INDEX_UNIT : FinancialUnitEnum.SHARE;
    }

    protected boolean updateCurrencyPerCurrencyUnit(PriceSchedule.PriceScheduleBuilder builder, Path synonymPath, String basePathElement, String ... endsWith) {
        Optional<Mapping> mapping = MappingProcessorUtils.subPath((String)basePathElement, (Path)synonymPath).flatMap(subPath -> MappingProcessorUtils.getNonNullMapping(this.mappings, (Path)subPath, (String[])endsWith));
        return mapping.map(m -> m.getXmlPath().endsWith(new String[]{"href"}) ? this.findReference(synonymPath, (Mapping)m) : m).map(this::toCurrencyUnitType).map(u -> {
            this.updateBuilder(builder, (UnitType.UnitTypeBuilder)u, (UnitType.UnitTypeBuilder)u);
            PriceUnitTypeHelper.updateEmptyMappings(((Mapping)mapping.get()).getXmlPath(), this.mappings, this.unitCurrencyModelPath);
            return true;
        }).orElse(false);
    }

    protected Mapping findReference(Path synonymPath, Mapping referenceMapping) {
        return Optional.ofNullable(referenceMapping).map(Mapping::getXmlValue).map(String::valueOf).flatMap(notionalHef -> this.getNonNullMappingId(this.getBasePath(synonymPath), (String)notionalHef)).map(Mapping::getXmlPath).map(Path::getParent).flatMap(referencedPath -> MappingProcessorUtils.getNonNullMapping(this.mappings, (Path)referencedPath, (String[])new String[]{"currency"})).orElse(null);
    }

    protected boolean updateCurrencyPerCurrencyUnitFromQuotedCurrencyPair(PriceSchedule.PriceScheduleBuilder builder, Path synonymPath, String basePathElement, List<String> quoteBasisRelativePath) {
        return MappingProcessorUtils.subPath((String)basePathElement, (Path)synonymPath).flatMap(subPath -> MappingProcessorUtils.getNonNullMapping(this.mappings, (Path)subPath, (String[])this.toArray(quoteBasisRelativePath))).map(quoteBasisMapping -> {
            Path quoteBasisPath = quoteBasisMapping.getXmlPath();
            Path quotedCurrencyPairPath = quoteBasisPath.getParent();
            Optional currency1Mapping = MappingProcessorUtils.getNonNullMapping(this.mappings, (Path)quotedCurrencyPairPath.addElement("currency1"));
            Optional<UnitType.UnitTypeBuilder> currency1 = currency1Mapping.map(this::toCurrencyUnitType);
            Optional currency2Mapping = MappingProcessorUtils.getNonNullMapping(this.mappings, (Path)quotedCurrencyPairPath.addElement("currency2"));
            Optional<UnitType.UnitTypeBuilder> currency2 = currency2Mapping.map(this::toCurrencyUnitType);
            if (currency1.isPresent() && currency2.isPresent()) {
                String quoteBasis = String.valueOf(quoteBasisMapping.getXmlValue());
                if (quoteBasis.equals("Currency1PerCurrency2")) {
                    this.updateBuilder(builder, currency1.get(), currency2.get());
                    PriceUnitTypeHelper.updateEmptyMappings(((Mapping)currency1Mapping.get()).getXmlPath(), this.mappings, this.unitCurrencyModelPath);
                    PriceUnitTypeHelper.updateEmptyMappings(((Mapping)currency2Mapping.get()).getXmlPath(), this.mappings, this.perUnitOfCurrencyModelPath);
                    return true;
                }
                if (quoteBasis.equals("Currency2PerCurrency1")) {
                    this.updateBuilder(builder, currency2.get(), currency1.get());
                    PriceUnitTypeHelper.updateEmptyMappings(((Mapping)currency2Mapping.get()).getXmlPath(), this.mappings, this.unitCurrencyModelPath);
                    PriceUnitTypeHelper.updateEmptyMappings(((Mapping)currency1Mapping.get()).getXmlPath(), this.mappings, this.perUnitOfCurrencyModelPath);
                    return true;
                }
            }
            return false;
        }).orElse(false);
    }

    protected boolean updateCurrencyPerFinancialUnit(PriceSchedule.PriceScheduleBuilder builder, Path synonymPath, String basePathElement, List<String> endsWith, FinancialUnitEnum perUnitOf) {
        return MappingProcessorUtils.subPath((String)basePathElement, (Path)synonymPath).flatMap(subPath -> MappingProcessorUtils.getNonNullMapping(this.mappings, (Path)subPath, (String[])this.toArray(endsWith))).map(currencyMapping -> {
            this.updateBuilder(builder, this.toCurrencyUnitType((Mapping)currencyMapping), UnitType.builder().setFinancialUnit(perUnitOf));
            PriceUnitTypeHelper.updateEmptyMappings(currencyMapping.getXmlPath(), this.mappings, this.unitCurrencyModelPath);
            return true;
        }).orElse(false);
    }

    protected boolean updateCurrencyPerCapacityUnit(PriceSchedule.PriceScheduleBuilder builder, Path synonymPath, String basePathElement, List<String> unitEndsWith, List<String> perUnitOfEndsWith) {
        Optional basePath = MappingProcessorUtils.subPath((String)basePathElement, (Path)synonymPath);
        Optional<UnitType.UnitTypeBuilder> unitMapping = basePath.flatMap(subPath -> MappingProcessorUtils.getNonNullMapping(this.mappings, (Path)subPath, (String[])this.toArray(unitEndsWith)));
        Optional<UnitType.UnitTypeBuilder> unit = unitMapping.map(this::toCurrencyUnitType);
        Optional<UnitType.UnitTypeBuilder> perUnitOfMapping = basePath.flatMap(subPath -> MappingProcessorUtils.getNonNullMapping(this.mappings, (Path)subPath, (String[])this.toArray(perUnitOfEndsWith)));
        Optional<UnitType.UnitTypeBuilder> perUnitOf = perUnitOfMapping.map(this::toCapacityUnitEnumType);
        return unit.flatMap(uoa -> perUnitOf.map(puoa -> {
            this.updateBuilder(builder, (UnitType.UnitTypeBuilder)uoa, (UnitType.UnitTypeBuilder)puoa);
            PriceUnitTypeHelper.updateEmptyMappings(((Mapping)unitMapping.get()).getXmlPath(), this.mappings, this.unitCurrencyModelPath);
            PriceUnitTypeHelper.updateEmptyMappings(((Mapping)perUnitOfMapping.get()).getXmlPath(), this.mappings, this.perUnitOfCapacityModelPath);
            return true;
        })).orElse(false);
    }

    protected boolean updatePackagePrice(PriceSchedule.PriceScheduleBuilder builder, Path valueSynonymPath) {
        Optional<PriceExpression.PriceExpressionBuilder> priceExpression;
        PriceTypeEnum priceType;
        if (valueSynonymPath.endsWith(new String[]{"quote", "value"}) && (priceType = (PriceTypeEnum)(priceExpression = Optional.ofNullable(builder.getPriceExpression())).map(PriceExpression::getPriceType).orElse(null)) == PriceTypeEnum.CASH_PRICE) {
            Path quoteSynonymPath = valueSynonymPath.getParent();
            Path currencySynonymPath = quoteSynonymPath.addElement("currency");
            Optional unitMapping = MappingProcessorUtils.getNonNullMapping(this.mappings, (Path)currencySynonymPath);
            Optional<UnitType.UnitTypeBuilder> unit = unitMapping.map(this::toCurrencyUnitType);
            return unit.map(u -> {
                this.updateBuilder(builder, (UnitType.UnitTypeBuilder)u, UnitType.builder().setFinancialUnit(FinancialUnitEnum.CONTRACT));
                PriceUnitTypeHelper.updateEmptyMappings(((Mapping)unitMapping.get()).getXmlPath(), this.mappings, this.unitCurrencyModelPath);
                return true;
            }).orElse(false);
        }
        return false;
    }

    protected boolean updatePackageSpread(PriceSchedule.PriceScheduleBuilder builder, Path valueSynonymPath) {
        if (valueSynonymPath.endsWith(new String[]{"quote", "value"})) {
            Optional<PriceExpression.PriceExpressionBuilder> priceExpression = Optional.ofNullable(builder.getPriceExpression());
            PriceTypeEnum priceType = priceExpression.map(PriceExpression::getPriceType).orElse(null);
            SpreadTypeEnum spreadType = priceExpression.map(PriceExpression::getSpreadType).orElse(null);
            if (priceType == PriceTypeEnum.INTEREST_RATE && spreadType == SpreadTypeEnum.SPREAD) {
                Optional<Mapping> unitMapping = this.getPackageSpreadCurrency(valueSynonymPath.getParent());
                Optional<UnitType.UnitTypeBuilder> unit = unitMapping.map(this::toCurrencyUnitType);
                return unit.map(u -> {
                    this.updateBuilder(builder, (UnitType.UnitTypeBuilder)u, (UnitType.UnitTypeBuilder)u);
                    PriceUnitTypeHelper.updateEmptyMappings(((Mapping)unitMapping.get()).getXmlPath(), this.mappings, this.unitCurrencyModelPath);
                    return true;
                }).orElse(false);
            }
        }
        return false;
    }

    private Optional<Mapping> getPackageSpreadCurrency(Path quoteSynonymPath) {
        Optional quoteCurrencyMapping = MappingProcessorUtils.getNonNullMapping(this.mappings, (Path)quoteSynonymPath.addElement("currency"));
        if (quoteCurrencyMapping.isPresent()) {
            return quoteCurrencyMapping;
        }
        return MappingProcessorUtils.getNonNullMapping(this.mappings, (Path)quoteSynonymPath.getParent(), (String[])new String[]{"notionalStepSchedule", "currency"});
    }

    protected void updateBuilder(PriceSchedule.PriceScheduleBuilder builder, UnitType.UnitTypeBuilder unit, UnitType.UnitTypeBuilder perUnitOf) {
        builder.setUnit(unit);
        if (builder.getPriceExpression().getPriceType() != PriceTypeEnum.MULTIPLIER_OF_INDEX_VALUE) {
            builder.setPerUnitOf(perUnitOf);
        }
    }

    protected UnitType.UnitTypeBuilder toCurrencyUnitType(Mapping currencyMapping) {
        String currency = String.valueOf(currencyMapping.getXmlValue());
        String currencyScheme = MappingProcessorUtils.getNonNullMappedValue((Path)currencyMapping.getXmlPath().addElement("currencyScheme"), this.mappings).orElse(null);
        return UnitType.builder().setCurrency(FieldWithMetaString.builder().setValue(currency).setMeta(MetaFields.builder().setScheme(currencyScheme).build()).build());
    }

    protected UnitType.UnitTypeBuilder toCapacityUnitEnumType(Mapping capacityUnitMapping) {
        String value = String.valueOf(capacityUnitMapping.getXmlValue());
        UnitType.UnitTypeBuilder builder = UnitType.builder();
        try {
            this.synonymToEnumMap.getEnumValueOptional(CapacityUnitEnum.class, value).ifPresent(builder::setCapacityUnit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return builder;
    }

    protected Optional<Mapping> getNonNullMappingId(Path startsWith, String id) {
        return this.mappings.stream().filter(m -> startsWith.fullStartMatches(m.getXmlPath())).filter(m -> m.getXmlPath().endsWith(new String[]{"id"})).filter(m -> id.equals(m.getXmlValue())).findFirst();
    }

    protected boolean exists(List<String> pathEndsWith) {
        return this.mappings.stream().filter(m -> m.getXmlPath().endsWith(this.toArray(pathEndsWith))).anyMatch(m -> m.getXmlValue() != null);
    }

    protected boolean updateFxOption(PriceSchedule.PriceScheduleBuilder builder, Path synonymPath) {
        Optional subPath = MappingProcessorUtils.subPath((String)"fxOption", (Path)synonymPath);
        return subPath.flatMap(p -> MappingProcessorUtils.getValueAndUpdateMappings((Path)p.addElement("strike").addElement("strikeQuoteBasis"), this.mappings, (RosettaPath)this.modelPath)).map(quoteBasis -> {
            this.setFxOptionRateUnits(builder, (Path)subPath.get(), (String)quoteBasis);
            return true;
        }).orElse(false);
    }

    protected void setFxOptionRateUnits(PriceSchedule.PriceScheduleBuilder builder, Path subPath, String quoteBasis) {
        UnitType.UnitTypeBuilder callCurrency = MappingProcessorUtils.getNonNullMapping(this.mappings, (Path)subPath, (String[])new String[]{"callCurrencyAmount", "currency"}).map(this::toCurrencyUnitType).orElse(null);
        UnitType.UnitTypeBuilder putCurrency = MappingProcessorUtils.getNonNullMapping(this.mappings, (Path)subPath, (String[])new String[]{"putCurrencyAmount", "currency"}).map(this::toCurrencyUnitType).orElse(null);
        if (quoteBasis.equals("CallCurrencyPerPutCurrency")) {
            builder.setUnit(callCurrency).setPerUnitOf(putCurrency);
        } else if (quoteBasis.equals("PutCurrencyPerCallCurrency")) {
            builder.setUnit(putCurrency).setPerUnitOf(callCurrency);
        }
    }

    protected Path getBasePath(Path synonymPath) {
        Path.PathElement basePathElement = (Path.PathElement)synonymPath.getElements().get(0);
        return new Path().addElement(basePathElement);
    }

    protected String[] toArray(List<String> a) {
        return a.toArray(new String[0]);
    }

    protected static void updateEmptyMappings(Path synonymPath, List<Mapping> mappings, RosettaPath rosettaPath) {
        mappings.stream().filter(p -> synonymPath.fullStartMatches(p.getXmlPath())).forEach(m -> {
            if (m.getRosettaPath() == null || m.getError() != null) {
                MappingProcessorUtils.updateMappingSuccess((Mapping)m, (RosettaPath)rosettaPath);
            }
        });
    }
}

