/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.functions;

import cdm.base.math.UnitType;
import cdm.observable.asset.PriceExpression;
import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;

@ImplementedBy(value=Create_PriceScheduleDefault.class)
public abstract class Create_PriceSchedule
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public PriceSchedule evaluate(BigDecimal amount, UnitType unitOfAmount, UnitType perUnitOfAmount, PriceExpression priceExpression) {
        PriceSchedule.PriceScheduleBuilder price = this.doEvaluate(amount, unitOfAmount, perUnitOfAmount, priceExpression);
        if (price != null) {
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)price);
        }
        return price;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(BigDecimal var1, UnitType var2, UnitType var3, PriceExpression var4);

    public static class Create_PriceScheduleDefault
    extends Create_PriceSchedule {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(BigDecimal amount, UnitType unitOfAmount, UnitType perUnitOfAmount, PriceExpression priceExpression) {
            PriceSchedule.PriceScheduleBuilder price = PriceSchedule.builder();
            return this.assignOutput(price, amount, unitOfAmount, perUnitOfAmount, priceExpression);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder price, BigDecimal amount, UnitType unitOfAmount, UnitType perUnitOfAmount, PriceExpression priceExpression) {
            price.setValue((BigDecimal)MapperS.of((Object)amount).get());
            price.setUnit((UnitType)MapperS.of((Object)unitOfAmount).get());
            price.setPerUnitOf((UnitType)MapperS.of((Object)perUnitOfAmount).get());
            price.setPriceExpression((PriceExpression)MapperS.of((Object)priceExpression).get());
            return Optional.ofNullable(price).map(o -> o.prune()).orElse(null);
        }
    }
}

