/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.functions;

import cdm.base.math.UnitType;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceExpression;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;

@ImplementedBy(value=Create_PriceDefault.class)
public abstract class Create_Price
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Price evaluate(BigDecimal value, UnitType unit, UnitType perUnitOf, PriceExpression priceExpression) {
        Price.PriceBuilder price = this.doEvaluate(value, unit, perUnitOf, priceExpression);
        if (price != null) {
            this.objectValidator.validate(Price.class, (RosettaModelObject)price);
        }
        return price;
    }

    protected abstract Price.PriceBuilder doEvaluate(BigDecimal var1, UnitType var2, UnitType var3, PriceExpression var4);

    public static class Create_PriceDefault
    extends Create_Price {
        @Override
        protected Price.PriceBuilder doEvaluate(BigDecimal value, UnitType unit, UnitType perUnitOf, PriceExpression priceExpression) {
            Price.PriceBuilder price = Price.builder();
            return this.assignOutput(price, value, unit, perUnitOf, priceExpression);
        }

        protected Price.PriceBuilder assignOutput(Price.PriceBuilder price, BigDecimal value, UnitType unit, UnitType perUnitOf, PriceExpression priceExpression) {
            price.setValue((BigDecimal)MapperS.of((Object)value).get());
            price.setUnit((UnitType)MapperS.of((Object)unit).get());
            price.setPerUnitOf((UnitType)MapperS.of((Object)perUnitOf).get());
            price.setPriceExpression((PriceExpression)MapperS.of((Object)priceExpression).get());
            return Optional.ofNullable(price).map(o -> o.prune()).orElse(null);
        }
    }
}

