/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.functions;

import cdm.observable.asset.Money;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;

@ImplementedBy(value=Create_MoneyDefault.class)
public abstract class Create_Money
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Money evaluate(BigDecimal amount, String currency) {
        Money.MoneyBuilder money = this.doEvaluate(amount, currency);
        if (money != null) {
            this.objectValidator.validate(Money.class, (RosettaModelObject)money);
        }
        return money;
    }

    protected abstract Money.MoneyBuilder doEvaluate(BigDecimal var1, String var2);

    public static class Create_MoneyDefault
    extends Create_Money {
        @Override
        protected Money.MoneyBuilder doEvaluate(BigDecimal amount, String currency) {
            Money.MoneyBuilder money = Money.builder();
            return this.assignOutput(money, amount, currency);
        }

        protected Money.MoneyBuilder assignOutput(Money.MoneyBuilder money, BigDecimal amount, String currency) {
            money.setValue((BigDecimal)MapperS.of((Object)amount).get());
            money.getOrCreateUnit().setCurrencyValue((String)MapperS.of((Object)currency).get());
            return Optional.ofNullable(money).map(o -> o.prune()).orElse(null);
        }
    }
}

