/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.fro;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum FloatingRateIndexStyleEnum {
    AVERAGE_FRO("Average FRO"),
    COMPOUNDED_FRO("Compounded FRO"),
    COMPOUNDED_INDEX("Compounded Index"),
    INDEX("Index"),
    OTHER("Other"),
    OVERNIGHT("Overnight Rate"),
    PUBLISHED_AVERAGE("Published Average Rate"),
    SPECIFIED_FORMULA("Specified Formula"),
    SWAP_RATE("Swap Rate"),
    TERM_RATE("Term Rate");

    private static Map<String, FloatingRateIndexStyleEnum> values;
    private final String displayName;

    private FloatingRateIndexStyleEnum() {
        this(null);
    }

    private FloatingRateIndexStyleEnum(String displayName) {
        this.displayName = displayName;
    }

    public static FloatingRateIndexStyleEnum fromDisplayName(String name) {
        FloatingRateIndexStyleEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.displayName != null ? this.displayName : this.name();
    }

    static {
        ConcurrentHashMap<String, FloatingRateIndexStyleEnum> map = new ConcurrentHashMap<String, FloatingRateIndexStyleEnum>();
        for (FloatingRateIndexStyleEnum instance : FloatingRateIndexStyleEnum.values()) {
            map.put(instance.toString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

