/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.fro;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.base.staticdata.asset.rates.metafields.FieldWithMetaFloatingRateIndexEnum;
import cdm.observable.asset.fro.meta.FloatingRateIndexIdentificationMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface FloatingRateIndexIdentification
extends RosettaModelObject {
    public static final FloatingRateIndexIdentificationMeta metaData = new FloatingRateIndexIdentificationMeta();

    public FloatingRateIndexIdentification build();

    public FloatingRateIndexIdentificationBuilder toBuilder();

    public ISOCurrencyCodeEnum getCurrency();

    public FieldWithMetaFloatingRateIndexEnum getFloatingRateIndex();

    public String getFroType();

    default public RosettaMetaData<? extends FloatingRateIndexIdentification> metaData() {
        return metaData;
    }

    public static FloatingRateIndexIdentificationBuilder builder() {
        return new FloatingRateIndexIdentificationBuilderImpl();
    }

    default public Class<? extends FloatingRateIndexIdentification> getType() {
        return FloatingRateIndexIdentification.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("currency"), ISOCurrencyCodeEnum.class, (Object)this.getCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("froType"), String.class, (Object)this.getFroType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRateIndex"), processor, FieldWithMetaFloatingRateIndexEnum.class, this.getFloatingRateIndex(), new AttributeMeta[0]);
    }

    public static class FloatingRateIndexIdentificationBuilderImpl
    implements FloatingRateIndexIdentificationBuilder {
        protected ISOCurrencyCodeEnum currency;
        protected FieldWithMetaFloatingRateIndexEnum.FieldWithMetaFloatingRateIndexEnumBuilder floatingRateIndex;
        protected String froType;

        @Override
        public ISOCurrencyCodeEnum getCurrency() {
            return this.currency;
        }

        @Override
        public FieldWithMetaFloatingRateIndexEnum.FieldWithMetaFloatingRateIndexEnumBuilder getFloatingRateIndex() {
            return this.floatingRateIndex;
        }

        @Override
        public FieldWithMetaFloatingRateIndexEnum.FieldWithMetaFloatingRateIndexEnumBuilder getOrCreateFloatingRateIndex() {
            FieldWithMetaFloatingRateIndexEnum.FieldWithMetaFloatingRateIndexEnumBuilder result = this.floatingRateIndex != null ? this.floatingRateIndex : (this.floatingRateIndex = FieldWithMetaFloatingRateIndexEnum.builder());
            return result;
        }

        @Override
        public String getFroType() {
            return this.froType;
        }

        @Override
        public FloatingRateIndexIdentificationBuilder setCurrency(ISOCurrencyCodeEnum currency) {
            this.currency = currency == null ? null : currency;
            return this;
        }

        @Override
        public FloatingRateIndexIdentificationBuilder setFloatingRateIndex(FieldWithMetaFloatingRateIndexEnum floatingRateIndex) {
            this.floatingRateIndex = floatingRateIndex == null ? null : floatingRateIndex.toBuilder();
            return this;
        }

        @Override
        public FloatingRateIndexIdentificationBuilder setFloatingRateIndexValue(FloatingRateIndexEnum floatingRateIndex) {
            this.getOrCreateFloatingRateIndex().setValue(floatingRateIndex);
            return this;
        }

        @Override
        public FloatingRateIndexIdentificationBuilder setFroType(String froType) {
            this.froType = froType == null ? null : froType;
            return this;
        }

        @Override
        public FloatingRateIndexIdentification build() {
            return new FloatingRateIndexIdentificationImpl(this);
        }

        @Override
        public FloatingRateIndexIdentificationBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingRateIndexIdentificationBuilder prune() {
            if (this.floatingRateIndex != null && !this.floatingRateIndex.prune().hasData()) {
                this.floatingRateIndex = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCurrency() != null) {
                return true;
            }
            if (this.getFloatingRateIndex() != null) {
                return true;
            }
            return this.getFroType() != null;
        }

        public FloatingRateIndexIdentificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FloatingRateIndexIdentificationBuilder o = (FloatingRateIndexIdentificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRateIndex(), (RosettaModelObjectBuilder)o.getFloatingRateIndex(), this::setFloatingRateIndex);
            merger.mergeBasic((Object)this.getCurrency(), (Object)o.getCurrency(), this::setCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFroType(), (Object)o.getFroType(), this::setFroType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateIndexIdentification _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.currency, (Object)_that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateIndex, _that.getFloatingRateIndex())) {
                return false;
            }
            return Objects.equals(this.froType, _that.getFroType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currency != null ? ((Object)((Object)this.currency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateIndex != null ? this.floatingRateIndex.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.froType != null ? this.froType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateIndexIdentificationBuilder {currency=" + (Object)((Object)this.currency) + ", floatingRateIndex=" + this.floatingRateIndex + ", froType=" + this.froType + '}';
        }
    }

    public static class FloatingRateIndexIdentificationImpl
    implements FloatingRateIndexIdentification {
        private final ISOCurrencyCodeEnum currency;
        private final FieldWithMetaFloatingRateIndexEnum floatingRateIndex;
        private final String froType;

        protected FloatingRateIndexIdentificationImpl(FloatingRateIndexIdentificationBuilder builder) {
            this.currency = builder.getCurrency();
            this.floatingRateIndex = Optional.ofNullable(builder.getFloatingRateIndex()).map(f -> f.build()).orElse(null);
            this.froType = builder.getFroType();
        }

        @Override
        public ISOCurrencyCodeEnum getCurrency() {
            return this.currency;
        }

        @Override
        public FieldWithMetaFloatingRateIndexEnum getFloatingRateIndex() {
            return this.floatingRateIndex;
        }

        @Override
        public String getFroType() {
            return this.froType;
        }

        @Override
        public FloatingRateIndexIdentification build() {
            return this;
        }

        @Override
        public FloatingRateIndexIdentificationBuilder toBuilder() {
            FloatingRateIndexIdentificationBuilder builder = FloatingRateIndexIdentification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingRateIndexIdentificationBuilder builder) {
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getFloatingRateIndex()).ifPresent(builder::setFloatingRateIndex);
            Optional.ofNullable(this.getFroType()).ifPresent(builder::setFroType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateIndexIdentification _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.currency, (Object)_that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateIndex, _that.getFloatingRateIndex())) {
                return false;
            }
            return Objects.equals(this.froType, _that.getFroType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.currency != null ? ((Object)((Object)this.currency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateIndex != null ? this.floatingRateIndex.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.froType != null ? this.froType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateIndexIdentification {currency=" + (Object)((Object)this.currency) + ", floatingRateIndex=" + this.floatingRateIndex + ", froType=" + this.froType + '}';
        }
    }

    public static interface FloatingRateIndexIdentificationBuilder
    extends FloatingRateIndexIdentification,
    RosettaModelObjectBuilder {
        public FieldWithMetaFloatingRateIndexEnum.FieldWithMetaFloatingRateIndexEnumBuilder getOrCreateFloatingRateIndex();

        @Override
        public FieldWithMetaFloatingRateIndexEnum.FieldWithMetaFloatingRateIndexEnumBuilder getFloatingRateIndex();

        public FloatingRateIndexIdentificationBuilder setCurrency(ISOCurrencyCodeEnum var1);

        public FloatingRateIndexIdentificationBuilder setFloatingRateIndex(FieldWithMetaFloatingRateIndexEnum var1);

        public FloatingRateIndexIdentificationBuilder setFloatingRateIndexValue(FloatingRateIndexEnum var1);

        public FloatingRateIndexIdentificationBuilder setFroType(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("currency"), ISOCurrencyCodeEnum.class, (Object)this.getCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("froType"), String.class, (Object)this.getFroType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRateIndex"), processor, FieldWithMetaFloatingRateIndexEnum.FieldWithMetaFloatingRateIndexEnumBuilder.class, this.getFloatingRateIndex(), new AttributeMeta[0]);
        }

        public FloatingRateIndexIdentificationBuilder prune();
    }
}

