/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.functions.AddBusinessDays;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.List;
import java.util.Optional;

@ImplementedBy(value=GenerateObservationPeriodDefault.class)
public abstract class GenerateObservationPeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected AddBusinessDays addBusinessDays;

    public CalculationPeriodBase evaluate(CalculationPeriodBase calculationPeriod, List<BusinessCenterEnum> businessCenters, Integer shiftDays) {
        CalculationPeriodBase.CalculationPeriodBaseBuilder observationPeriod = this.doEvaluate(calculationPeriod, businessCenters, shiftDays);
        if (observationPeriod != null) {
            this.objectValidator.validate(CalculationPeriodBase.class, (RosettaModelObject)observationPeriod);
        }
        return observationPeriod;
    }

    protected abstract CalculationPeriodBase.CalculationPeriodBaseBuilder doEvaluate(CalculationPeriodBase var1, List<BusinessCenterEnum> var2, Integer var3);

    protected abstract Mapper<Date> calcStart(CalculationPeriodBase var1, List<BusinessCenterEnum> var2, Integer var3);

    protected abstract Mapper<Date> calcEnd(CalculationPeriodBase var1, List<BusinessCenterEnum> var2, Integer var3);

    protected abstract Mapper<Date> obsStart(CalculationPeriodBase var1, List<BusinessCenterEnum> var2, Integer var3);

    protected abstract Mapper<Date> obsEnd(CalculationPeriodBase var1, List<BusinessCenterEnum> var2, Integer var3);

    public static class GenerateObservationPeriodDefault
    extends GenerateObservationPeriod {
        @Override
        protected CalculationPeriodBase.CalculationPeriodBaseBuilder doEvaluate(CalculationPeriodBase calculationPeriod, List<BusinessCenterEnum> businessCenters, Integer shiftDays) {
            CalculationPeriodBase.CalculationPeriodBaseBuilder observationPeriod = CalculationPeriodBase.builder();
            return this.assignOutput(observationPeriod, calculationPeriod, businessCenters, shiftDays);
        }

        protected CalculationPeriodBase.CalculationPeriodBaseBuilder assignOutput(CalculationPeriodBase.CalculationPeriodBaseBuilder observationPeriod, CalculationPeriodBase calculationPeriod, List<BusinessCenterEnum> businessCenters, Integer shiftDays) {
            observationPeriod.setAdjustedStartDate((Date)MapperS.of((Object)((Date)this.obsStart(calculationPeriod, businessCenters, shiftDays).get())).get());
            observationPeriod.setAdjustedEndDate((Date)MapperS.of((Object)((Date)this.obsEnd(calculationPeriod, businessCenters, shiftDays).get())).get());
            return Optional.ofNullable(observationPeriod).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<Date> calcStart(CalculationPeriodBase calculationPeriod, List<BusinessCenterEnum> businessCenters, Integer shiftDays) {
            return MapperS.of((Object)calculationPeriod).map("getAdjustedStartDate", calculationPeriodBase -> calculationPeriodBase.getAdjustedStartDate());
        }

        @Override
        protected Mapper<Date> calcEnd(CalculationPeriodBase calculationPeriod, List<BusinessCenterEnum> businessCenters, Integer shiftDays) {
            return MapperS.of((Object)calculationPeriod).map("getAdjustedEndDate", calculationPeriodBase -> calculationPeriodBase.getAdjustedEndDate());
        }

        @Override
        protected Mapper<Date> obsStart(CalculationPeriodBase calculationPeriod, List<BusinessCenterEnum> businessCenters, Integer shiftDays) {
            return MapperS.of((Object)this.addBusinessDays.evaluate((Date)MapperS.of((Object)((Date)this.calcStart(calculationPeriod, businessCenters, shiftDays).get())).get(), (Integer)MapperMaths.multiply((Mapper)MapperS.of((Object)-1), (Mapper)MapperS.of((Object)shiftDays)).get(), MapperC.of(businessCenters).getMulti()));
        }

        @Override
        protected Mapper<Date> obsEnd(CalculationPeriodBase calculationPeriod, List<BusinessCenterEnum> businessCenters, Integer shiftDays) {
            return MapperS.of((Object)this.addBusinessDays.evaluate((Date)MapperS.of((Object)((Date)this.calcEnd(calculationPeriod, businessCenters, shiftDays).get())).get(), (Integer)MapperMaths.multiply((Mapper)MapperS.of((Object)-1), (Mapper)MapperS.of((Object)shiftDays)).get(), MapperC.of(businessCenters).getMulti()));
        }
    }
}

