/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.functions.AppendDateToList;
import cdm.base.datetime.functions.GetAllBusinessCenters;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.calculatedrate.ObservationShiftCalculation;
import cdm.observable.asset.calculatedrate.OffsetCalculation;
import cdm.observable.asset.calculatedrate.functions.GenerateObservationDates;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.util.ArrayList;
import java.util.List;

@ImplementedBy(value=DetermineWeightingDatesDefault.class)
public abstract class DetermineWeightingDates
implements RosettaFunction {
    @Inject
    protected AppendDateToList appendDateToList;
    @Inject
    protected GenerateObservationDates generateObservationDates;
    @Inject
    protected GetAllBusinessCenters getAllBusinessCenters;

    public List<Date> evaluate(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
        List<Date> weightingDates = this.doEvaluate(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays);
        return weightingDates;
    }

    protected abstract List<Date> doEvaluate(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    protected abstract Mapper<? extends ObservationShiftCalculation> obsShift(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    protected abstract Mapper<? extends OffsetCalculation> lookback(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    protected abstract Mapper<BusinessCenterEnum> businessCenters(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    protected abstract Mapper<Date> baseWeightingDates(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    protected abstract Mapper<? extends CalculationPeriodBase> wtPeriod(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    protected abstract Mapper<Date> weightingDatesAll(FloatingRateCalculationParameters var1, List<Date> var2, CalculationPeriodBase var3, CalculationPeriodBase var4, Integer var5);

    public static class DetermineWeightingDatesDefault
    extends DetermineWeightingDates {
        @Override
        protected List<Date> doEvaluate(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            ArrayList<Date> weightingDates = new ArrayList<Date>();
            return this.assignOutput(weightingDates, calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays);
        }

        protected List<Date> assignOutput(List<Date> weightingDates, FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            List addVar = MapperC.of((List)this.weightingDatesAll(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays).getMulti()).getMulti();
            weightingDates.addAll(addVar);
            return weightingDates;
        }

        @Override
        protected Mapper<? extends ObservationShiftCalculation> obsShift(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            return MapperS.of((Object)calculationParams).map("getObservationShiftCalculation", floatingRateCalculationParameters -> floatingRateCalculationParameters.getObservationShiftCalculation());
        }

        @Override
        protected Mapper<? extends OffsetCalculation> lookback(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            return MapperS.of((Object)calculationParams).map("getLookbackCalculation", floatingRateCalculationParameters -> floatingRateCalculationParameters.getLookbackCalculation());
        }

        @Override
        protected Mapper<BusinessCenterEnum> businessCenters(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            return MapperC.of(this.getAllBusinessCenters.evaluate((BusinessCenters)MapperS.of((Object)calculationParams).map("getApplicableBusinessDays", floatingRateCalculationParameters -> floatingRateCalculationParameters.getApplicableBusinessDays()).get()));
        }

        @Override
        protected Mapper<Date> baseWeightingDates(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            return MapperUtils.runMulti(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((ObservationShiftCalculation)this.obsShift(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays).get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperC.of((List)observationDates);
                }
                return MapperC.of(this.generateObservationDates.evaluate((CalculationPeriodBase)MapperS.of((Object)adjustedCalculationPeriod).get(), MapperC.of((List)this.businessCenters(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays).getMulti()).getMulti(), (Integer)MapperS.of((Object)lockoutDays).get()));
            });
        }

        @Override
        protected Mapper<? extends CalculationPeriodBase> wtPeriod(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            return MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((OffsetCalculation)this.lookback(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays).get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)adjustedCalculationPeriod);
                }
                return MapperS.of((Object)observationPeriod);
            });
        }

        @Override
        protected Mapper<Date> weightingDatesAll(FloatingRateCalculationParameters calculationParams, List<Date> observationDates, CalculationPeriodBase observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, Integer lockoutDays) {
            return MapperC.of(this.appendDateToList.evaluate(MapperC.of((List)this.baseWeightingDates(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays).getMulti()).getMulti(), (Date)MapperS.of((Object)((CalculationPeriodBase)this.wtPeriod(calculationParams, observationDates, observationPeriod, adjustedCalculationPeriod, lockoutDays).get())).map("getAdjustedEndDate", calculationPeriodBase -> calculationPeriodBase.getAdjustedEndDate()).get()));
        }
    }
}

