/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.functions.VectorGrowthOperation;
import cdm.base.math.functions.VectorOperation;
import cdm.base.math.functions.VectorScalarOperation;
import cdm.observable.asset.calculatedrate.CalculatedRateDetails;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

@ImplementedBy(value=ApplyCompoundingFormulaDefault.class)
public abstract class ApplyCompoundingFormula
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected VectorGrowthOperation vectorGrowthOperation;
    @Inject
    protected VectorOperation vectorOperation;
    @Inject
    protected VectorScalarOperation vectorScalarOperation;

    public CalculatedRateDetails evaluate(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
        CalculatedRateDetails.CalculatedRateDetailsBuilder results = this.doEvaluate(observations, weights, yearFrac);
        if (results != null) {
            this.objectValidator.validate(CalculatedRateDetails.class, (RosettaModelObject)results);
        }
        return results;
    }

    protected abstract CalculatedRateDetails.CalculatedRateDetailsBuilder doEvaluate(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract Mapper<BigDecimal> weightedObservations(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract Mapper<BigDecimal> scaledAndWeightedObservations(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract Mapper<BigDecimal> growthFactors(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract Mapper<BigDecimal> growthCurve(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract Mapper<BigDecimal> finalValue(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract Mapper<BigDecimal> totalWeight(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract Mapper<BigDecimal> overallYearFrac(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    protected abstract Mapper<BigDecimal> calculatedRate(List<BigDecimal> var1, List<BigDecimal> var2, BigDecimal var3);

    public static class ApplyCompoundingFormulaDefault
    extends ApplyCompoundingFormula {
        @Override
        protected CalculatedRateDetails.CalculatedRateDetailsBuilder doEvaluate(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            CalculatedRateDetails.CalculatedRateDetailsBuilder results = CalculatedRateDetails.builder();
            return this.assignOutput(results, observations, weights, yearFrac);
        }

        protected CalculatedRateDetails.CalculatedRateDetailsBuilder assignOutput(CalculatedRateDetails.CalculatedRateDetailsBuilder results, List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            results.setAggregateValue((BigDecimal)MapperS.of((Object)((BigDecimal)this.finalValue(observations, weights, yearFrac).get())).get());
            results.setAggregateWeight((BigDecimal)MapperS.of((Object)((BigDecimal)this.totalWeight(observations, weights, yearFrac).get())).get());
            results.setCalculatedRate((BigDecimal)MapperS.of((Object)((BigDecimal)this.calculatedRate(observations, weights, yearFrac).get())).get());
            results.addCompoundedGrowth(MapperC.of((List)this.growthCurve(observations, weights, yearFrac).getMulti()).getMulti());
            results.addGrowthFactor(MapperC.of((List)this.growthFactors(observations, weights, yearFrac).getMulti()).getMulti());
            results.addWeightedRates(MapperC.of((List)this.weightedObservations(observations, weights, yearFrac).getMulti()).getMulti());
            return Optional.ofNullable(results).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<BigDecimal> weightedObservations(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return MapperC.of(this.vectorOperation.evaluate((ArithmeticOperationEnum)((Object)MapperS.of((Object)((Object)ArithmeticOperationEnum.MULTIPLY)).get()), MapperC.of(observations).getMulti(), MapperC.of(weights).getMulti()));
        }

        @Override
        protected Mapper<BigDecimal> scaledAndWeightedObservations(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return MapperC.of(this.vectorScalarOperation.evaluate((ArithmeticOperationEnum)((Object)MapperS.of((Object)((Object)ArithmeticOperationEnum.MULTIPLY)).get()), MapperC.of((List)this.weightedObservations(observations, weights, yearFrac).getMulti()).getMulti(), (BigDecimal)MapperS.of((Object)yearFrac).get()));
        }

        @Override
        protected Mapper<BigDecimal> growthFactors(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return MapperC.of(this.vectorScalarOperation.evaluate((ArithmeticOperationEnum)((Object)MapperS.of((Object)((Object)ArithmeticOperationEnum.ADD)).get()), MapperC.of((List)this.scaledAndWeightedObservations(observations, weights, yearFrac).getMulti()).getMulti(), (BigDecimal)MapperS.of((Object)new BigDecimal("1.0")).get()));
        }

        @Override
        protected Mapper<BigDecimal> growthCurve(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return MapperC.of(this.vectorGrowthOperation.evaluate((BigDecimal)MapperS.of((Object)new BigDecimal("1.0")).get(), MapperC.of((List)this.growthFactors(observations, weights, yearFrac).getMulti()).getMulti()));
        }

        @Override
        protected Mapper<BigDecimal> finalValue(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return MapperC.of((List)this.growthCurve(observations, weights, yearFrac).getMulti()).last();
        }

        @Override
        protected Mapper<BigDecimal> totalWeight(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return MapperC.of(weights).sumBigDecimal();
        }

        @Override
        protected Mapper<BigDecimal> overallYearFrac(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return MapperMaths.multiply((Mapper)MapperS.of((Object)((BigDecimal)this.totalWeight(observations, weights, yearFrac).get())), (Mapper)MapperS.of((Object)yearFrac));
        }

        @Override
        protected Mapper<BigDecimal> calculatedRate(List<BigDecimal> observations, List<BigDecimal> weights, BigDecimal yearFrac) {
            return MapperMaths.divide((Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)((BigDecimal)this.finalValue(observations, weights, yearFrac).get())), (Mapper)MapperS.of((Object)1)), (Mapper)MapperS.of((Object)((BigDecimal)this.overallYearFrac(observations, weights, yearFrac).get())));
        }
    }
}

