/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate;

import cdm.base.datetime.BusinessCenters;
import cdm.observable.asset.calculatedrate.ObservationPeriodDatesEnum;
import cdm.observable.asset.calculatedrate.meta.ObservationShiftCalculationMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface ObservationShiftCalculation
extends RosettaModelObject {
    public static final ObservationShiftCalculationMeta metaData = new ObservationShiftCalculationMeta();

    public ObservationShiftCalculation build();

    public ObservationShiftCalculationBuilder toBuilder();

    public BusinessCenters getAdditionalBusinessDays();

    public ObservationPeriodDatesEnum getCalculationBase();

    public Integer getOffsetDays();

    default public RosettaMetaData<? extends ObservationShiftCalculation> metaData() {
        return metaData;
    }

    public static ObservationShiftCalculationBuilder builder() {
        return new ObservationShiftCalculationBuilderImpl();
    }

    default public Class<? extends ObservationShiftCalculation> getType() {
        return ObservationShiftCalculation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("calculationBase"), ObservationPeriodDatesEnum.class, (Object)this.getCalculationBase(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("offsetDays"), Integer.class, (Object)this.getOffsetDays(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalBusinessDays"), processor, BusinessCenters.class, this.getAdditionalBusinessDays(), new AttributeMeta[0]);
    }

    public static class ObservationShiftCalculationBuilderImpl
    implements ObservationShiftCalculationBuilder {
        protected BusinessCenters.BusinessCentersBuilder additionalBusinessDays;
        protected ObservationPeriodDatesEnum calculationBase;
        protected Integer offsetDays;

        @Override
        public BusinessCenters.BusinessCentersBuilder getAdditionalBusinessDays() {
            return this.additionalBusinessDays;
        }

        @Override
        public BusinessCenters.BusinessCentersBuilder getOrCreateAdditionalBusinessDays() {
            BusinessCenters.BusinessCentersBuilder result = this.additionalBusinessDays != null ? this.additionalBusinessDays : (this.additionalBusinessDays = BusinessCenters.builder());
            return result;
        }

        @Override
        public ObservationPeriodDatesEnum getCalculationBase() {
            return this.calculationBase;
        }

        @Override
        public Integer getOffsetDays() {
            return this.offsetDays;
        }

        @Override
        public ObservationShiftCalculationBuilder setAdditionalBusinessDays(BusinessCenters additionalBusinessDays) {
            this.additionalBusinessDays = additionalBusinessDays == null ? null : additionalBusinessDays.toBuilder();
            return this;
        }

        @Override
        public ObservationShiftCalculationBuilder setCalculationBase(ObservationPeriodDatesEnum calculationBase) {
            this.calculationBase = calculationBase == null ? null : calculationBase;
            return this;
        }

        @Override
        public ObservationShiftCalculationBuilder setOffsetDays(Integer offsetDays) {
            this.offsetDays = offsetDays == null ? null : offsetDays;
            return this;
        }

        @Override
        public ObservationShiftCalculation build() {
            return new ObservationShiftCalculationImpl(this);
        }

        @Override
        public ObservationShiftCalculationBuilder toBuilder() {
            return this;
        }

        @Override
        public ObservationShiftCalculationBuilder prune() {
            if (this.additionalBusinessDays != null && !this.additionalBusinessDays.prune().hasData()) {
                this.additionalBusinessDays = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAdditionalBusinessDays() != null && this.getAdditionalBusinessDays().hasData()) {
                return true;
            }
            if (this.getCalculationBase() != null) {
                return true;
            }
            return this.getOffsetDays() != null;
        }

        public ObservationShiftCalculationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ObservationShiftCalculationBuilder o = (ObservationShiftCalculationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdditionalBusinessDays(), (RosettaModelObjectBuilder)o.getAdditionalBusinessDays(), this::setAdditionalBusinessDays);
            merger.mergeBasic((Object)this.getCalculationBase(), (Object)o.getCalculationBase(), this::setCalculationBase, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOffsetDays(), (Object)o.getOffsetDays(), this::setOffsetDays, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationShiftCalculation _that = this.getType().cast(o);
            if (!Objects.equals(this.additionalBusinessDays, _that.getAdditionalBusinessDays())) {
                return false;
            }
            if (!Objects.equals((Object)this.calculationBase, (Object)_that.getCalculationBase())) {
                return false;
            }
            return Objects.equals(this.offsetDays, _that.getOffsetDays());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.additionalBusinessDays != null ? this.additionalBusinessDays.hashCode() : 0);
            _result = 31 * _result + (this.calculationBase != null ? ((Object)((Object)this.calculationBase)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.offsetDays != null ? this.offsetDays.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationShiftCalculationBuilder {additionalBusinessDays=" + this.additionalBusinessDays + ", calculationBase=" + (Object)((Object)this.calculationBase) + ", offsetDays=" + this.offsetDays + '}';
        }
    }

    public static class ObservationShiftCalculationImpl
    implements ObservationShiftCalculation {
        private final BusinessCenters additionalBusinessDays;
        private final ObservationPeriodDatesEnum calculationBase;
        private final Integer offsetDays;

        protected ObservationShiftCalculationImpl(ObservationShiftCalculationBuilder builder) {
            this.additionalBusinessDays = Optional.ofNullable(builder.getAdditionalBusinessDays()).map(f -> f.build()).orElse(null);
            this.calculationBase = builder.getCalculationBase();
            this.offsetDays = builder.getOffsetDays();
        }

        @Override
        public BusinessCenters getAdditionalBusinessDays() {
            return this.additionalBusinessDays;
        }

        @Override
        public ObservationPeriodDatesEnum getCalculationBase() {
            return this.calculationBase;
        }

        @Override
        public Integer getOffsetDays() {
            return this.offsetDays;
        }

        @Override
        public ObservationShiftCalculation build() {
            return this;
        }

        @Override
        public ObservationShiftCalculationBuilder toBuilder() {
            ObservationShiftCalculationBuilder builder = ObservationShiftCalculation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObservationShiftCalculationBuilder builder) {
            Optional.ofNullable(this.getAdditionalBusinessDays()).ifPresent(builder::setAdditionalBusinessDays);
            Optional.ofNullable(this.getCalculationBase()).ifPresent(builder::setCalculationBase);
            Optional.ofNullable(this.getOffsetDays()).ifPresent(builder::setOffsetDays);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationShiftCalculation _that = this.getType().cast(o);
            if (!Objects.equals(this.additionalBusinessDays, _that.getAdditionalBusinessDays())) {
                return false;
            }
            if (!Objects.equals((Object)this.calculationBase, (Object)_that.getCalculationBase())) {
                return false;
            }
            return Objects.equals(this.offsetDays, _that.getOffsetDays());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.additionalBusinessDays != null ? this.additionalBusinessDays.hashCode() : 0);
            _result = 31 * _result + (this.calculationBase != null ? ((Object)((Object)this.calculationBase)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.offsetDays != null ? this.offsetDays.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationShiftCalculation {additionalBusinessDays=" + this.additionalBusinessDays + ", calculationBase=" + (Object)((Object)this.calculationBase) + ", offsetDays=" + this.offsetDays + '}';
        }
    }

    public static interface ObservationShiftCalculationBuilder
    extends ObservationShiftCalculation,
    RosettaModelObjectBuilder {
        public BusinessCenters.BusinessCentersBuilder getOrCreateAdditionalBusinessDays();

        @Override
        public BusinessCenters.BusinessCentersBuilder getAdditionalBusinessDays();

        public ObservationShiftCalculationBuilder setAdditionalBusinessDays(BusinessCenters var1);

        public ObservationShiftCalculationBuilder setCalculationBase(ObservationPeriodDatesEnum var1);

        public ObservationShiftCalculationBuilder setOffsetDays(Integer var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("calculationBase"), ObservationPeriodDatesEnum.class, (Object)this.getCalculationBase(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("offsetDays"), Integer.class, (Object)this.getOffsetDays(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalBusinessDays"), processor, BusinessCenters.BusinessCentersBuilder.class, this.getAdditionalBusinessDays(), new AttributeMeta[0]);
        }

        public ObservationShiftCalculationBuilder prune();
    }
}

