/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate;

import cdm.observable.asset.calculatedrate.meta.CalculatedRateObservationsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface CalculatedRateObservations
extends RosettaModelObject {
    public static final CalculatedRateObservationsMeta metaData = new CalculatedRateObservationsMeta();

    public CalculatedRateObservations build();

    public CalculatedRateObservationsBuilder toBuilder();

    public List<Date> getObservationDates();

    public List<BigDecimal> getObservedRates();

    public List<BigDecimal> getProcessedRates();

    public List<BigDecimal> getWeights();

    default public RosettaMetaData<? extends CalculatedRateObservations> metaData() {
        return metaData;
    }

    public static CalculatedRateObservationsBuilder builder() {
        return new CalculatedRateObservationsBuilderImpl();
    }

    default public Class<? extends CalculatedRateObservations> getType() {
        return CalculatedRateObservations.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("observationDates"), Date.class, this.getObservationDates(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("observedRates"), BigDecimal.class, this.getObservedRates(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("processedRates"), BigDecimal.class, this.getProcessedRates(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("weights"), BigDecimal.class, this.getWeights(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CalculatedRateObservationsBuilderImpl
    implements CalculatedRateObservationsBuilder {
        protected List<Date> observationDates = new ArrayList<Date>();
        protected List<BigDecimal> observedRates = new ArrayList<BigDecimal>();
        protected List<BigDecimal> processedRates = new ArrayList<BigDecimal>();
        protected List<BigDecimal> weights = new ArrayList<BigDecimal>();

        @Override
        public List<Date> getObservationDates() {
            return this.observationDates;
        }

        @Override
        public List<BigDecimal> getObservedRates() {
            return this.observedRates;
        }

        @Override
        public List<BigDecimal> getProcessedRates() {
            return this.processedRates;
        }

        @Override
        public List<BigDecimal> getWeights() {
            return this.weights;
        }

        @Override
        public CalculatedRateObservationsBuilder addObservationDates(Date observationDates) {
            if (observationDates != null) {
                this.observationDates.add(observationDates);
            }
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addObservationDates(Date observationDates, int _idx) {
            this.getIndex(this.observationDates, _idx, () -> observationDates);
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addObservationDates(List<? extends Date> observationDatess) {
            if (observationDatess != null) {
                for (Date date : observationDatess) {
                    this.observationDates.add(date);
                }
            }
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder setObservationDates(List<? extends Date> observationDatess) {
            this.observationDates = observationDatess == null ? new ArrayList<Date>() : (List)observationDatess.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addObservedRates(BigDecimal observedRates) {
            if (observedRates != null) {
                this.observedRates.add(observedRates);
            }
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addObservedRates(BigDecimal observedRates, int _idx) {
            this.getIndex(this.observedRates, _idx, () -> observedRates);
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addObservedRates(List<? extends BigDecimal> observedRatess) {
            if (observedRatess != null) {
                for (BigDecimal bigDecimal : observedRatess) {
                    this.observedRates.add(bigDecimal);
                }
            }
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder setObservedRates(List<? extends BigDecimal> observedRatess) {
            this.observedRates = observedRatess == null ? new ArrayList<BigDecimal>() : (List)observedRatess.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addProcessedRates(BigDecimal processedRates) {
            if (processedRates != null) {
                this.processedRates.add(processedRates);
            }
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addProcessedRates(BigDecimal processedRates, int _idx) {
            this.getIndex(this.processedRates, _idx, () -> processedRates);
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addProcessedRates(List<? extends BigDecimal> processedRatess) {
            if (processedRatess != null) {
                for (BigDecimal bigDecimal : processedRatess) {
                    this.processedRates.add(bigDecimal);
                }
            }
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder setProcessedRates(List<? extends BigDecimal> processedRatess) {
            this.processedRates = processedRatess == null ? new ArrayList<BigDecimal>() : (List)processedRatess.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addWeights(BigDecimal weights) {
            if (weights != null) {
                this.weights.add(weights);
            }
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addWeights(BigDecimal weights, int _idx) {
            this.getIndex(this.weights, _idx, () -> weights);
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addWeights(List<? extends BigDecimal> weightss) {
            if (weightss != null) {
                for (BigDecimal bigDecimal : weightss) {
                    this.weights.add(bigDecimal);
                }
            }
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder setWeights(List<? extends BigDecimal> weightss) {
            this.weights = weightss == null ? new ArrayList<BigDecimal>() : (List)weightss.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CalculatedRateObservations build() {
            return new CalculatedRateObservationsImpl(this);
        }

        @Override
        public CalculatedRateObservationsBuilder toBuilder() {
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getObservationDates() != null && !this.getObservationDates().isEmpty()) {
                return true;
            }
            if (this.getObservedRates() != null && !this.getObservedRates().isEmpty()) {
                return true;
            }
            if (this.getProcessedRates() != null && !this.getProcessedRates().isEmpty()) {
                return true;
            }
            return this.getWeights() != null && !this.getWeights().isEmpty();
        }

        public CalculatedRateObservationsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CalculatedRateObservationsBuilder o = (CalculatedRateObservationsBuilder)other;
            merger.mergeBasic(this.getObservationDates(), o.getObservationDates(), this::addObservationDates);
            merger.mergeBasic(this.getObservedRates(), o.getObservedRates(), this::addObservedRates);
            merger.mergeBasic(this.getProcessedRates(), o.getProcessedRates(), this::addProcessedRates);
            merger.mergeBasic(this.getWeights(), o.getWeights(), this::addWeights);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculatedRateObservations _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observationDates, _that.getObservationDates())) {
                return false;
            }
            if (!ListEquals.listEquals(this.observedRates, _that.getObservedRates())) {
                return false;
            }
            if (!ListEquals.listEquals(this.processedRates, _that.getProcessedRates())) {
                return false;
            }
            return ListEquals.listEquals(this.weights, _that.getWeights());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observationDates != null ? this.observationDates.hashCode() : 0);
            _result = 31 * _result + (this.observedRates != null ? this.observedRates.hashCode() : 0);
            _result = 31 * _result + (this.processedRates != null ? this.processedRates.hashCode() : 0);
            _result = 31 * _result + (this.weights != null ? this.weights.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculatedRateObservationsBuilder {observationDates=" + this.observationDates + ", observedRates=" + this.observedRates + ", processedRates=" + this.processedRates + ", weights=" + this.weights + '}';
        }
    }

    public static class CalculatedRateObservationsImpl
    implements CalculatedRateObservations {
        private final List<Date> observationDates;
        private final List<BigDecimal> observedRates;
        private final List<BigDecimal> processedRates;
        private final List<BigDecimal> weights;

        protected CalculatedRateObservationsImpl(CalculatedRateObservationsBuilder builder) {
            this.observationDates = Optional.ofNullable(builder.getObservationDates()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.observedRates = Optional.ofNullable(builder.getObservedRates()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.processedRates = Optional.ofNullable(builder.getProcessedRates()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.weights = Optional.ofNullable(builder.getWeights()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        public List<Date> getObservationDates() {
            return this.observationDates;
        }

        @Override
        public List<BigDecimal> getObservedRates() {
            return this.observedRates;
        }

        @Override
        public List<BigDecimal> getProcessedRates() {
            return this.processedRates;
        }

        @Override
        public List<BigDecimal> getWeights() {
            return this.weights;
        }

        @Override
        public CalculatedRateObservations build() {
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder toBuilder() {
            CalculatedRateObservationsBuilder builder = CalculatedRateObservations.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CalculatedRateObservationsBuilder builder) {
            Optional.ofNullable(this.getObservationDates()).ifPresent(builder::setObservationDates);
            Optional.ofNullable(this.getObservedRates()).ifPresent(builder::setObservedRates);
            Optional.ofNullable(this.getProcessedRates()).ifPresent(builder::setProcessedRates);
            Optional.ofNullable(this.getWeights()).ifPresent(builder::setWeights);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculatedRateObservations _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observationDates, _that.getObservationDates())) {
                return false;
            }
            if (!ListEquals.listEquals(this.observedRates, _that.getObservedRates())) {
                return false;
            }
            if (!ListEquals.listEquals(this.processedRates, _that.getProcessedRates())) {
                return false;
            }
            return ListEquals.listEquals(this.weights, _that.getWeights());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observationDates != null ? this.observationDates.hashCode() : 0);
            _result = 31 * _result + (this.observedRates != null ? this.observedRates.hashCode() : 0);
            _result = 31 * _result + (this.processedRates != null ? this.processedRates.hashCode() : 0);
            _result = 31 * _result + (this.weights != null ? this.weights.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculatedRateObservations {observationDates=" + this.observationDates + ", observedRates=" + this.observedRates + ", processedRates=" + this.processedRates + ", weights=" + this.weights + '}';
        }
    }

    public static interface CalculatedRateObservationsBuilder
    extends CalculatedRateObservations,
    RosettaModelObjectBuilder {
        public CalculatedRateObservationsBuilder addObservationDates(Date var1);

        public CalculatedRateObservationsBuilder addObservationDates(Date var1, int var2);

        public CalculatedRateObservationsBuilder addObservationDates(List<? extends Date> var1);

        public CalculatedRateObservationsBuilder setObservationDates(List<? extends Date> var1);

        public CalculatedRateObservationsBuilder addObservedRates(BigDecimal var1);

        public CalculatedRateObservationsBuilder addObservedRates(BigDecimal var1, int var2);

        public CalculatedRateObservationsBuilder addObservedRates(List<? extends BigDecimal> var1);

        public CalculatedRateObservationsBuilder setObservedRates(List<? extends BigDecimal> var1);

        public CalculatedRateObservationsBuilder addProcessedRates(BigDecimal var1);

        public CalculatedRateObservationsBuilder addProcessedRates(BigDecimal var1, int var2);

        public CalculatedRateObservationsBuilder addProcessedRates(List<? extends BigDecimal> var1);

        public CalculatedRateObservationsBuilder setProcessedRates(List<? extends BigDecimal> var1);

        public CalculatedRateObservationsBuilder addWeights(BigDecimal var1);

        public CalculatedRateObservationsBuilder addWeights(BigDecimal var1, int var2);

        public CalculatedRateObservationsBuilder addWeights(List<? extends BigDecimal> var1);

        public CalculatedRateObservationsBuilder setWeights(List<? extends BigDecimal> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("observationDates"), Date.class, this.getObservationDates(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("observedRates"), BigDecimal.class, this.getObservedRates(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("processedRates"), BigDecimal.class, this.getProcessedRates(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("weights"), BigDecimal.class, this.getWeights(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CalculatedRateObservationsBuilder prune();
    }
}

