/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate;

import cdm.observable.asset.calculatedrate.CalculatedRateObservations;
import cdm.observable.asset.calculatedrate.meta.CalculatedRateDetailsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface CalculatedRateDetails
extends RosettaModelObject {
    public static final CalculatedRateDetailsMeta metaData = new CalculatedRateDetailsMeta();

    public CalculatedRateDetails build();

    public CalculatedRateDetailsBuilder toBuilder();

    public BigDecimal getAggregateValue();

    public BigDecimal getAggregateWeight();

    public BigDecimal getCalculatedRate();

    public List<BigDecimal> getCompoundedGrowth();

    public List<BigDecimal> getGrowthFactor();

    public CalculatedRateObservations getObservations();

    public List<BigDecimal> getWeightedRates();

    default public RosettaMetaData<? extends CalculatedRateDetails> metaData() {
        return metaData;
    }

    public static CalculatedRateDetailsBuilder builder() {
        return new CalculatedRateDetailsBuilderImpl();
    }

    default public Class<? extends CalculatedRateDetails> getType() {
        return CalculatedRateDetails.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("aggregateValue"), BigDecimal.class, (Object)this.getAggregateValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("aggregateWeight"), BigDecimal.class, (Object)this.getAggregateWeight(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("calculatedRate"), BigDecimal.class, (Object)this.getCalculatedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("compoundedGrowth"), BigDecimal.class, this.getCompoundedGrowth(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("growthFactor"), BigDecimal.class, this.getGrowthFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("weightedRates"), BigDecimal.class, this.getWeightedRates(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observations"), processor, CalculatedRateObservations.class, this.getObservations(), new AttributeMeta[0]);
    }

    public static class CalculatedRateDetailsBuilderImpl
    implements CalculatedRateDetailsBuilder {
        protected BigDecimal aggregateValue;
        protected BigDecimal aggregateWeight;
        protected BigDecimal calculatedRate;
        protected List<BigDecimal> compoundedGrowth = new ArrayList<BigDecimal>();
        protected List<BigDecimal> growthFactor = new ArrayList<BigDecimal>();
        protected CalculatedRateObservations.CalculatedRateObservationsBuilder observations;
        protected List<BigDecimal> weightedRates = new ArrayList<BigDecimal>();

        @Override
        public BigDecimal getAggregateValue() {
            return this.aggregateValue;
        }

        @Override
        public BigDecimal getAggregateWeight() {
            return this.aggregateWeight;
        }

        @Override
        public BigDecimal getCalculatedRate() {
            return this.calculatedRate;
        }

        @Override
        public List<BigDecimal> getCompoundedGrowth() {
            return this.compoundedGrowth;
        }

        @Override
        public List<BigDecimal> getGrowthFactor() {
            return this.growthFactor;
        }

        @Override
        public CalculatedRateObservations.CalculatedRateObservationsBuilder getObservations() {
            return this.observations;
        }

        @Override
        public CalculatedRateObservations.CalculatedRateObservationsBuilder getOrCreateObservations() {
            CalculatedRateObservations.CalculatedRateObservationsBuilder result = this.observations != null ? this.observations : (this.observations = CalculatedRateObservations.builder());
            return result;
        }

        @Override
        public List<BigDecimal> getWeightedRates() {
            return this.weightedRates;
        }

        @Override
        public CalculatedRateDetailsBuilder setAggregateValue(BigDecimal aggregateValue) {
            this.aggregateValue = aggregateValue == null ? null : aggregateValue;
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder setAggregateWeight(BigDecimal aggregateWeight) {
            this.aggregateWeight = aggregateWeight == null ? null : aggregateWeight;
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder setCalculatedRate(BigDecimal calculatedRate) {
            this.calculatedRate = calculatedRate == null ? null : calculatedRate;
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder addCompoundedGrowth(BigDecimal compoundedGrowth) {
            if (compoundedGrowth != null) {
                this.compoundedGrowth.add(compoundedGrowth);
            }
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder addCompoundedGrowth(BigDecimal compoundedGrowth, int _idx) {
            this.getIndex(this.compoundedGrowth, _idx, () -> compoundedGrowth);
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder addCompoundedGrowth(List<? extends BigDecimal> compoundedGrowths) {
            if (compoundedGrowths != null) {
                for (BigDecimal bigDecimal : compoundedGrowths) {
                    this.compoundedGrowth.add(bigDecimal);
                }
            }
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder setCompoundedGrowth(List<? extends BigDecimal> compoundedGrowths) {
            this.compoundedGrowth = compoundedGrowths == null ? new ArrayList<BigDecimal>() : (List)compoundedGrowths.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder addGrowthFactor(BigDecimal growthFactor) {
            if (growthFactor != null) {
                this.growthFactor.add(growthFactor);
            }
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder addGrowthFactor(BigDecimal growthFactor, int _idx) {
            this.getIndex(this.growthFactor, _idx, () -> growthFactor);
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder addGrowthFactor(List<? extends BigDecimal> growthFactors) {
            if (growthFactors != null) {
                for (BigDecimal bigDecimal : growthFactors) {
                    this.growthFactor.add(bigDecimal);
                }
            }
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder setGrowthFactor(List<? extends BigDecimal> growthFactors) {
            this.growthFactor = growthFactors == null ? new ArrayList<BigDecimal>() : (List)growthFactors.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder setObservations(CalculatedRateObservations observations) {
            this.observations = observations == null ? null : observations.toBuilder();
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder addWeightedRates(BigDecimal weightedRates) {
            if (weightedRates != null) {
                this.weightedRates.add(weightedRates);
            }
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder addWeightedRates(BigDecimal weightedRates, int _idx) {
            this.getIndex(this.weightedRates, _idx, () -> weightedRates);
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder addWeightedRates(List<? extends BigDecimal> weightedRatess) {
            if (weightedRatess != null) {
                for (BigDecimal bigDecimal : weightedRatess) {
                    this.weightedRates.add(bigDecimal);
                }
            }
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder setWeightedRates(List<? extends BigDecimal> weightedRatess) {
            this.weightedRates = weightedRatess == null ? new ArrayList<BigDecimal>() : (List)weightedRatess.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CalculatedRateDetails build() {
            return new CalculatedRateDetailsImpl(this);
        }

        @Override
        public CalculatedRateDetailsBuilder toBuilder() {
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder prune() {
            if (this.observations != null && !this.observations.prune().hasData()) {
                this.observations = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAggregateValue() != null) {
                return true;
            }
            if (this.getAggregateWeight() != null) {
                return true;
            }
            if (this.getCalculatedRate() != null) {
                return true;
            }
            if (this.getCompoundedGrowth() != null && !this.getCompoundedGrowth().isEmpty()) {
                return true;
            }
            if (this.getGrowthFactor() != null && !this.getGrowthFactor().isEmpty()) {
                return true;
            }
            if (this.getObservations() != null && this.getObservations().hasData()) {
                return true;
            }
            return this.getWeightedRates() != null && !this.getWeightedRates().isEmpty();
        }

        public CalculatedRateDetailsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CalculatedRateDetailsBuilder o = (CalculatedRateDetailsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservations(), (RosettaModelObjectBuilder)o.getObservations(), this::setObservations);
            merger.mergeBasic((Object)this.getAggregateValue(), (Object)o.getAggregateValue(), this::setAggregateValue, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAggregateWeight(), (Object)o.getAggregateWeight(), this::setAggregateWeight, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCalculatedRate(), (Object)o.getCalculatedRate(), this::setCalculatedRate, new AttributeMeta[0]);
            merger.mergeBasic(this.getCompoundedGrowth(), o.getCompoundedGrowth(), this::addCompoundedGrowth);
            merger.mergeBasic(this.getGrowthFactor(), o.getGrowthFactor(), this::addGrowthFactor);
            merger.mergeBasic(this.getWeightedRates(), o.getWeightedRates(), this::addWeightedRates);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculatedRateDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.aggregateValue, _that.getAggregateValue())) {
                return false;
            }
            if (!Objects.equals(this.aggregateWeight, _that.getAggregateWeight())) {
                return false;
            }
            if (!Objects.equals(this.calculatedRate, _that.getCalculatedRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.compoundedGrowth, _that.getCompoundedGrowth())) {
                return false;
            }
            if (!ListEquals.listEquals(this.growthFactor, _that.getGrowthFactor())) {
                return false;
            }
            if (!Objects.equals(this.observations, _that.getObservations())) {
                return false;
            }
            return ListEquals.listEquals(this.weightedRates, _that.getWeightedRates());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.aggregateValue != null ? this.aggregateValue.hashCode() : 0);
            _result = 31 * _result + (this.aggregateWeight != null ? this.aggregateWeight.hashCode() : 0);
            _result = 31 * _result + (this.calculatedRate != null ? this.calculatedRate.hashCode() : 0);
            _result = 31 * _result + (this.compoundedGrowth != null ? this.compoundedGrowth.hashCode() : 0);
            _result = 31 * _result + (this.growthFactor != null ? this.growthFactor.hashCode() : 0);
            _result = 31 * _result + (this.observations != null ? this.observations.hashCode() : 0);
            _result = 31 * _result + (this.weightedRates != null ? this.weightedRates.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculatedRateDetailsBuilder {aggregateValue=" + this.aggregateValue + ", aggregateWeight=" + this.aggregateWeight + ", calculatedRate=" + this.calculatedRate + ", compoundedGrowth=" + this.compoundedGrowth + ", growthFactor=" + this.growthFactor + ", observations=" + this.observations + ", weightedRates=" + this.weightedRates + '}';
        }
    }

    public static class CalculatedRateDetailsImpl
    implements CalculatedRateDetails {
        private final BigDecimal aggregateValue;
        private final BigDecimal aggregateWeight;
        private final BigDecimal calculatedRate;
        private final List<BigDecimal> compoundedGrowth;
        private final List<BigDecimal> growthFactor;
        private final CalculatedRateObservations observations;
        private final List<BigDecimal> weightedRates;

        protected CalculatedRateDetailsImpl(CalculatedRateDetailsBuilder builder) {
            this.aggregateValue = builder.getAggregateValue();
            this.aggregateWeight = builder.getAggregateWeight();
            this.calculatedRate = builder.getCalculatedRate();
            this.compoundedGrowth = Optional.ofNullable(builder.getCompoundedGrowth()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.growthFactor = Optional.ofNullable(builder.getGrowthFactor()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.observations = Optional.ofNullable(builder.getObservations()).map(f -> f.build()).orElse(null);
            this.weightedRates = Optional.ofNullable(builder.getWeightedRates()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        public BigDecimal getAggregateValue() {
            return this.aggregateValue;
        }

        @Override
        public BigDecimal getAggregateWeight() {
            return this.aggregateWeight;
        }

        @Override
        public BigDecimal getCalculatedRate() {
            return this.calculatedRate;
        }

        @Override
        public List<BigDecimal> getCompoundedGrowth() {
            return this.compoundedGrowth;
        }

        @Override
        public List<BigDecimal> getGrowthFactor() {
            return this.growthFactor;
        }

        @Override
        public CalculatedRateObservations getObservations() {
            return this.observations;
        }

        @Override
        public List<BigDecimal> getWeightedRates() {
            return this.weightedRates;
        }

        @Override
        public CalculatedRateDetails build() {
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder toBuilder() {
            CalculatedRateDetailsBuilder builder = CalculatedRateDetails.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CalculatedRateDetailsBuilder builder) {
            Optional.ofNullable(this.getAggregateValue()).ifPresent(builder::setAggregateValue);
            Optional.ofNullable(this.getAggregateWeight()).ifPresent(builder::setAggregateWeight);
            Optional.ofNullable(this.getCalculatedRate()).ifPresent(builder::setCalculatedRate);
            Optional.ofNullable(this.getCompoundedGrowth()).ifPresent(builder::setCompoundedGrowth);
            Optional.ofNullable(this.getGrowthFactor()).ifPresent(builder::setGrowthFactor);
            Optional.ofNullable(this.getObservations()).ifPresent(builder::setObservations);
            Optional.ofNullable(this.getWeightedRates()).ifPresent(builder::setWeightedRates);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculatedRateDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.aggregateValue, _that.getAggregateValue())) {
                return false;
            }
            if (!Objects.equals(this.aggregateWeight, _that.getAggregateWeight())) {
                return false;
            }
            if (!Objects.equals(this.calculatedRate, _that.getCalculatedRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.compoundedGrowth, _that.getCompoundedGrowth())) {
                return false;
            }
            if (!ListEquals.listEquals(this.growthFactor, _that.getGrowthFactor())) {
                return false;
            }
            if (!Objects.equals(this.observations, _that.getObservations())) {
                return false;
            }
            return ListEquals.listEquals(this.weightedRates, _that.getWeightedRates());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.aggregateValue != null ? this.aggregateValue.hashCode() : 0);
            _result = 31 * _result + (this.aggregateWeight != null ? this.aggregateWeight.hashCode() : 0);
            _result = 31 * _result + (this.calculatedRate != null ? this.calculatedRate.hashCode() : 0);
            _result = 31 * _result + (this.compoundedGrowth != null ? this.compoundedGrowth.hashCode() : 0);
            _result = 31 * _result + (this.growthFactor != null ? this.growthFactor.hashCode() : 0);
            _result = 31 * _result + (this.observations != null ? this.observations.hashCode() : 0);
            _result = 31 * _result + (this.weightedRates != null ? this.weightedRates.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculatedRateDetails {aggregateValue=" + this.aggregateValue + ", aggregateWeight=" + this.aggregateWeight + ", calculatedRate=" + this.calculatedRate + ", compoundedGrowth=" + this.compoundedGrowth + ", growthFactor=" + this.growthFactor + ", observations=" + this.observations + ", weightedRates=" + this.weightedRates + '}';
        }
    }

    public static interface CalculatedRateDetailsBuilder
    extends CalculatedRateDetails,
    RosettaModelObjectBuilder {
        public CalculatedRateObservations.CalculatedRateObservationsBuilder getOrCreateObservations();

        @Override
        public CalculatedRateObservations.CalculatedRateObservationsBuilder getObservations();

        public CalculatedRateDetailsBuilder setAggregateValue(BigDecimal var1);

        public CalculatedRateDetailsBuilder setAggregateWeight(BigDecimal var1);

        public CalculatedRateDetailsBuilder setCalculatedRate(BigDecimal var1);

        public CalculatedRateDetailsBuilder addCompoundedGrowth(BigDecimal var1);

        public CalculatedRateDetailsBuilder addCompoundedGrowth(BigDecimal var1, int var2);

        public CalculatedRateDetailsBuilder addCompoundedGrowth(List<? extends BigDecimal> var1);

        public CalculatedRateDetailsBuilder setCompoundedGrowth(List<? extends BigDecimal> var1);

        public CalculatedRateDetailsBuilder addGrowthFactor(BigDecimal var1);

        public CalculatedRateDetailsBuilder addGrowthFactor(BigDecimal var1, int var2);

        public CalculatedRateDetailsBuilder addGrowthFactor(List<? extends BigDecimal> var1);

        public CalculatedRateDetailsBuilder setGrowthFactor(List<? extends BigDecimal> var1);

        public CalculatedRateDetailsBuilder setObservations(CalculatedRateObservations var1);

        public CalculatedRateDetailsBuilder addWeightedRates(BigDecimal var1);

        public CalculatedRateDetailsBuilder addWeightedRates(BigDecimal var1, int var2);

        public CalculatedRateDetailsBuilder addWeightedRates(List<? extends BigDecimal> var1);

        public CalculatedRateDetailsBuilder setWeightedRates(List<? extends BigDecimal> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("aggregateValue"), BigDecimal.class, (Object)this.getAggregateValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("aggregateWeight"), BigDecimal.class, (Object)this.getAggregateWeight(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("calculatedRate"), BigDecimal.class, (Object)this.getCalculatedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("compoundedGrowth"), BigDecimal.class, this.getCompoundedGrowth(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("growthFactor"), BigDecimal.class, this.getGrowthFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("weightedRates"), BigDecimal.class, this.getWeightedRates(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observations"), processor, CalculatedRateObservations.CalculatedRateObservationsBuilder.class, this.getObservations(), new AttributeMeta[0]);
        }

        public CalculatedRateDetailsBuilder prune();
    }
}

