/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.staticdata.party.AncillaryEntity;
import cdm.base.staticdata.party.ReferenceBanks;
import cdm.observable.asset.FxSpotRateSource;
import cdm.observable.asset.QuotedCurrencyPair;
import cdm.observable.asset.SettlementRateOption;
import cdm.observable.asset.meta.ValuationSourceMeta;
import cdm.observable.asset.metafields.ReferenceWithMetaQuotedCurrencyPair;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface ValuationSource
extends RosettaModelObject {
    public static final ValuationSourceMeta metaData = new ValuationSourceMeta();

    public ValuationSource build();

    public ValuationSourceBuilder toBuilder();

    public AncillaryEntity getDealerOrCCP();

    public FxSpotRateSource getInformationSource();

    public ReferenceWithMetaQuotedCurrencyPair getQuotedCurrencyPair();

    public ReferenceBanks getReferenceBanks();

    public SettlementRateOption getSettlementRateOption();

    default public RosettaMetaData<? extends ValuationSource> metaData() {
        return metaData;
    }

    public static ValuationSourceBuilder builder() {
        return new ValuationSourceBuilderImpl();
    }

    default public Class<? extends ValuationSource> getType() {
        return ValuationSource.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("dealerOrCCP"), processor, AncillaryEntity.class, this.getDealerOrCCP(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, FxSpotRateSource.class, this.getInformationSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, ReferenceWithMetaQuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceBanks"), processor, ReferenceBanks.class, this.getReferenceBanks(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementRateOption"), processor, SettlementRateOption.class, this.getSettlementRateOption(), new AttributeMeta[0]);
    }

    public static class ValuationSourceBuilderImpl
    implements ValuationSourceBuilder {
        protected AncillaryEntity.AncillaryEntityBuilder dealerOrCCP;
        protected FxSpotRateSource.FxSpotRateSourceBuilder informationSource;
        protected ReferenceWithMetaQuotedCurrencyPair.ReferenceWithMetaQuotedCurrencyPairBuilder quotedCurrencyPair;
        protected ReferenceBanks.ReferenceBanksBuilder referenceBanks;
        protected SettlementRateOption.SettlementRateOptionBuilder settlementRateOption;

        @Override
        public AncillaryEntity.AncillaryEntityBuilder getDealerOrCCP() {
            return this.dealerOrCCP;
        }

        @Override
        public AncillaryEntity.AncillaryEntityBuilder getOrCreateDealerOrCCP() {
            AncillaryEntity.AncillaryEntityBuilder result = this.dealerOrCCP != null ? this.dealerOrCCP : (this.dealerOrCCP = AncillaryEntity.builder());
            return result;
        }

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getInformationSource() {
            return this.informationSource;
        }

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getOrCreateInformationSource() {
            FxSpotRateSource.FxSpotRateSourceBuilder result = this.informationSource != null ? this.informationSource : (this.informationSource = FxSpotRateSource.builder());
            return result;
        }

        @Override
        public ReferenceWithMetaQuotedCurrencyPair.ReferenceWithMetaQuotedCurrencyPairBuilder getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        public ReferenceWithMetaQuotedCurrencyPair.ReferenceWithMetaQuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair() {
            ReferenceWithMetaQuotedCurrencyPair.ReferenceWithMetaQuotedCurrencyPairBuilder result = this.quotedCurrencyPair != null ? this.quotedCurrencyPair : (this.quotedCurrencyPair = ReferenceWithMetaQuotedCurrencyPair.builder());
            return result;
        }

        @Override
        public ReferenceBanks.ReferenceBanksBuilder getReferenceBanks() {
            return this.referenceBanks;
        }

        @Override
        public ReferenceBanks.ReferenceBanksBuilder getOrCreateReferenceBanks() {
            ReferenceBanks.ReferenceBanksBuilder result = this.referenceBanks != null ? this.referenceBanks : (this.referenceBanks = ReferenceBanks.builder());
            return result;
        }

        @Override
        public SettlementRateOption.SettlementRateOptionBuilder getSettlementRateOption() {
            return this.settlementRateOption;
        }

        @Override
        public SettlementRateOption.SettlementRateOptionBuilder getOrCreateSettlementRateOption() {
            SettlementRateOption.SettlementRateOptionBuilder result = this.settlementRateOption != null ? this.settlementRateOption : (this.settlementRateOption = SettlementRateOption.builder());
            return result;
        }

        @Override
        public ValuationSourceBuilder setDealerOrCCP(AncillaryEntity dealerOrCCP) {
            this.dealerOrCCP = dealerOrCCP == null ? null : dealerOrCCP.toBuilder();
            return this;
        }

        @Override
        public ValuationSourceBuilder setInformationSource(FxSpotRateSource informationSource) {
            this.informationSource = informationSource == null ? null : informationSource.toBuilder();
            return this;
        }

        @Override
        public ValuationSourceBuilder setQuotedCurrencyPair(ReferenceWithMetaQuotedCurrencyPair quotedCurrencyPair) {
            this.quotedCurrencyPair = quotedCurrencyPair == null ? null : quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        public ValuationSourceBuilder setQuotedCurrencyPairValue(QuotedCurrencyPair quotedCurrencyPair) {
            this.getOrCreateQuotedCurrencyPair().setValue(quotedCurrencyPair);
            return this;
        }

        @Override
        public ValuationSourceBuilder setReferenceBanks(ReferenceBanks referenceBanks) {
            this.referenceBanks = referenceBanks == null ? null : referenceBanks.toBuilder();
            return this;
        }

        @Override
        public ValuationSourceBuilder setSettlementRateOption(SettlementRateOption settlementRateOption) {
            this.settlementRateOption = settlementRateOption == null ? null : settlementRateOption.toBuilder();
            return this;
        }

        @Override
        public ValuationSource build() {
            return new ValuationSourceImpl(this);
        }

        @Override
        public ValuationSourceBuilder toBuilder() {
            return this;
        }

        @Override
        public ValuationSourceBuilder prune() {
            if (this.dealerOrCCP != null && !this.dealerOrCCP.prune().hasData()) {
                this.dealerOrCCP = null;
            }
            if (this.informationSource != null && !this.informationSource.prune().hasData()) {
                this.informationSource = null;
            }
            if (this.quotedCurrencyPair != null && !this.quotedCurrencyPair.prune().hasData()) {
                this.quotedCurrencyPair = null;
            }
            if (this.referenceBanks != null && !this.referenceBanks.prune().hasData()) {
                this.referenceBanks = null;
            }
            if (this.settlementRateOption != null && !this.settlementRateOption.prune().hasData()) {
                this.settlementRateOption = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDealerOrCCP() != null && this.getDealerOrCCP().hasData()) {
                return true;
            }
            if (this.getInformationSource() != null && this.getInformationSource().hasData()) {
                return true;
            }
            if (this.getQuotedCurrencyPair() != null && this.getQuotedCurrencyPair().hasData()) {
                return true;
            }
            if (this.getReferenceBanks() != null && this.getReferenceBanks().hasData()) {
                return true;
            }
            return this.getSettlementRateOption() != null && this.getSettlementRateOption().hasData();
        }

        public ValuationSourceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ValuationSourceBuilder o = (ValuationSourceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealerOrCCP(), (RosettaModelObjectBuilder)o.getDealerOrCCP(), this::setDealerOrCCP);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInformationSource(), (RosettaModelObjectBuilder)o.getInformationSource(), this::setInformationSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), (RosettaModelObjectBuilder)o.getQuotedCurrencyPair(), this::setQuotedCurrencyPair);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceBanks(), (RosettaModelObjectBuilder)o.getReferenceBanks(), this::setReferenceBanks);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementRateOption(), (RosettaModelObjectBuilder)o.getSettlementRateOption(), this::setSettlementRateOption);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ValuationSource _that = this.getType().cast(o);
            if (!Objects.equals(this.dealerOrCCP, _that.getDealerOrCCP())) {
                return false;
            }
            if (!Objects.equals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.referenceBanks, _that.getReferenceBanks())) {
                return false;
            }
            return Objects.equals(this.settlementRateOption, _that.getSettlementRateOption());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dealerOrCCP != null ? this.dealerOrCCP.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.referenceBanks != null ? this.referenceBanks.hashCode() : 0);
            _result = 31 * _result + (this.settlementRateOption != null ? this.settlementRateOption.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationSourceBuilder {dealerOrCCP=" + this.dealerOrCCP + ", informationSource=" + this.informationSource + ", quotedCurrencyPair=" + this.quotedCurrencyPair + ", referenceBanks=" + this.referenceBanks + ", settlementRateOption=" + this.settlementRateOption + '}';
        }
    }

    public static class ValuationSourceImpl
    implements ValuationSource {
        private final AncillaryEntity dealerOrCCP;
        private final FxSpotRateSource informationSource;
        private final ReferenceWithMetaQuotedCurrencyPair quotedCurrencyPair;
        private final ReferenceBanks referenceBanks;
        private final SettlementRateOption settlementRateOption;

        protected ValuationSourceImpl(ValuationSourceBuilder builder) {
            this.dealerOrCCP = Optional.ofNullable(builder.getDealerOrCCP()).map(f -> f.build()).orElse(null);
            this.informationSource = Optional.ofNullable(builder.getInformationSource()).map(f -> f.build()).orElse(null);
            this.quotedCurrencyPair = Optional.ofNullable(builder.getQuotedCurrencyPair()).map(f -> f.build()).orElse(null);
            this.referenceBanks = Optional.ofNullable(builder.getReferenceBanks()).map(f -> f.build()).orElse(null);
            this.settlementRateOption = Optional.ofNullable(builder.getSettlementRateOption()).map(f -> f.build()).orElse(null);
        }

        @Override
        public AncillaryEntity getDealerOrCCP() {
            return this.dealerOrCCP;
        }

        @Override
        public FxSpotRateSource getInformationSource() {
            return this.informationSource;
        }

        @Override
        public ReferenceWithMetaQuotedCurrencyPair getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        public ReferenceBanks getReferenceBanks() {
            return this.referenceBanks;
        }

        @Override
        public SettlementRateOption getSettlementRateOption() {
            return this.settlementRateOption;
        }

        @Override
        public ValuationSource build() {
            return this;
        }

        @Override
        public ValuationSourceBuilder toBuilder() {
            ValuationSourceBuilder builder = ValuationSource.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ValuationSourceBuilder builder) {
            Optional.ofNullable(this.getDealerOrCCP()).ifPresent(builder::setDealerOrCCP);
            Optional.ofNullable(this.getInformationSource()).ifPresent(builder::setInformationSource);
            Optional.ofNullable(this.getQuotedCurrencyPair()).ifPresent(builder::setQuotedCurrencyPair);
            Optional.ofNullable(this.getReferenceBanks()).ifPresent(builder::setReferenceBanks);
            Optional.ofNullable(this.getSettlementRateOption()).ifPresent(builder::setSettlementRateOption);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ValuationSource _that = this.getType().cast(o);
            if (!Objects.equals(this.dealerOrCCP, _that.getDealerOrCCP())) {
                return false;
            }
            if (!Objects.equals(this.informationSource, _that.getInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.referenceBanks, _that.getReferenceBanks())) {
                return false;
            }
            return Objects.equals(this.settlementRateOption, _that.getSettlementRateOption());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dealerOrCCP != null ? this.dealerOrCCP.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.referenceBanks != null ? this.referenceBanks.hashCode() : 0);
            _result = 31 * _result + (this.settlementRateOption != null ? this.settlementRateOption.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationSource {dealerOrCCP=" + this.dealerOrCCP + ", informationSource=" + this.informationSource + ", quotedCurrencyPair=" + this.quotedCurrencyPair + ", referenceBanks=" + this.referenceBanks + ", settlementRateOption=" + this.settlementRateOption + '}';
        }
    }

    public static interface ValuationSourceBuilder
    extends ValuationSource,
    RosettaModelObjectBuilder {
        public AncillaryEntity.AncillaryEntityBuilder getOrCreateDealerOrCCP();

        @Override
        public AncillaryEntity.AncillaryEntityBuilder getDealerOrCCP();

        public FxSpotRateSource.FxSpotRateSourceBuilder getOrCreateInformationSource();

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getInformationSource();

        public ReferenceWithMetaQuotedCurrencyPair.ReferenceWithMetaQuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair();

        @Override
        public ReferenceWithMetaQuotedCurrencyPair.ReferenceWithMetaQuotedCurrencyPairBuilder getQuotedCurrencyPair();

        public ReferenceBanks.ReferenceBanksBuilder getOrCreateReferenceBanks();

        @Override
        public ReferenceBanks.ReferenceBanksBuilder getReferenceBanks();

        public SettlementRateOption.SettlementRateOptionBuilder getOrCreateSettlementRateOption();

        @Override
        public SettlementRateOption.SettlementRateOptionBuilder getSettlementRateOption();

        public ValuationSourceBuilder setDealerOrCCP(AncillaryEntity var1);

        public ValuationSourceBuilder setInformationSource(FxSpotRateSource var1);

        public ValuationSourceBuilder setQuotedCurrencyPair(ReferenceWithMetaQuotedCurrencyPair var1);

        public ValuationSourceBuilder setQuotedCurrencyPairValue(QuotedCurrencyPair var1);

        public ValuationSourceBuilder setReferenceBanks(ReferenceBanks var1);

        public ValuationSourceBuilder setSettlementRateOption(SettlementRateOption var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("dealerOrCCP"), processor, AncillaryEntity.AncillaryEntityBuilder.class, this.getDealerOrCCP(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, FxSpotRateSource.FxSpotRateSourceBuilder.class, this.getInformationSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, ReferenceWithMetaQuotedCurrencyPair.ReferenceWithMetaQuotedCurrencyPairBuilder.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceBanks"), processor, ReferenceBanks.ReferenceBanksBuilder.class, this.getReferenceBanks(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementRateOption"), processor, SettlementRateOption.SettlementRateOptionBuilder.class, this.getSettlementRateOption(), new AttributeMeta[0]);
        }

        public ValuationSourceBuilder prune();
    }
}

