/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum ValuationMethodEnum {
    MARKET,
    HIGHEST,
    AVERAGE_MARKET,
    AVERAGE_HIGHEST,
    BLENDED_MARKET,
    BLENDED_HIGHEST,
    AVERAGE_BLENDED_MARKET,
    AVERAGE_BLENDED_HIGHEST;

    private static Map<String, ValuationMethodEnum> values;
    private final String displayName;

    private ValuationMethodEnum() {
        this(null);
    }

    private ValuationMethodEnum(String displayName) {
        this.displayName = displayName;
    }

    public static ValuationMethodEnum fromDisplayName(String name) {
        ValuationMethodEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.displayName != null ? this.displayName : this.name();
    }

    static {
        ConcurrentHashMap<String, ValuationMethodEnum> map = new ConcurrentHashMap<String, ValuationMethodEnum>();
        for (ValuationMethodEnum instance : ValuationMethodEnum.values()) {
            map.put(instance.toString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

