/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.observable.asset.CashCollateralValuationMethod;
import cdm.observable.asset.Money;
import cdm.observable.asset.QuotationRateTypeEnum;
import cdm.observable.asset.ValuationMethodEnum;
import cdm.observable.asset.ValuationSource;
import cdm.observable.asset.meta.ValuationMethodMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface ValuationMethod
extends RosettaModelObject {
    public static final ValuationMethodMeta metaData = new ValuationMethodMeta();

    public ValuationMethod build();

    public ValuationMethodBuilder toBuilder();

    public CashCollateralValuationMethod getCashCollateralValuationMethod();

    public Money getMinimumQuotationAmount();

    public Money getQuotationAmount();

    public QuotationRateTypeEnum getQuotationMethod();

    public ValuationMethodEnum getValuationMethod();

    public ValuationSource getValuationSource();

    default public RosettaMetaData<? extends ValuationMethod> metaData() {
        return metaData;
    }

    public static ValuationMethodBuilder builder() {
        return new ValuationMethodBuilderImpl();
    }

    default public Class<? extends ValuationMethod> getType() {
        return ValuationMethod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("quotationMethod"), QuotationRateTypeEnum.class, (Object)this.getQuotationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationMethodEnum.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashCollateralValuationMethod"), processor, CashCollateralValuationMethod.class, this.getCashCollateralValuationMethod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("minimumQuotationAmount"), processor, Money.class, this.getMinimumQuotationAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotationAmount"), processor, Money.class, this.getQuotationAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationSource"), processor, ValuationSource.class, this.getValuationSource(), new AttributeMeta[0]);
    }

    public static class ValuationMethodBuilderImpl
    implements ValuationMethodBuilder {
        protected CashCollateralValuationMethod.CashCollateralValuationMethodBuilder cashCollateralValuationMethod;
        protected Money.MoneyBuilder minimumQuotationAmount;
        protected Money.MoneyBuilder quotationAmount;
        protected QuotationRateTypeEnum quotationMethod;
        protected ValuationMethodEnum valuationMethod;
        protected ValuationSource.ValuationSourceBuilder valuationSource;

        @Override
        public CashCollateralValuationMethod.CashCollateralValuationMethodBuilder getCashCollateralValuationMethod() {
            return this.cashCollateralValuationMethod;
        }

        @Override
        public CashCollateralValuationMethod.CashCollateralValuationMethodBuilder getOrCreateCashCollateralValuationMethod() {
            CashCollateralValuationMethod.CashCollateralValuationMethodBuilder result = this.cashCollateralValuationMethod != null ? this.cashCollateralValuationMethod : (this.cashCollateralValuationMethod = CashCollateralValuationMethod.builder());
            return result;
        }

        @Override
        public Money.MoneyBuilder getMinimumQuotationAmount() {
            return this.minimumQuotationAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateMinimumQuotationAmount() {
            Money.MoneyBuilder result = this.minimumQuotationAmount != null ? this.minimumQuotationAmount : (this.minimumQuotationAmount = Money.builder());
            return result;
        }

        @Override
        public Money.MoneyBuilder getQuotationAmount() {
            return this.quotationAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateQuotationAmount() {
            Money.MoneyBuilder result = this.quotationAmount != null ? this.quotationAmount : (this.quotationAmount = Money.builder());
            return result;
        }

        @Override
        public QuotationRateTypeEnum getQuotationMethod() {
            return this.quotationMethod;
        }

        @Override
        public ValuationMethodEnum getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        public ValuationSource.ValuationSourceBuilder getValuationSource() {
            return this.valuationSource;
        }

        @Override
        public ValuationSource.ValuationSourceBuilder getOrCreateValuationSource() {
            ValuationSource.ValuationSourceBuilder result = this.valuationSource != null ? this.valuationSource : (this.valuationSource = ValuationSource.builder());
            return result;
        }

        @Override
        public ValuationMethodBuilder setCashCollateralValuationMethod(CashCollateralValuationMethod cashCollateralValuationMethod) {
            this.cashCollateralValuationMethod = cashCollateralValuationMethod == null ? null : cashCollateralValuationMethod.toBuilder();
            return this;
        }

        @Override
        public ValuationMethodBuilder setMinimumQuotationAmount(Money minimumQuotationAmount) {
            this.minimumQuotationAmount = minimumQuotationAmount == null ? null : minimumQuotationAmount.toBuilder();
            return this;
        }

        @Override
        public ValuationMethodBuilder setQuotationAmount(Money quotationAmount) {
            this.quotationAmount = quotationAmount == null ? null : quotationAmount.toBuilder();
            return this;
        }

        @Override
        public ValuationMethodBuilder setQuotationMethod(QuotationRateTypeEnum quotationMethod) {
            this.quotationMethod = quotationMethod == null ? null : quotationMethod;
            return this;
        }

        @Override
        public ValuationMethodBuilder setValuationMethod(ValuationMethodEnum valuationMethod) {
            this.valuationMethod = valuationMethod == null ? null : valuationMethod;
            return this;
        }

        @Override
        public ValuationMethodBuilder setValuationSource(ValuationSource valuationSource) {
            this.valuationSource = valuationSource == null ? null : valuationSource.toBuilder();
            return this;
        }

        @Override
        public ValuationMethod build() {
            return new ValuationMethodImpl(this);
        }

        @Override
        public ValuationMethodBuilder toBuilder() {
            return this;
        }

        @Override
        public ValuationMethodBuilder prune() {
            if (this.cashCollateralValuationMethod != null && !this.cashCollateralValuationMethod.prune().hasData()) {
                this.cashCollateralValuationMethod = null;
            }
            if (this.minimumQuotationAmount != null && !this.minimumQuotationAmount.prune().hasData()) {
                this.minimumQuotationAmount = null;
            }
            if (this.quotationAmount != null && !this.quotationAmount.prune().hasData()) {
                this.quotationAmount = null;
            }
            if (this.valuationSource != null && !this.valuationSource.prune().hasData()) {
                this.valuationSource = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCashCollateralValuationMethod() != null && this.getCashCollateralValuationMethod().hasData()) {
                return true;
            }
            if (this.getMinimumQuotationAmount() != null && this.getMinimumQuotationAmount().hasData()) {
                return true;
            }
            if (this.getQuotationAmount() != null && this.getQuotationAmount().hasData()) {
                return true;
            }
            if (this.getQuotationMethod() != null) {
                return true;
            }
            if (this.getValuationMethod() != null) {
                return true;
            }
            return this.getValuationSource() != null && this.getValuationSource().hasData();
        }

        public ValuationMethodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ValuationMethodBuilder o = (ValuationMethodBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashCollateralValuationMethod(), (RosettaModelObjectBuilder)o.getCashCollateralValuationMethod(), this::setCashCollateralValuationMethod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMinimumQuotationAmount(), (RosettaModelObjectBuilder)o.getMinimumQuotationAmount(), this::setMinimumQuotationAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotationAmount(), (RosettaModelObjectBuilder)o.getQuotationAmount(), this::setQuotationAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationSource(), (RosettaModelObjectBuilder)o.getValuationSource(), this::setValuationSource);
            merger.mergeBasic((Object)this.getQuotationMethod(), (Object)o.getQuotationMethod(), this::setQuotationMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationMethod(), (Object)o.getValuationMethod(), this::setValuationMethod, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ValuationMethod _that = this.getType().cast(o);
            if (!Objects.equals(this.cashCollateralValuationMethod, _that.getCashCollateralValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.minimumQuotationAmount, _that.getMinimumQuotationAmount())) {
                return false;
            }
            if (!Objects.equals(this.quotationAmount, _that.getQuotationAmount())) {
                return false;
            }
            if (!Objects.equals((Object)this.quotationMethod, (Object)_that.getQuotationMethod())) {
                return false;
            }
            if (!Objects.equals((Object)this.valuationMethod, (Object)_that.getValuationMethod())) {
                return false;
            }
            return Objects.equals(this.valuationSource, _that.getValuationSource());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashCollateralValuationMethod != null ? this.cashCollateralValuationMethod.hashCode() : 0);
            _result = 31 * _result + (this.minimumQuotationAmount != null ? this.minimumQuotationAmount.hashCode() : 0);
            _result = 31 * _result + (this.quotationAmount != null ? this.quotationAmount.hashCode() : 0);
            _result = 31 * _result + (this.quotationMethod != null ? ((Object)((Object)this.quotationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? ((Object)((Object)this.valuationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationSource != null ? this.valuationSource.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationMethodBuilder {cashCollateralValuationMethod=" + this.cashCollateralValuationMethod + ", minimumQuotationAmount=" + this.minimumQuotationAmount + ", quotationAmount=" + this.quotationAmount + ", quotationMethod=" + (Object)((Object)this.quotationMethod) + ", valuationMethod=" + (Object)((Object)this.valuationMethod) + ", valuationSource=" + this.valuationSource + '}';
        }
    }

    public static class ValuationMethodImpl
    implements ValuationMethod {
        private final CashCollateralValuationMethod cashCollateralValuationMethod;
        private final Money minimumQuotationAmount;
        private final Money quotationAmount;
        private final QuotationRateTypeEnum quotationMethod;
        private final ValuationMethodEnum valuationMethod;
        private final ValuationSource valuationSource;

        protected ValuationMethodImpl(ValuationMethodBuilder builder) {
            this.cashCollateralValuationMethod = Optional.ofNullable(builder.getCashCollateralValuationMethod()).map(f -> f.build()).orElse(null);
            this.minimumQuotationAmount = Optional.ofNullable(builder.getMinimumQuotationAmount()).map(f -> f.build()).orElse(null);
            this.quotationAmount = Optional.ofNullable(builder.getQuotationAmount()).map(f -> f.build()).orElse(null);
            this.quotationMethod = builder.getQuotationMethod();
            this.valuationMethod = builder.getValuationMethod();
            this.valuationSource = Optional.ofNullable(builder.getValuationSource()).map(f -> f.build()).orElse(null);
        }

        @Override
        public CashCollateralValuationMethod getCashCollateralValuationMethod() {
            return this.cashCollateralValuationMethod;
        }

        @Override
        public Money getMinimumQuotationAmount() {
            return this.minimumQuotationAmount;
        }

        @Override
        public Money getQuotationAmount() {
            return this.quotationAmount;
        }

        @Override
        public QuotationRateTypeEnum getQuotationMethod() {
            return this.quotationMethod;
        }

        @Override
        public ValuationMethodEnum getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        public ValuationSource getValuationSource() {
            return this.valuationSource;
        }

        @Override
        public ValuationMethod build() {
            return this;
        }

        @Override
        public ValuationMethodBuilder toBuilder() {
            ValuationMethodBuilder builder = ValuationMethod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ValuationMethodBuilder builder) {
            Optional.ofNullable(this.getCashCollateralValuationMethod()).ifPresent(builder::setCashCollateralValuationMethod);
            Optional.ofNullable(this.getMinimumQuotationAmount()).ifPresent(builder::setMinimumQuotationAmount);
            Optional.ofNullable(this.getQuotationAmount()).ifPresent(builder::setQuotationAmount);
            Optional.ofNullable(this.getQuotationMethod()).ifPresent(builder::setQuotationMethod);
            Optional.ofNullable(this.getValuationMethod()).ifPresent(builder::setValuationMethod);
            Optional.ofNullable(this.getValuationSource()).ifPresent(builder::setValuationSource);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ValuationMethod _that = this.getType().cast(o);
            if (!Objects.equals(this.cashCollateralValuationMethod, _that.getCashCollateralValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.minimumQuotationAmount, _that.getMinimumQuotationAmount())) {
                return false;
            }
            if (!Objects.equals(this.quotationAmount, _that.getQuotationAmount())) {
                return false;
            }
            if (!Objects.equals((Object)this.quotationMethod, (Object)_that.getQuotationMethod())) {
                return false;
            }
            if (!Objects.equals((Object)this.valuationMethod, (Object)_that.getValuationMethod())) {
                return false;
            }
            return Objects.equals(this.valuationSource, _that.getValuationSource());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashCollateralValuationMethod != null ? this.cashCollateralValuationMethod.hashCode() : 0);
            _result = 31 * _result + (this.minimumQuotationAmount != null ? this.minimumQuotationAmount.hashCode() : 0);
            _result = 31 * _result + (this.quotationAmount != null ? this.quotationAmount.hashCode() : 0);
            _result = 31 * _result + (this.quotationMethod != null ? ((Object)((Object)this.quotationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? ((Object)((Object)this.valuationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationSource != null ? this.valuationSource.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationMethod {cashCollateralValuationMethod=" + this.cashCollateralValuationMethod + ", minimumQuotationAmount=" + this.minimumQuotationAmount + ", quotationAmount=" + this.quotationAmount + ", quotationMethod=" + (Object)((Object)this.quotationMethod) + ", valuationMethod=" + (Object)((Object)this.valuationMethod) + ", valuationSource=" + this.valuationSource + '}';
        }
    }

    public static interface ValuationMethodBuilder
    extends ValuationMethod,
    RosettaModelObjectBuilder {
        public CashCollateralValuationMethod.CashCollateralValuationMethodBuilder getOrCreateCashCollateralValuationMethod();

        @Override
        public CashCollateralValuationMethod.CashCollateralValuationMethodBuilder getCashCollateralValuationMethod();

        public Money.MoneyBuilder getOrCreateMinimumQuotationAmount();

        @Override
        public Money.MoneyBuilder getMinimumQuotationAmount();

        public Money.MoneyBuilder getOrCreateQuotationAmount();

        @Override
        public Money.MoneyBuilder getQuotationAmount();

        public ValuationSource.ValuationSourceBuilder getOrCreateValuationSource();

        @Override
        public ValuationSource.ValuationSourceBuilder getValuationSource();

        public ValuationMethodBuilder setCashCollateralValuationMethod(CashCollateralValuationMethod var1);

        public ValuationMethodBuilder setMinimumQuotationAmount(Money var1);

        public ValuationMethodBuilder setQuotationAmount(Money var1);

        public ValuationMethodBuilder setQuotationMethod(QuotationRateTypeEnum var1);

        public ValuationMethodBuilder setValuationMethod(ValuationMethodEnum var1);

        public ValuationMethodBuilder setValuationSource(ValuationSource var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("quotationMethod"), QuotationRateTypeEnum.class, (Object)this.getQuotationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationMethodEnum.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashCollateralValuationMethod"), processor, CashCollateralValuationMethod.CashCollateralValuationMethodBuilder.class, this.getCashCollateralValuationMethod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("minimumQuotationAmount"), processor, Money.MoneyBuilder.class, this.getMinimumQuotationAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotationAmount"), processor, Money.MoneyBuilder.class, this.getQuotationAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationSource"), processor, ValuationSource.ValuationSourceBuilder.class, this.getValuationSource(), new AttributeMeta[0]);
        }

        public ValuationMethodBuilder prune();
    }
}

