/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.math.Quantity;
import cdm.observable.asset.Money;
import cdm.observable.asset.meta.UnitContractValuationModelMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface UnitContractValuationModel
extends RosettaModelObject {
    public static final UnitContractValuationModelMeta metaData = new UnitContractValuationModelMeta();

    public UnitContractValuationModel build();

    public UnitContractValuationModelBuilder toBuilder();

    public Quantity getNumberOfUnits();

    public Money getUnitPrice();

    default public RosettaMetaData<? extends UnitContractValuationModel> metaData() {
        return metaData;
    }

    public static UnitContractValuationModelBuilder builder() {
        return new UnitContractValuationModelBuilderImpl();
    }

    default public Class<? extends UnitContractValuationModel> getType() {
        return UnitContractValuationModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("numberOfUnits"), processor, Quantity.class, this.getNumberOfUnits(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("unitPrice"), processor, Money.class, this.getUnitPrice(), new AttributeMeta[0]);
    }

    public static class UnitContractValuationModelBuilderImpl
    implements UnitContractValuationModelBuilder {
        protected Quantity.QuantityBuilder numberOfUnits;
        protected Money.MoneyBuilder unitPrice;

        @Override
        public Quantity.QuantityBuilder getNumberOfUnits() {
            return this.numberOfUnits;
        }

        @Override
        public Quantity.QuantityBuilder getOrCreateNumberOfUnits() {
            Quantity.QuantityBuilder result = this.numberOfUnits != null ? this.numberOfUnits : (this.numberOfUnits = Quantity.builder());
            return result;
        }

        @Override
        public Money.MoneyBuilder getUnitPrice() {
            return this.unitPrice;
        }

        @Override
        public Money.MoneyBuilder getOrCreateUnitPrice() {
            Money.MoneyBuilder result = this.unitPrice != null ? this.unitPrice : (this.unitPrice = Money.builder());
            return result;
        }

        @Override
        public UnitContractValuationModelBuilder setNumberOfUnits(Quantity numberOfUnits) {
            this.numberOfUnits = numberOfUnits == null ? null : numberOfUnits.toBuilder();
            return this;
        }

        @Override
        public UnitContractValuationModelBuilder setUnitPrice(Money unitPrice) {
            this.unitPrice = unitPrice == null ? null : unitPrice.toBuilder();
            return this;
        }

        @Override
        public UnitContractValuationModel build() {
            return new UnitContractValuationModelImpl(this);
        }

        @Override
        public UnitContractValuationModelBuilder toBuilder() {
            return this;
        }

        @Override
        public UnitContractValuationModelBuilder prune() {
            if (this.numberOfUnits != null && !this.numberOfUnits.prune().hasData()) {
                this.numberOfUnits = null;
            }
            if (this.unitPrice != null && !this.unitPrice.prune().hasData()) {
                this.unitPrice = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getNumberOfUnits() != null && this.getNumberOfUnits().hasData()) {
                return true;
            }
            return this.getUnitPrice() != null && this.getUnitPrice().hasData();
        }

        public UnitContractValuationModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            UnitContractValuationModelBuilder o = (UnitContractValuationModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNumberOfUnits(), (RosettaModelObjectBuilder)o.getNumberOfUnits(), this::setNumberOfUnits);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnitPrice(), (RosettaModelObjectBuilder)o.getUnitPrice(), this::setUnitPrice);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            UnitContractValuationModel _that = this.getType().cast(o);
            if (!Objects.equals(this.numberOfUnits, _that.getNumberOfUnits())) {
                return false;
            }
            return Objects.equals(this.unitPrice, _that.getUnitPrice());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.numberOfUnits != null ? this.numberOfUnits.hashCode() : 0);
            _result = 31 * _result + (this.unitPrice != null ? this.unitPrice.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "UnitContractValuationModelBuilder {numberOfUnits=" + this.numberOfUnits + ", unitPrice=" + this.unitPrice + '}';
        }
    }

    public static class UnitContractValuationModelImpl
    implements UnitContractValuationModel {
        private final Quantity numberOfUnits;
        private final Money unitPrice;

        protected UnitContractValuationModelImpl(UnitContractValuationModelBuilder builder) {
            this.numberOfUnits = Optional.ofNullable(builder.getNumberOfUnits()).map(f -> f.build()).orElse(null);
            this.unitPrice = Optional.ofNullable(builder.getUnitPrice()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Quantity getNumberOfUnits() {
            return this.numberOfUnits;
        }

        @Override
        public Money getUnitPrice() {
            return this.unitPrice;
        }

        @Override
        public UnitContractValuationModel build() {
            return this;
        }

        @Override
        public UnitContractValuationModelBuilder toBuilder() {
            UnitContractValuationModelBuilder builder = UnitContractValuationModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(UnitContractValuationModelBuilder builder) {
            Optional.ofNullable(this.getNumberOfUnits()).ifPresent(builder::setNumberOfUnits);
            Optional.ofNullable(this.getUnitPrice()).ifPresent(builder::setUnitPrice);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            UnitContractValuationModel _that = this.getType().cast(o);
            if (!Objects.equals(this.numberOfUnits, _that.getNumberOfUnits())) {
                return false;
            }
            return Objects.equals(this.unitPrice, _that.getUnitPrice());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.numberOfUnits != null ? this.numberOfUnits.hashCode() : 0);
            _result = 31 * _result + (this.unitPrice != null ? this.unitPrice.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "UnitContractValuationModel {numberOfUnits=" + this.numberOfUnits + ", unitPrice=" + this.unitPrice + '}';
        }
    }

    public static interface UnitContractValuationModelBuilder
    extends UnitContractValuationModel,
    RosettaModelObjectBuilder {
        public Quantity.QuantityBuilder getOrCreateNumberOfUnits();

        @Override
        public Quantity.QuantityBuilder getNumberOfUnits();

        public Money.MoneyBuilder getOrCreateUnitPrice();

        @Override
        public Money.MoneyBuilder getUnitPrice();

        public UnitContractValuationModelBuilder setNumberOfUnits(Quantity var1);

        public UnitContractValuationModelBuilder setUnitPrice(Money var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("numberOfUnits"), processor, Quantity.QuantityBuilder.class, this.getNumberOfUnits(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("unitPrice"), processor, Money.MoneyBuilder.class, this.getUnitPrice(), new AttributeMeta[0]);
        }

        public UnitContractValuationModelBuilder prune();
    }
}

