/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.observable.asset.QuotationStyleEnum;
import cdm.observable.asset.meta.TransactedPriceMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface TransactedPrice
extends RosettaModelObject {
    public static final TransactedPriceMeta metaData = new TransactedPriceMeta();

    public TransactedPrice build();

    public TransactedPriceBuilder toBuilder();

    public BigDecimal getInitialPoints();

    public BigDecimal getMarketFixedRate();

    public BigDecimal getMarketPrice();

    public QuotationStyleEnum getQuotationStyle();

    default public RosettaMetaData<? extends TransactedPrice> metaData() {
        return metaData;
    }

    public static TransactedPriceBuilder builder() {
        return new TransactedPriceBuilderImpl();
    }

    default public Class<? extends TransactedPrice> getType() {
        return TransactedPrice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("initialPoints"), BigDecimal.class, (Object)this.getInitialPoints(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("marketFixedRate"), BigDecimal.class, (Object)this.getMarketFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("marketPrice"), BigDecimal.class, (Object)this.getMarketPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quotationStyle"), QuotationStyleEnum.class, (Object)this.getQuotationStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class TransactedPriceBuilderImpl
    implements TransactedPriceBuilder {
        protected BigDecimal initialPoints;
        protected BigDecimal marketFixedRate;
        protected BigDecimal marketPrice;
        protected QuotationStyleEnum quotationStyle;

        @Override
        public BigDecimal getInitialPoints() {
            return this.initialPoints;
        }

        @Override
        public BigDecimal getMarketFixedRate() {
            return this.marketFixedRate;
        }

        @Override
        public BigDecimal getMarketPrice() {
            return this.marketPrice;
        }

        @Override
        public QuotationStyleEnum getQuotationStyle() {
            return this.quotationStyle;
        }

        @Override
        public TransactedPriceBuilder setInitialPoints(BigDecimal initialPoints) {
            this.initialPoints = initialPoints == null ? null : initialPoints;
            return this;
        }

        @Override
        public TransactedPriceBuilder setMarketFixedRate(BigDecimal marketFixedRate) {
            this.marketFixedRate = marketFixedRate == null ? null : marketFixedRate;
            return this;
        }

        @Override
        public TransactedPriceBuilder setMarketPrice(BigDecimal marketPrice) {
            this.marketPrice = marketPrice == null ? null : marketPrice;
            return this;
        }

        @Override
        public TransactedPriceBuilder setQuotationStyle(QuotationStyleEnum quotationStyle) {
            this.quotationStyle = quotationStyle == null ? null : quotationStyle;
            return this;
        }

        @Override
        public TransactedPrice build() {
            return new TransactedPriceImpl(this);
        }

        @Override
        public TransactedPriceBuilder toBuilder() {
            return this;
        }

        @Override
        public TransactedPriceBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getInitialPoints() != null) {
                return true;
            }
            if (this.getMarketFixedRate() != null) {
                return true;
            }
            if (this.getMarketPrice() != null) {
                return true;
            }
            return this.getQuotationStyle() != null;
        }

        public TransactedPriceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TransactedPriceBuilder o = (TransactedPriceBuilder)other;
            merger.mergeBasic((Object)this.getInitialPoints(), (Object)o.getInitialPoints(), this::setInitialPoints, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMarketFixedRate(), (Object)o.getMarketFixedRate(), this::setMarketFixedRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMarketPrice(), (Object)o.getMarketPrice(), this::setMarketPrice, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuotationStyle(), (Object)o.getQuotationStyle(), this::setQuotationStyle, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TransactedPrice _that = this.getType().cast(o);
            if (!Objects.equals(this.initialPoints, _that.getInitialPoints())) {
                return false;
            }
            if (!Objects.equals(this.marketFixedRate, _that.getMarketFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.marketPrice, _that.getMarketPrice())) {
                return false;
            }
            return Objects.equals((Object)this.quotationStyle, (Object)_that.getQuotationStyle());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialPoints != null ? this.initialPoints.hashCode() : 0);
            _result = 31 * _result + (this.marketFixedRate != null ? this.marketFixedRate.hashCode() : 0);
            _result = 31 * _result + (this.marketPrice != null ? this.marketPrice.hashCode() : 0);
            _result = 31 * _result + (this.quotationStyle != null ? ((Object)((Object)this.quotationStyle)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TransactedPriceBuilder {initialPoints=" + this.initialPoints + ", marketFixedRate=" + this.marketFixedRate + ", marketPrice=" + this.marketPrice + ", quotationStyle=" + (Object)((Object)this.quotationStyle) + '}';
        }
    }

    public static class TransactedPriceImpl
    implements TransactedPrice {
        private final BigDecimal initialPoints;
        private final BigDecimal marketFixedRate;
        private final BigDecimal marketPrice;
        private final QuotationStyleEnum quotationStyle;

        protected TransactedPriceImpl(TransactedPriceBuilder builder) {
            this.initialPoints = builder.getInitialPoints();
            this.marketFixedRate = builder.getMarketFixedRate();
            this.marketPrice = builder.getMarketPrice();
            this.quotationStyle = builder.getQuotationStyle();
        }

        @Override
        public BigDecimal getInitialPoints() {
            return this.initialPoints;
        }

        @Override
        public BigDecimal getMarketFixedRate() {
            return this.marketFixedRate;
        }

        @Override
        public BigDecimal getMarketPrice() {
            return this.marketPrice;
        }

        @Override
        public QuotationStyleEnum getQuotationStyle() {
            return this.quotationStyle;
        }

        @Override
        public TransactedPrice build() {
            return this;
        }

        @Override
        public TransactedPriceBuilder toBuilder() {
            TransactedPriceBuilder builder = TransactedPrice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TransactedPriceBuilder builder) {
            Optional.ofNullable(this.getInitialPoints()).ifPresent(builder::setInitialPoints);
            Optional.ofNullable(this.getMarketFixedRate()).ifPresent(builder::setMarketFixedRate);
            Optional.ofNullable(this.getMarketPrice()).ifPresent(builder::setMarketPrice);
            Optional.ofNullable(this.getQuotationStyle()).ifPresent(builder::setQuotationStyle);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TransactedPrice _that = this.getType().cast(o);
            if (!Objects.equals(this.initialPoints, _that.getInitialPoints())) {
                return false;
            }
            if (!Objects.equals(this.marketFixedRate, _that.getMarketFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.marketPrice, _that.getMarketPrice())) {
                return false;
            }
            return Objects.equals((Object)this.quotationStyle, (Object)_that.getQuotationStyle());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.initialPoints != null ? this.initialPoints.hashCode() : 0);
            _result = 31 * _result + (this.marketFixedRate != null ? this.marketFixedRate.hashCode() : 0);
            _result = 31 * _result + (this.marketPrice != null ? this.marketPrice.hashCode() : 0);
            _result = 31 * _result + (this.quotationStyle != null ? ((Object)((Object)this.quotationStyle)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TransactedPrice {initialPoints=" + this.initialPoints + ", marketFixedRate=" + this.marketFixedRate + ", marketPrice=" + this.marketPrice + ", quotationStyle=" + (Object)((Object)this.quotationStyle) + '}';
        }
    }

    public static interface TransactedPriceBuilder
    extends TransactedPrice,
    RosettaModelObjectBuilder {
        public TransactedPriceBuilder setInitialPoints(BigDecimal var1);

        public TransactedPriceBuilder setMarketFixedRate(BigDecimal var1);

        public TransactedPriceBuilder setMarketPrice(BigDecimal var1);

        public TransactedPriceBuilder setQuotationStyle(QuotationStyleEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("initialPoints"), BigDecimal.class, (Object)this.getInitialPoints(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("marketFixedRate"), BigDecimal.class, (Object)this.getMarketFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("marketPrice"), BigDecimal.class, (Object)this.getMarketPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quotationStyle"), QuotationStyleEnum.class, (Object)this.getQuotationStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public TransactedPriceBuilder prune();
    }
}

