/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.observable.asset.meta.RateObservationMeta;
import cdm.observable.asset.metafields.ReferenceWithMetaRateObservation;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface RateObservation
extends RosettaModelObject,
GlobalKey {
    public static final RateObservationMeta metaData = new RateObservationMeta();

    public RateObservation build();

    public RateObservationBuilder toBuilder();

    public Date getAdjustedFixingDate();

    public BigDecimal getForecastRate();

    public MetaFields getMeta();

    public Integer getObservationWeight();

    public BigDecimal getObservedRate();

    public ReferenceWithMetaRateObservation getRateReference();

    public Date getResetDate();

    public BigDecimal getTreatedForecastRate();

    public BigDecimal getTreatedRate();

    default public RosettaMetaData<? extends RateObservation> metaData() {
        return metaData;
    }

    public static RateObservationBuilder builder() {
        return new RateObservationBuilderImpl();
    }

    default public Class<? extends RateObservation> getType() {
        return RateObservation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("adjustedFixingDate"), Date.class, (Object)this.getAdjustedFixingDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("forecastRate"), BigDecimal.class, (Object)this.getForecastRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("observationWeight"), Integer.class, (Object)this.getObservationWeight(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("observedRate"), BigDecimal.class, (Object)this.getObservedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("resetDate"), Date.class, (Object)this.getResetDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("treatedForecastRate"), BigDecimal.class, (Object)this.getTreatedForecastRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("treatedRate"), BigDecimal.class, (Object)this.getTreatedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rateReference"), processor, ReferenceWithMetaRateObservation.class, this.getRateReference(), new AttributeMeta[0]);
    }

    public static class RateObservationBuilderImpl
    implements RateObservationBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected Date adjustedFixingDate;
        protected BigDecimal forecastRate;
        protected MetaFields.MetaFieldsBuilder meta;
        protected Integer observationWeight;
        protected BigDecimal observedRate;
        protected ReferenceWithMetaRateObservation.ReferenceWithMetaRateObservationBuilder rateReference;
        protected Date resetDate;
        protected BigDecimal treatedForecastRate;
        protected BigDecimal treatedRate;

        @Override
        public Date getAdjustedFixingDate() {
            return this.adjustedFixingDate;
        }

        @Override
        public BigDecimal getForecastRate() {
            return this.forecastRate;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public Integer getObservationWeight() {
            return this.observationWeight;
        }

        @Override
        public BigDecimal getObservedRate() {
            return this.observedRate;
        }

        @Override
        public ReferenceWithMetaRateObservation.ReferenceWithMetaRateObservationBuilder getRateReference() {
            return this.rateReference;
        }

        @Override
        public ReferenceWithMetaRateObservation.ReferenceWithMetaRateObservationBuilder getOrCreateRateReference() {
            ReferenceWithMetaRateObservation.ReferenceWithMetaRateObservationBuilder result = this.rateReference != null ? this.rateReference : (this.rateReference = ReferenceWithMetaRateObservation.builder());
            return result;
        }

        @Override
        public Date getResetDate() {
            return this.resetDate;
        }

        @Override
        public BigDecimal getTreatedForecastRate() {
            return this.treatedForecastRate;
        }

        @Override
        public BigDecimal getTreatedRate() {
            return this.treatedRate;
        }

        @Override
        public RateObservationBuilder setAdjustedFixingDate(Date adjustedFixingDate) {
            this.adjustedFixingDate = adjustedFixingDate == null ? null : adjustedFixingDate;
            return this;
        }

        @Override
        public RateObservationBuilder setForecastRate(BigDecimal forecastRate) {
            this.forecastRate = forecastRate == null ? null : forecastRate;
            return this;
        }

        @Override
        public RateObservationBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public RateObservationBuilder setObservationWeight(Integer observationWeight) {
            this.observationWeight = observationWeight == null ? null : observationWeight;
            return this;
        }

        @Override
        public RateObservationBuilder setObservedRate(BigDecimal observedRate) {
            this.observedRate = observedRate == null ? null : observedRate;
            return this;
        }

        @Override
        public RateObservationBuilder setRateReference(ReferenceWithMetaRateObservation rateReference) {
            this.rateReference = rateReference == null ? null : rateReference.toBuilder();
            return this;
        }

        @Override
        public RateObservationBuilder setRateReferenceValue(RateObservation rateReference) {
            this.getOrCreateRateReference().setValue(rateReference);
            return this;
        }

        @Override
        public RateObservationBuilder setResetDate(Date resetDate) {
            this.resetDate = resetDate == null ? null : resetDate;
            return this;
        }

        @Override
        public RateObservationBuilder setTreatedForecastRate(BigDecimal treatedForecastRate) {
            this.treatedForecastRate = treatedForecastRate == null ? null : treatedForecastRate;
            return this;
        }

        @Override
        public RateObservationBuilder setTreatedRate(BigDecimal treatedRate) {
            this.treatedRate = treatedRate == null ? null : treatedRate;
            return this;
        }

        @Override
        public RateObservation build() {
            return new RateObservationImpl(this);
        }

        @Override
        public RateObservationBuilder toBuilder() {
            return this;
        }

        @Override
        public RateObservationBuilder prune() {
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.rateReference != null && !this.rateReference.prune().hasData()) {
                this.rateReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAdjustedFixingDate() != null) {
                return true;
            }
            if (this.getForecastRate() != null) {
                return true;
            }
            if (this.getObservationWeight() != null) {
                return true;
            }
            if (this.getObservedRate() != null) {
                return true;
            }
            if (this.getRateReference() != null && this.getRateReference().hasData()) {
                return true;
            }
            if (this.getResetDate() != null) {
                return true;
            }
            if (this.getTreatedForecastRate() != null) {
                return true;
            }
            return this.getTreatedRate() != null;
        }

        public RateObservationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RateObservationBuilder o = (RateObservationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRateReference(), (RosettaModelObjectBuilder)o.getRateReference(), this::setRateReference);
            merger.mergeBasic((Object)this.getAdjustedFixingDate(), (Object)o.getAdjustedFixingDate(), this::setAdjustedFixingDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getForecastRate(), (Object)o.getForecastRate(), this::setForecastRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getObservationWeight(), (Object)o.getObservationWeight(), this::setObservationWeight, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getObservedRate(), (Object)o.getObservedRate(), this::setObservedRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getResetDate(), (Object)o.getResetDate(), this::setResetDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTreatedForecastRate(), (Object)o.getTreatedForecastRate(), this::setTreatedForecastRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTreatedRate(), (Object)o.getTreatedRate(), this::setTreatedRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RateObservation _that = this.getType().cast(o);
            if (!Objects.equals(this.adjustedFixingDate, _that.getAdjustedFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.forecastRate, _that.getForecastRate())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.observationWeight, _that.getObservationWeight())) {
                return false;
            }
            if (!Objects.equals(this.observedRate, _that.getObservedRate())) {
                return false;
            }
            if (!Objects.equals(this.rateReference, _that.getRateReference())) {
                return false;
            }
            if (!Objects.equals(this.resetDate, _that.getResetDate())) {
                return false;
            }
            if (!Objects.equals(this.treatedForecastRate, _that.getTreatedForecastRate())) {
                return false;
            }
            return Objects.equals(this.treatedRate, _that.getTreatedRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustedFixingDate != null ? this.adjustedFixingDate.hashCode() : 0);
            _result = 31 * _result + (this.forecastRate != null ? this.forecastRate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.observationWeight != null ? this.observationWeight.hashCode() : 0);
            _result = 31 * _result + (this.observedRate != null ? this.observedRate.hashCode() : 0);
            _result = 31 * _result + (this.rateReference != null ? this.rateReference.hashCode() : 0);
            _result = 31 * _result + (this.resetDate != null ? this.resetDate.hashCode() : 0);
            _result = 31 * _result + (this.treatedForecastRate != null ? this.treatedForecastRate.hashCode() : 0);
            _result = 31 * _result + (this.treatedRate != null ? this.treatedRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RateObservationBuilder {adjustedFixingDate=" + this.adjustedFixingDate + ", forecastRate=" + this.forecastRate + ", meta=" + this.meta + ", observationWeight=" + this.observationWeight + ", observedRate=" + this.observedRate + ", rateReference=" + this.rateReference + ", resetDate=" + this.resetDate + ", treatedForecastRate=" + this.treatedForecastRate + ", treatedRate=" + this.treatedRate + '}';
        }
    }

    public static class RateObservationImpl
    implements RateObservation {
        private final Date adjustedFixingDate;
        private final BigDecimal forecastRate;
        private final MetaFields meta;
        private final Integer observationWeight;
        private final BigDecimal observedRate;
        private final ReferenceWithMetaRateObservation rateReference;
        private final Date resetDate;
        private final BigDecimal treatedForecastRate;
        private final BigDecimal treatedRate;

        protected RateObservationImpl(RateObservationBuilder builder) {
            this.adjustedFixingDate = builder.getAdjustedFixingDate();
            this.forecastRate = builder.getForecastRate();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.observationWeight = builder.getObservationWeight();
            this.observedRate = builder.getObservedRate();
            this.rateReference = Optional.ofNullable(builder.getRateReference()).map(f -> f.build()).orElse(null);
            this.resetDate = builder.getResetDate();
            this.treatedForecastRate = builder.getTreatedForecastRate();
            this.treatedRate = builder.getTreatedRate();
        }

        @Override
        public Date getAdjustedFixingDate() {
            return this.adjustedFixingDate;
        }

        @Override
        public BigDecimal getForecastRate() {
            return this.forecastRate;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Integer getObservationWeight() {
            return this.observationWeight;
        }

        @Override
        public BigDecimal getObservedRate() {
            return this.observedRate;
        }

        @Override
        public ReferenceWithMetaRateObservation getRateReference() {
            return this.rateReference;
        }

        @Override
        public Date getResetDate() {
            return this.resetDate;
        }

        @Override
        public BigDecimal getTreatedForecastRate() {
            return this.treatedForecastRate;
        }

        @Override
        public BigDecimal getTreatedRate() {
            return this.treatedRate;
        }

        @Override
        public RateObservation build() {
            return this;
        }

        @Override
        public RateObservationBuilder toBuilder() {
            RateObservationBuilder builder = RateObservation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RateObservationBuilder builder) {
            Optional.ofNullable(this.getAdjustedFixingDate()).ifPresent(builder::setAdjustedFixingDate);
            Optional.ofNullable(this.getForecastRate()).ifPresent(builder::setForecastRate);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getObservationWeight()).ifPresent(builder::setObservationWeight);
            Optional.ofNullable(this.getObservedRate()).ifPresent(builder::setObservedRate);
            Optional.ofNullable(this.getRateReference()).ifPresent(builder::setRateReference);
            Optional.ofNullable(this.getResetDate()).ifPresent(builder::setResetDate);
            Optional.ofNullable(this.getTreatedForecastRate()).ifPresent(builder::setTreatedForecastRate);
            Optional.ofNullable(this.getTreatedRate()).ifPresent(builder::setTreatedRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RateObservation _that = this.getType().cast(o);
            if (!Objects.equals(this.adjustedFixingDate, _that.getAdjustedFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.forecastRate, _that.getForecastRate())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.observationWeight, _that.getObservationWeight())) {
                return false;
            }
            if (!Objects.equals(this.observedRate, _that.getObservedRate())) {
                return false;
            }
            if (!Objects.equals(this.rateReference, _that.getRateReference())) {
                return false;
            }
            if (!Objects.equals(this.resetDate, _that.getResetDate())) {
                return false;
            }
            if (!Objects.equals(this.treatedForecastRate, _that.getTreatedForecastRate())) {
                return false;
            }
            return Objects.equals(this.treatedRate, _that.getTreatedRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustedFixingDate != null ? this.adjustedFixingDate.hashCode() : 0);
            _result = 31 * _result + (this.forecastRate != null ? this.forecastRate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.observationWeight != null ? this.observationWeight.hashCode() : 0);
            _result = 31 * _result + (this.observedRate != null ? this.observedRate.hashCode() : 0);
            _result = 31 * _result + (this.rateReference != null ? this.rateReference.hashCode() : 0);
            _result = 31 * _result + (this.resetDate != null ? this.resetDate.hashCode() : 0);
            _result = 31 * _result + (this.treatedForecastRate != null ? this.treatedForecastRate.hashCode() : 0);
            _result = 31 * _result + (this.treatedRate != null ? this.treatedRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RateObservation {adjustedFixingDate=" + this.adjustedFixingDate + ", forecastRate=" + this.forecastRate + ", meta=" + this.meta + ", observationWeight=" + this.observationWeight + ", observedRate=" + this.observedRate + ", rateReference=" + this.rateReference + ", resetDate=" + this.resetDate + ", treatedForecastRate=" + this.treatedForecastRate + ", treatedRate=" + this.treatedRate + '}';
        }
    }

    public static interface RateObservationBuilder
    extends RateObservation,
    RosettaModelObjectBuilder {
        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public ReferenceWithMetaRateObservation.ReferenceWithMetaRateObservationBuilder getOrCreateRateReference();

        @Override
        public ReferenceWithMetaRateObservation.ReferenceWithMetaRateObservationBuilder getRateReference();

        public RateObservationBuilder setAdjustedFixingDate(Date var1);

        public RateObservationBuilder setForecastRate(BigDecimal var1);

        public RateObservationBuilder setMeta(MetaFields var1);

        public RateObservationBuilder setObservationWeight(Integer var1);

        public RateObservationBuilder setObservedRate(BigDecimal var1);

        public RateObservationBuilder setRateReference(ReferenceWithMetaRateObservation var1);

        public RateObservationBuilder setRateReferenceValue(RateObservation var1);

        public RateObservationBuilder setResetDate(Date var1);

        public RateObservationBuilder setTreatedForecastRate(BigDecimal var1);

        public RateObservationBuilder setTreatedRate(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("adjustedFixingDate"), Date.class, (Object)this.getAdjustedFixingDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("forecastRate"), BigDecimal.class, (Object)this.getForecastRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("observationWeight"), Integer.class, (Object)this.getObservationWeight(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("observedRate"), BigDecimal.class, (Object)this.getObservedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("resetDate"), Date.class, (Object)this.getResetDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("treatedForecastRate"), BigDecimal.class, (Object)this.getTreatedForecastRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("treatedRate"), BigDecimal.class, (Object)this.getTreatedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rateReference"), processor, ReferenceWithMetaRateObservation.ReferenceWithMetaRateObservationBuilder.class, this.getRateReference(), new AttributeMeta[0]);
        }

        public RateObservationBuilder prune();
    }
}

