/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum PriceTypeEnum {
    ASSET_PRICE,
    CASH_PRICE,
    CORRELATION,
    DIVIDEND,
    EXCHANGE_RATE,
    MULTIPLIER_OF_INDEX_VALUE,
    INTEREST_RATE,
    VARIANCE,
    VOLATILITY;

    private static Map<String, PriceTypeEnum> values;
    private final String displayName;

    private PriceTypeEnum() {
        this(null);
    }

    private PriceTypeEnum(String displayName) {
        this.displayName = displayName;
    }

    public static PriceTypeEnum fromDisplayName(String name) {
        PriceTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.displayName != null ? this.displayName : this.name();
    }

    static {
        ConcurrentHashMap<String, PriceTypeEnum> map = new ConcurrentHashMap<String, PriceTypeEnum>();
        for (PriceTypeEnum instance : PriceTypeEnum.values()) {
            map.put(instance.toString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

