/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.math.DatedValue;
import cdm.base.math.MeasureSchedule;
import cdm.base.math.UnitType;
import cdm.observable.asset.PriceExpression;
import cdm.observable.asset.meta.PriceScheduleMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface PriceSchedule
extends MeasureSchedule {
    public static final PriceScheduleMeta metaData = new PriceScheduleMeta();

    @Override
    public PriceSchedule build();

    @Override
    public PriceScheduleBuilder toBuilder();

    public UnitType getPerUnitOf();

    public PriceExpression getPriceExpression();

    default public RosettaMetaData<? extends PriceSchedule> metaData() {
        return metaData;
    }

    public static PriceScheduleBuilder builder() {
        return new PriceScheduleBuilderImpl();
    }

    default public Class<? extends PriceSchedule> getType() {
        return PriceSchedule.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        MeasureSchedule.super.process(path, processor);
        this.processRosetta(path.newSubPath("perUnitOf"), processor, UnitType.class, this.getPerUnitOf(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceExpression"), processor, PriceExpression.class, this.getPriceExpression(), new AttributeMeta[0]);
    }

    public static class PriceScheduleBuilderImpl
    extends MeasureSchedule.MeasureScheduleBuilderImpl
    implements PriceScheduleBuilder {
        protected UnitType.UnitTypeBuilder perUnitOf;
        protected PriceExpression.PriceExpressionBuilder priceExpression;

        @Override
        public UnitType.UnitTypeBuilder getPerUnitOf() {
            return this.perUnitOf;
        }

        @Override
        public UnitType.UnitTypeBuilder getOrCreatePerUnitOf() {
            UnitType.UnitTypeBuilder result = this.perUnitOf != null ? this.perUnitOf : (this.perUnitOf = UnitType.builder());
            return result;
        }

        @Override
        public PriceExpression.PriceExpressionBuilder getPriceExpression() {
            return this.priceExpression;
        }

        @Override
        public PriceExpression.PriceExpressionBuilder getOrCreatePriceExpression() {
            PriceExpression.PriceExpressionBuilder result = this.priceExpression != null ? this.priceExpression : (this.priceExpression = PriceExpression.builder());
            return result;
        }

        @Override
        public PriceScheduleBuilder setPerUnitOf(UnitType perUnitOf) {
            this.perUnitOf = perUnitOf == null ? null : perUnitOf.toBuilder();
            return this;
        }

        @Override
        public PriceScheduleBuilder setPriceExpression(PriceExpression priceExpression) {
            this.priceExpression = priceExpression == null ? null : priceExpression.toBuilder();
            return this;
        }

        @Override
        public PriceScheduleBuilder addDatedValue(DatedValue datedValue) {
            if (datedValue != null) {
                this.datedValue.add(datedValue.toBuilder());
            }
            return this;
        }

        @Override
        public PriceScheduleBuilder addDatedValue(DatedValue datedValue, int _idx) {
            this.getIndex(this.datedValue, _idx, () -> datedValue.toBuilder());
            return this;
        }

        @Override
        public PriceScheduleBuilder addDatedValue(List<? extends DatedValue> datedValues) {
            if (datedValues != null) {
                for (DatedValue datedValue : datedValues) {
                    this.datedValue.add(datedValue.toBuilder());
                }
            }
            return this;
        }

        @Override
        public PriceScheduleBuilder setDatedValue(List<? extends DatedValue> datedValues) {
            this.datedValue = datedValues == null ? new ArrayList() : (List)datedValues.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PriceScheduleBuilder setUnit(UnitType unit) {
            this.unit = unit == null ? null : unit.toBuilder();
            return this;
        }

        @Override
        public PriceScheduleBuilder setValue(BigDecimal value) {
            this.value = value == null ? null : value;
            return this;
        }

        @Override
        public PriceSchedule build() {
            return new PriceScheduleImpl(this);
        }

        @Override
        public PriceScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public PriceScheduleBuilder prune() {
            super.prune();
            if (this.perUnitOf != null && !this.perUnitOf.prune().hasData()) {
                this.perUnitOf = null;
            }
            if (this.priceExpression != null && !this.priceExpression.prune().hasData()) {
                this.priceExpression = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPerUnitOf() != null && this.getPerUnitOf().hasData()) {
                return true;
            }
            return this.getPriceExpression() != null && this.getPriceExpression().hasData();
        }

        @Override
        public PriceScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PriceScheduleBuilder o = (PriceScheduleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPerUnitOf(), (RosettaModelObjectBuilder)o.getPerUnitOf(), this::setPerUnitOf);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPriceExpression(), (RosettaModelObjectBuilder)o.getPriceExpression(), this::setPriceExpression);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PriceSchedule _that = (PriceSchedule)this.getType().cast(o);
            if (!Objects.equals(this.perUnitOf, _that.getPerUnitOf())) {
                return false;
            }
            return Objects.equals(this.priceExpression, _that.getPriceExpression());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.perUnitOf != null ? this.perUnitOf.hashCode() : 0);
            _result = 31 * _result + (this.priceExpression != null ? this.priceExpression.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PriceScheduleBuilder {perUnitOf=" + this.perUnitOf + ", priceExpression=" + this.priceExpression + '}' + " " + super.toString();
        }
    }

    public static class PriceScheduleImpl
    extends MeasureSchedule.MeasureScheduleImpl
    implements PriceSchedule {
        private final UnitType perUnitOf;
        private final PriceExpression priceExpression;

        protected PriceScheduleImpl(PriceScheduleBuilder builder) {
            super(builder);
            this.perUnitOf = Optional.ofNullable(builder.getPerUnitOf()).map(f -> f.build()).orElse(null);
            this.priceExpression = Optional.ofNullable(builder.getPriceExpression()).map(f -> f.build()).orElse(null);
        }

        @Override
        public UnitType getPerUnitOf() {
            return this.perUnitOf;
        }

        @Override
        public PriceExpression getPriceExpression() {
            return this.priceExpression;
        }

        @Override
        public PriceSchedule build() {
            return this;
        }

        @Override
        public PriceScheduleBuilder toBuilder() {
            PriceScheduleBuilder builder = PriceSchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PriceScheduleBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPerUnitOf()).ifPresent(builder::setPerUnitOf);
            Optional.ofNullable(this.getPriceExpression()).ifPresent(builder::setPriceExpression);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PriceSchedule _that = (PriceSchedule)this.getType().cast(o);
            if (!Objects.equals(this.perUnitOf, _that.getPerUnitOf())) {
                return false;
            }
            return Objects.equals(this.priceExpression, _that.getPriceExpression());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.perUnitOf != null ? this.perUnitOf.hashCode() : 0);
            _result = 31 * _result + (this.priceExpression != null ? this.priceExpression.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PriceSchedule {perUnitOf=" + this.perUnitOf + ", priceExpression=" + this.priceExpression + '}' + " " + super.toString();
        }
    }

    public static interface PriceScheduleBuilder
    extends PriceSchedule,
    MeasureSchedule.MeasureScheduleBuilder,
    RosettaModelObjectBuilder {
        public UnitType.UnitTypeBuilder getOrCreatePerUnitOf();

        @Override
        public UnitType.UnitTypeBuilder getPerUnitOf();

        public PriceExpression.PriceExpressionBuilder getOrCreatePriceExpression();

        @Override
        public PriceExpression.PriceExpressionBuilder getPriceExpression();

        public PriceScheduleBuilder setPerUnitOf(UnitType var1);

        public PriceScheduleBuilder setPriceExpression(PriceExpression var1);

        @Override
        public PriceScheduleBuilder addDatedValue(DatedValue var1);

        @Override
        public PriceScheduleBuilder addDatedValue(DatedValue var1, int var2);

        @Override
        public PriceScheduleBuilder addDatedValue(List<? extends DatedValue> var1);

        @Override
        public PriceScheduleBuilder setDatedValue(List<? extends DatedValue> var1);

        @Override
        public PriceScheduleBuilder setUnit(UnitType var1);

        @Override
        public PriceScheduleBuilder setValue(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            MeasureSchedule.MeasureScheduleBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("perUnitOf"), processor, UnitType.UnitTypeBuilder.class, this.getPerUnitOf(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceExpression"), processor, PriceExpression.PriceExpressionBuilder.class, this.getPriceExpression(), new AttributeMeta[0]);
        }

        @Override
        public PriceScheduleBuilder prune();
    }
}

