/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.observable.asset.CapFloorEnum;
import cdm.observable.asset.CashPrice;
import cdm.observable.asset.CleanOrDirtyPriceEnum;
import cdm.observable.asset.GrossOrNetEnum;
import cdm.observable.asset.PriceExpressionEnum;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.SpreadTypeEnum;
import cdm.observable.asset.meta.PriceExpressionMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface PriceExpression
extends RosettaModelObject {
    public static final PriceExpressionMeta metaData = new PriceExpressionMeta();

    public PriceExpression build();

    public PriceExpressionBuilder toBuilder();

    public CapFloorEnum getCapFloor();

    public CashPrice getCashPrice();

    public CleanOrDirtyPriceEnum getCleanOrDirty();

    public GrossOrNetEnum getGrossOrNet();

    public PriceExpressionEnum getPriceExpression();

    public PriceTypeEnum getPriceType();

    public SpreadTypeEnum getSpreadType();

    default public RosettaMetaData<? extends PriceExpression> metaData() {
        return metaData;
    }

    public static PriceExpressionBuilder builder() {
        return new PriceExpressionBuilderImpl();
    }

    default public Class<? extends PriceExpression> getType() {
        return PriceExpression.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("capFloor"), CapFloorEnum.class, (Object)this.getCapFloor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleanOrDirty"), CleanOrDirtyPriceEnum.class, (Object)this.getCleanOrDirty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("grossOrNet"), GrossOrNetEnum.class, (Object)this.getGrossOrNet(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceExpression"), PriceExpressionEnum.class, (Object)this.getPriceExpression(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceType"), PriceTypeEnum.class, (Object)this.getPriceType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadType"), SpreadTypeEnum.class, (Object)this.getSpreadType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashPrice"), processor, CashPrice.class, this.getCashPrice(), new AttributeMeta[0]);
    }

    public static class PriceExpressionBuilderImpl
    implements PriceExpressionBuilder {
        protected CapFloorEnum capFloor;
        protected CashPrice.CashPriceBuilder cashPrice;
        protected CleanOrDirtyPriceEnum cleanOrDirty;
        protected GrossOrNetEnum grossOrNet;
        protected PriceExpressionEnum priceExpression;
        protected PriceTypeEnum priceType;
        protected SpreadTypeEnum spreadType;

        @Override
        public CapFloorEnum getCapFloor() {
            return this.capFloor;
        }

        @Override
        public CashPrice.CashPriceBuilder getCashPrice() {
            return this.cashPrice;
        }

        @Override
        public CashPrice.CashPriceBuilder getOrCreateCashPrice() {
            CashPrice.CashPriceBuilder result = this.cashPrice != null ? this.cashPrice : (this.cashPrice = CashPrice.builder());
            return result;
        }

        @Override
        public CleanOrDirtyPriceEnum getCleanOrDirty() {
            return this.cleanOrDirty;
        }

        @Override
        public GrossOrNetEnum getGrossOrNet() {
            return this.grossOrNet;
        }

        @Override
        public PriceExpressionEnum getPriceExpression() {
            return this.priceExpression;
        }

        @Override
        public PriceTypeEnum getPriceType() {
            return this.priceType;
        }

        @Override
        public SpreadTypeEnum getSpreadType() {
            return this.spreadType;
        }

        @Override
        public PriceExpressionBuilder setCapFloor(CapFloorEnum capFloor) {
            this.capFloor = capFloor == null ? null : capFloor;
            return this;
        }

        @Override
        public PriceExpressionBuilder setCashPrice(CashPrice cashPrice) {
            this.cashPrice = cashPrice == null ? null : cashPrice.toBuilder();
            return this;
        }

        @Override
        public PriceExpressionBuilder setCleanOrDirty(CleanOrDirtyPriceEnum cleanOrDirty) {
            this.cleanOrDirty = cleanOrDirty == null ? null : cleanOrDirty;
            return this;
        }

        @Override
        public PriceExpressionBuilder setGrossOrNet(GrossOrNetEnum grossOrNet) {
            this.grossOrNet = grossOrNet == null ? null : grossOrNet;
            return this;
        }

        @Override
        public PriceExpressionBuilder setPriceExpression(PriceExpressionEnum priceExpression) {
            this.priceExpression = priceExpression == null ? null : priceExpression;
            return this;
        }

        @Override
        public PriceExpressionBuilder setPriceType(PriceTypeEnum priceType) {
            this.priceType = priceType == null ? null : priceType;
            return this;
        }

        @Override
        public PriceExpressionBuilder setSpreadType(SpreadTypeEnum spreadType) {
            this.spreadType = spreadType == null ? null : spreadType;
            return this;
        }

        @Override
        public PriceExpression build() {
            return new PriceExpressionImpl(this);
        }

        @Override
        public PriceExpressionBuilder toBuilder() {
            return this;
        }

        @Override
        public PriceExpressionBuilder prune() {
            if (this.cashPrice != null && !this.cashPrice.prune().hasData()) {
                this.cashPrice = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCapFloor() != null) {
                return true;
            }
            if (this.getCashPrice() != null && this.getCashPrice().hasData()) {
                return true;
            }
            if (this.getCleanOrDirty() != null) {
                return true;
            }
            if (this.getGrossOrNet() != null) {
                return true;
            }
            if (this.getPriceExpression() != null) {
                return true;
            }
            if (this.getPriceType() != null) {
                return true;
            }
            return this.getSpreadType() != null;
        }

        public PriceExpressionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PriceExpressionBuilder o = (PriceExpressionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashPrice(), (RosettaModelObjectBuilder)o.getCashPrice(), this::setCashPrice);
            merger.mergeBasic((Object)this.getCapFloor(), (Object)o.getCapFloor(), this::setCapFloor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCleanOrDirty(), (Object)o.getCleanOrDirty(), this::setCleanOrDirty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getGrossOrNet(), (Object)o.getGrossOrNet(), this::setGrossOrNet, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceExpression(), (Object)o.getPriceExpression(), this::setPriceExpression, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceType(), (Object)o.getPriceType(), this::setPriceType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadType(), (Object)o.getSpreadType(), this::setSpreadType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PriceExpression _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.capFloor, (Object)_that.getCapFloor())) {
                return false;
            }
            if (!Objects.equals(this.cashPrice, _that.getCashPrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.cleanOrDirty, (Object)_that.getCleanOrDirty())) {
                return false;
            }
            if (!Objects.equals((Object)this.grossOrNet, (Object)_that.getGrossOrNet())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceExpression, (Object)_that.getPriceExpression())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceType, (Object)_that.getPriceType())) {
                return false;
            }
            return Objects.equals((Object)this.spreadType, (Object)_that.getSpreadType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.capFloor != null ? ((Object)((Object)this.capFloor)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cashPrice != null ? this.cashPrice.hashCode() : 0);
            _result = 31 * _result + (this.cleanOrDirty != null ? ((Object)((Object)this.cleanOrDirty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.grossOrNet != null ? ((Object)((Object)this.grossOrNet)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceExpression != null ? ((Object)((Object)this.priceExpression)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceType != null ? ((Object)((Object)this.priceType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.spreadType != null ? ((Object)((Object)this.spreadType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PriceExpressionBuilder {capFloor=" + (Object)((Object)this.capFloor) + ", cashPrice=" + this.cashPrice + ", cleanOrDirty=" + (Object)((Object)this.cleanOrDirty) + ", grossOrNet=" + (Object)((Object)this.grossOrNet) + ", priceExpression=" + (Object)((Object)this.priceExpression) + ", priceType=" + (Object)((Object)this.priceType) + ", spreadType=" + (Object)((Object)this.spreadType) + '}';
        }
    }

    public static class PriceExpressionImpl
    implements PriceExpression {
        private final CapFloorEnum capFloor;
        private final CashPrice cashPrice;
        private final CleanOrDirtyPriceEnum cleanOrDirty;
        private final GrossOrNetEnum grossOrNet;
        private final PriceExpressionEnum priceExpression;
        private final PriceTypeEnum priceType;
        private final SpreadTypeEnum spreadType;

        protected PriceExpressionImpl(PriceExpressionBuilder builder) {
            this.capFloor = builder.getCapFloor();
            this.cashPrice = Optional.ofNullable(builder.getCashPrice()).map(f -> f.build()).orElse(null);
            this.cleanOrDirty = builder.getCleanOrDirty();
            this.grossOrNet = builder.getGrossOrNet();
            this.priceExpression = builder.getPriceExpression();
            this.priceType = builder.getPriceType();
            this.spreadType = builder.getSpreadType();
        }

        @Override
        public CapFloorEnum getCapFloor() {
            return this.capFloor;
        }

        @Override
        public CashPrice getCashPrice() {
            return this.cashPrice;
        }

        @Override
        public CleanOrDirtyPriceEnum getCleanOrDirty() {
            return this.cleanOrDirty;
        }

        @Override
        public GrossOrNetEnum getGrossOrNet() {
            return this.grossOrNet;
        }

        @Override
        public PriceExpressionEnum getPriceExpression() {
            return this.priceExpression;
        }

        @Override
        public PriceTypeEnum getPriceType() {
            return this.priceType;
        }

        @Override
        public SpreadTypeEnum getSpreadType() {
            return this.spreadType;
        }

        @Override
        public PriceExpression build() {
            return this;
        }

        @Override
        public PriceExpressionBuilder toBuilder() {
            PriceExpressionBuilder builder = PriceExpression.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PriceExpressionBuilder builder) {
            Optional.ofNullable(this.getCapFloor()).ifPresent(builder::setCapFloor);
            Optional.ofNullable(this.getCashPrice()).ifPresent(builder::setCashPrice);
            Optional.ofNullable(this.getCleanOrDirty()).ifPresent(builder::setCleanOrDirty);
            Optional.ofNullable(this.getGrossOrNet()).ifPresent(builder::setGrossOrNet);
            Optional.ofNullable(this.getPriceExpression()).ifPresent(builder::setPriceExpression);
            Optional.ofNullable(this.getPriceType()).ifPresent(builder::setPriceType);
            Optional.ofNullable(this.getSpreadType()).ifPresent(builder::setSpreadType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PriceExpression _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.capFloor, (Object)_that.getCapFloor())) {
                return false;
            }
            if (!Objects.equals(this.cashPrice, _that.getCashPrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.cleanOrDirty, (Object)_that.getCleanOrDirty())) {
                return false;
            }
            if (!Objects.equals((Object)this.grossOrNet, (Object)_that.getGrossOrNet())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceExpression, (Object)_that.getPriceExpression())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceType, (Object)_that.getPriceType())) {
                return false;
            }
            return Objects.equals((Object)this.spreadType, (Object)_that.getSpreadType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.capFloor != null ? ((Object)((Object)this.capFloor)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cashPrice != null ? this.cashPrice.hashCode() : 0);
            _result = 31 * _result + (this.cleanOrDirty != null ? ((Object)((Object)this.cleanOrDirty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.grossOrNet != null ? ((Object)((Object)this.grossOrNet)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceExpression != null ? ((Object)((Object)this.priceExpression)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceType != null ? ((Object)((Object)this.priceType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.spreadType != null ? ((Object)((Object)this.spreadType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PriceExpression {capFloor=" + (Object)((Object)this.capFloor) + ", cashPrice=" + this.cashPrice + ", cleanOrDirty=" + (Object)((Object)this.cleanOrDirty) + ", grossOrNet=" + (Object)((Object)this.grossOrNet) + ", priceExpression=" + (Object)((Object)this.priceExpression) + ", priceType=" + (Object)((Object)this.priceType) + ", spreadType=" + (Object)((Object)this.spreadType) + '}';
        }
    }

    public static interface PriceExpressionBuilder
    extends PriceExpression,
    RosettaModelObjectBuilder {
        public CashPrice.CashPriceBuilder getOrCreateCashPrice();

        @Override
        public CashPrice.CashPriceBuilder getCashPrice();

        public PriceExpressionBuilder setCapFloor(CapFloorEnum var1);

        public PriceExpressionBuilder setCashPrice(CashPrice var1);

        public PriceExpressionBuilder setCleanOrDirty(CleanOrDirtyPriceEnum var1);

        public PriceExpressionBuilder setGrossOrNet(GrossOrNetEnum var1);

        public PriceExpressionBuilder setPriceExpression(PriceExpressionEnum var1);

        public PriceExpressionBuilder setPriceType(PriceTypeEnum var1);

        public PriceExpressionBuilder setSpreadType(SpreadTypeEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("capFloor"), CapFloorEnum.class, (Object)this.getCapFloor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleanOrDirty"), CleanOrDirtyPriceEnum.class, (Object)this.getCleanOrDirty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("grossOrNet"), GrossOrNetEnum.class, (Object)this.getGrossOrNet(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceExpression"), PriceExpressionEnum.class, (Object)this.getPriceExpression(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceType"), PriceTypeEnum.class, (Object)this.getPriceType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadType"), SpreadTypeEnum.class, (Object)this.getSpreadType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashPrice"), processor, CashPrice.CashPriceBuilder.class, this.getCashPrice(), new AttributeMeta[0]);
        }

        public PriceExpressionBuilder prune();
    }
}

