/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.observable.asset.Curve;
import cdm.observable.asset.InformationSource;
import cdm.observable.asset.meta.ObservationSourceMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface ObservationSource
extends RosettaModelObject {
    public static final ObservationSourceMeta metaData = new ObservationSourceMeta();

    public ObservationSource build();

    public ObservationSourceBuilder toBuilder();

    public Curve getCurve();

    public InformationSource getInformationSource();

    default public RosettaMetaData<? extends ObservationSource> metaData() {
        return metaData;
    }

    public static ObservationSourceBuilder builder() {
        return new ObservationSourceBuilderImpl();
    }

    default public Class<? extends ObservationSource> getType() {
        return ObservationSource.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("curve"), processor, Curve.class, this.getCurve(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.class, this.getInformationSource(), new AttributeMeta[0]);
    }

    public static class ObservationSourceBuilderImpl
    implements ObservationSourceBuilder {
        protected Curve.CurveBuilder curve;
        protected InformationSource.InformationSourceBuilder informationSource;

        @Override
        public Curve.CurveBuilder getCurve() {
            return this.curve;
        }

        @Override
        public Curve.CurveBuilder getOrCreateCurve() {
            Curve.CurveBuilder result = this.curve != null ? this.curve : (this.curve = Curve.builder());
            return result;
        }

        @Override
        public InformationSource.InformationSourceBuilder getInformationSource() {
            return this.informationSource;
        }

        @Override
        public InformationSource.InformationSourceBuilder getOrCreateInformationSource() {
            InformationSource.InformationSourceBuilder result = this.informationSource != null ? this.informationSource : (this.informationSource = InformationSource.builder());
            return result;
        }

        @Override
        public ObservationSourceBuilder setCurve(Curve curve) {
            this.curve = curve == null ? null : curve.toBuilder();
            return this;
        }

        @Override
        public ObservationSourceBuilder setInformationSource(InformationSource informationSource) {
            this.informationSource = informationSource == null ? null : informationSource.toBuilder();
            return this;
        }

        @Override
        public ObservationSource build() {
            return new ObservationSourceImpl(this);
        }

        @Override
        public ObservationSourceBuilder toBuilder() {
            return this;
        }

        @Override
        public ObservationSourceBuilder prune() {
            if (this.curve != null && !this.curve.prune().hasData()) {
                this.curve = null;
            }
            if (this.informationSource != null && !this.informationSource.prune().hasData()) {
                this.informationSource = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCurve() != null && this.getCurve().hasData()) {
                return true;
            }
            return this.getInformationSource() != null && this.getInformationSource().hasData();
        }

        public ObservationSourceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ObservationSourceBuilder o = (ObservationSourceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurve(), (RosettaModelObjectBuilder)o.getCurve(), this::setCurve);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInformationSource(), (RosettaModelObjectBuilder)o.getInformationSource(), this::setInformationSource);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationSource _that = this.getType().cast(o);
            if (!Objects.equals(this.curve, _that.getCurve())) {
                return false;
            }
            return Objects.equals(this.informationSource, _that.getInformationSource());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.curve != null ? this.curve.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationSourceBuilder {curve=" + this.curve + ", informationSource=" + this.informationSource + '}';
        }
    }

    public static class ObservationSourceImpl
    implements ObservationSource {
        private final Curve curve;
        private final InformationSource informationSource;

        protected ObservationSourceImpl(ObservationSourceBuilder builder) {
            this.curve = Optional.ofNullable(builder.getCurve()).map(f -> f.build()).orElse(null);
            this.informationSource = Optional.ofNullable(builder.getInformationSource()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Curve getCurve() {
            return this.curve;
        }

        @Override
        public InformationSource getInformationSource() {
            return this.informationSource;
        }

        @Override
        public ObservationSource build() {
            return this;
        }

        @Override
        public ObservationSourceBuilder toBuilder() {
            ObservationSourceBuilder builder = ObservationSource.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObservationSourceBuilder builder) {
            Optional.ofNullable(this.getCurve()).ifPresent(builder::setCurve);
            Optional.ofNullable(this.getInformationSource()).ifPresent(builder::setInformationSource);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationSource _that = this.getType().cast(o);
            if (!Objects.equals(this.curve, _that.getCurve())) {
                return false;
            }
            return Objects.equals(this.informationSource, _that.getInformationSource());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.curve != null ? this.curve.hashCode() : 0);
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationSource {curve=" + this.curve + ", informationSource=" + this.informationSource + '}';
        }
    }

    public static interface ObservationSourceBuilder
    extends ObservationSource,
    RosettaModelObjectBuilder {
        public Curve.CurveBuilder getOrCreateCurve();

        @Override
        public Curve.CurveBuilder getCurve();

        public InformationSource.InformationSourceBuilder getOrCreateInformationSource();

        @Override
        public InformationSource.InformationSourceBuilder getInformationSource();

        public ObservationSourceBuilder setCurve(Curve var1);

        public ObservationSourceBuilder setInformationSource(InformationSource var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("curve"), processor, Curve.CurveBuilder.class, this.getCurve(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.InformationSourceBuilder.class, this.getInformationSource(), new AttributeMeta[0]);
        }

        public ObservationSourceBuilder prune();
    }
}

