/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.math.QuantifierEnum;
import cdm.observable.asset.CreditNotation;
import cdm.observable.asset.CreditNotationMismatchResolutionEnum;
import cdm.observable.asset.CreditRatingAgencyEnum;
import cdm.observable.asset.meta.MultipleCreditNotationsMeta;
import cdm.observable.asset.metafields.FieldWithMetaCreditNotation;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface MultipleCreditNotations
extends RosettaModelObject {
    public static final MultipleCreditNotationsMeta metaData = new MultipleCreditNotationsMeta();

    public MultipleCreditNotations build();

    public MultipleCreditNotationsBuilder toBuilder();

    public QuantifierEnum getCondition();

    public List<? extends FieldWithMetaCreditNotation> getCreditNotation();

    public CreditNotationMismatchResolutionEnum getMismatchResolution();

    public CreditRatingAgencyEnum getReferenceAgency();

    default public RosettaMetaData<? extends MultipleCreditNotations> metaData() {
        return metaData;
    }

    public static MultipleCreditNotationsBuilder builder() {
        return new MultipleCreditNotationsBuilderImpl();
    }

    default public Class<? extends MultipleCreditNotations> getType() {
        return MultipleCreditNotations.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("condition"), QuantifierEnum.class, (Object)this.getCondition(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("mismatchResolution"), CreditNotationMismatchResolutionEnum.class, (Object)this.getMismatchResolution(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("referenceAgency"), CreditRatingAgencyEnum.class, (Object)this.getReferenceAgency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditNotation"), processor, FieldWithMetaCreditNotation.class, this.getCreditNotation(), new AttributeMeta[0]);
    }

    public static class MultipleCreditNotationsBuilderImpl
    implements MultipleCreditNotationsBuilder {
        protected QuantifierEnum condition;
        protected List<FieldWithMetaCreditNotation.FieldWithMetaCreditNotationBuilder> creditNotation = new ArrayList<FieldWithMetaCreditNotation.FieldWithMetaCreditNotationBuilder>();
        protected CreditNotationMismatchResolutionEnum mismatchResolution;
        protected CreditRatingAgencyEnum referenceAgency;

        @Override
        public QuantifierEnum getCondition() {
            return this.condition;
        }

        @Override
        public List<? extends FieldWithMetaCreditNotation.FieldWithMetaCreditNotationBuilder> getCreditNotation() {
            return this.creditNotation;
        }

        @Override
        public FieldWithMetaCreditNotation.FieldWithMetaCreditNotationBuilder getOrCreateCreditNotation(int _index) {
            if (this.creditNotation == null) {
                this.creditNotation = new ArrayList<FieldWithMetaCreditNotation.FieldWithMetaCreditNotationBuilder>();
            }
            return (FieldWithMetaCreditNotation.FieldWithMetaCreditNotationBuilder)this.getIndex(this.creditNotation, _index, () -> {
                FieldWithMetaCreditNotation.FieldWithMetaCreditNotationBuilder newCreditNotation = FieldWithMetaCreditNotation.builder();
                return newCreditNotation;
            });
        }

        @Override
        public CreditNotationMismatchResolutionEnum getMismatchResolution() {
            return this.mismatchResolution;
        }

        @Override
        public CreditRatingAgencyEnum getReferenceAgency() {
            return this.referenceAgency;
        }

        @Override
        public MultipleCreditNotationsBuilder setCondition(QuantifierEnum condition) {
            this.condition = condition == null ? null : condition;
            return this;
        }

        @Override
        public MultipleCreditNotationsBuilder addCreditNotation(FieldWithMetaCreditNotation creditNotation) {
            if (creditNotation != null) {
                this.creditNotation.add(creditNotation.toBuilder());
            }
            return this;
        }

        @Override
        public MultipleCreditNotationsBuilder addCreditNotation(FieldWithMetaCreditNotation creditNotation, int _idx) {
            this.getIndex(this.creditNotation, _idx, () -> creditNotation.toBuilder());
            return this;
        }

        @Override
        public MultipleCreditNotationsBuilder addCreditNotationValue(CreditNotation creditNotation) {
            this.getOrCreateCreditNotation(-1).setValue(creditNotation.toBuilder());
            return this;
        }

        @Override
        public MultipleCreditNotationsBuilder addCreditNotationValue(CreditNotation creditNotation, int _idx) {
            this.getOrCreateCreditNotation(_idx).setValue(creditNotation.toBuilder());
            return this;
        }

        @Override
        public MultipleCreditNotationsBuilder addCreditNotation(List<? extends FieldWithMetaCreditNotation> creditNotations) {
            if (creditNotations != null) {
                for (FieldWithMetaCreditNotation fieldWithMetaCreditNotation : creditNotations) {
                    this.creditNotation.add(fieldWithMetaCreditNotation.toBuilder());
                }
            }
            return this;
        }

        @Override
        public MultipleCreditNotationsBuilder setCreditNotation(List<? extends FieldWithMetaCreditNotation> creditNotations) {
            this.creditNotation = creditNotations == null ? new ArrayList<FieldWithMetaCreditNotation.FieldWithMetaCreditNotationBuilder>() : (List)creditNotations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MultipleCreditNotationsBuilder addCreditNotationValue(List<? extends CreditNotation> creditNotations) {
            if (creditNotations != null) {
                for (CreditNotation creditNotation : creditNotations) {
                    this.addCreditNotationValue(creditNotation);
                }
            }
            return this;
        }

        @Override
        public MultipleCreditNotationsBuilder setCreditNotationValue(List<? extends CreditNotation> creditNotations) {
            this.creditNotation.clear();
            if (creditNotations != null) {
                creditNotations.forEach(this::addCreditNotationValue);
            }
            return this;
        }

        @Override
        public MultipleCreditNotationsBuilder setMismatchResolution(CreditNotationMismatchResolutionEnum mismatchResolution) {
            this.mismatchResolution = mismatchResolution == null ? null : mismatchResolution;
            return this;
        }

        @Override
        public MultipleCreditNotationsBuilder setReferenceAgency(CreditRatingAgencyEnum referenceAgency) {
            this.referenceAgency = referenceAgency == null ? null : referenceAgency;
            return this;
        }

        @Override
        public MultipleCreditNotations build() {
            return new MultipleCreditNotationsImpl(this);
        }

        @Override
        public MultipleCreditNotationsBuilder toBuilder() {
            return this;
        }

        @Override
        public MultipleCreditNotationsBuilder prune() {
            this.creditNotation = this.creditNotation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCondition() != null) {
                return true;
            }
            if (this.getCreditNotation() != null && this.getCreditNotation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getMismatchResolution() != null) {
                return true;
            }
            return this.getReferenceAgency() != null;
        }

        public MultipleCreditNotationsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MultipleCreditNotationsBuilder o = (MultipleCreditNotationsBuilder)other;
            merger.mergeRosetta(this.getCreditNotation(), o.getCreditNotation(), this::getOrCreateCreditNotation);
            merger.mergeBasic((Object)this.getCondition(), (Object)o.getCondition(), this::setCondition, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMismatchResolution(), (Object)o.getMismatchResolution(), this::setMismatchResolution, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReferenceAgency(), (Object)o.getReferenceAgency(), this::setReferenceAgency, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MultipleCreditNotations _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.condition, (Object)_that.getCondition())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditNotation, _that.getCreditNotation())) {
                return false;
            }
            if (!Objects.equals((Object)this.mismatchResolution, (Object)_that.getMismatchResolution())) {
                return false;
            }
            return Objects.equals((Object)this.referenceAgency, (Object)_that.getReferenceAgency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.condition != null ? ((Object)((Object)this.condition)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.creditNotation != null ? this.creditNotation.hashCode() : 0);
            _result = 31 * _result + (this.mismatchResolution != null ? ((Object)((Object)this.mismatchResolution)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.referenceAgency != null ? ((Object)((Object)this.referenceAgency)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MultipleCreditNotationsBuilder {condition=" + (Object)((Object)this.condition) + ", creditNotation=" + this.creditNotation + ", mismatchResolution=" + (Object)((Object)this.mismatchResolution) + ", referenceAgency=" + (Object)((Object)this.referenceAgency) + '}';
        }
    }

    public static class MultipleCreditNotationsImpl
    implements MultipleCreditNotations {
        private final QuantifierEnum condition;
        private final List<? extends FieldWithMetaCreditNotation> creditNotation;
        private final CreditNotationMismatchResolutionEnum mismatchResolution;
        private final CreditRatingAgencyEnum referenceAgency;

        protected MultipleCreditNotationsImpl(MultipleCreditNotationsBuilder builder) {
            this.condition = builder.getCondition();
            this.creditNotation = Optional.ofNullable(builder.getCreditNotation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.mismatchResolution = builder.getMismatchResolution();
            this.referenceAgency = builder.getReferenceAgency();
        }

        @Override
        public QuantifierEnum getCondition() {
            return this.condition;
        }

        @Override
        public List<? extends FieldWithMetaCreditNotation> getCreditNotation() {
            return this.creditNotation;
        }

        @Override
        public CreditNotationMismatchResolutionEnum getMismatchResolution() {
            return this.mismatchResolution;
        }

        @Override
        public CreditRatingAgencyEnum getReferenceAgency() {
            return this.referenceAgency;
        }

        @Override
        public MultipleCreditNotations build() {
            return this;
        }

        @Override
        public MultipleCreditNotationsBuilder toBuilder() {
            MultipleCreditNotationsBuilder builder = MultipleCreditNotations.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MultipleCreditNotationsBuilder builder) {
            Optional.ofNullable(this.getCondition()).ifPresent(builder::setCondition);
            Optional.ofNullable(this.getCreditNotation()).ifPresent(builder::setCreditNotation);
            Optional.ofNullable(this.getMismatchResolution()).ifPresent(builder::setMismatchResolution);
            Optional.ofNullable(this.getReferenceAgency()).ifPresent(builder::setReferenceAgency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MultipleCreditNotations _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.condition, (Object)_that.getCondition())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditNotation, _that.getCreditNotation())) {
                return false;
            }
            if (!Objects.equals((Object)this.mismatchResolution, (Object)_that.getMismatchResolution())) {
                return false;
            }
            return Objects.equals((Object)this.referenceAgency, (Object)_that.getReferenceAgency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.condition != null ? ((Object)((Object)this.condition)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.creditNotation != null ? this.creditNotation.hashCode() : 0);
            _result = 31 * _result + (this.mismatchResolution != null ? ((Object)((Object)this.mismatchResolution)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.referenceAgency != null ? ((Object)((Object)this.referenceAgency)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MultipleCreditNotations {condition=" + (Object)((Object)this.condition) + ", creditNotation=" + this.creditNotation + ", mismatchResolution=" + (Object)((Object)this.mismatchResolution) + ", referenceAgency=" + (Object)((Object)this.referenceAgency) + '}';
        }
    }

    public static interface MultipleCreditNotationsBuilder
    extends MultipleCreditNotations,
    RosettaModelObjectBuilder {
        public FieldWithMetaCreditNotation.FieldWithMetaCreditNotationBuilder getOrCreateCreditNotation(int var1);

        public List<? extends FieldWithMetaCreditNotation.FieldWithMetaCreditNotationBuilder> getCreditNotation();

        public MultipleCreditNotationsBuilder setCondition(QuantifierEnum var1);

        public MultipleCreditNotationsBuilder addCreditNotation(FieldWithMetaCreditNotation var1);

        public MultipleCreditNotationsBuilder addCreditNotation(FieldWithMetaCreditNotation var1, int var2);

        public MultipleCreditNotationsBuilder addCreditNotationValue(CreditNotation var1);

        public MultipleCreditNotationsBuilder addCreditNotationValue(CreditNotation var1, int var2);

        public MultipleCreditNotationsBuilder addCreditNotation(List<? extends FieldWithMetaCreditNotation> var1);

        public MultipleCreditNotationsBuilder setCreditNotation(List<? extends FieldWithMetaCreditNotation> var1);

        public MultipleCreditNotationsBuilder addCreditNotationValue(List<? extends CreditNotation> var1);

        public MultipleCreditNotationsBuilder setCreditNotationValue(List<? extends CreditNotation> var1);

        public MultipleCreditNotationsBuilder setMismatchResolution(CreditNotationMismatchResolutionEnum var1);

        public MultipleCreditNotationsBuilder setReferenceAgency(CreditRatingAgencyEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("condition"), QuantifierEnum.class, (Object)this.getCondition(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("mismatchResolution"), CreditNotationMismatchResolutionEnum.class, (Object)this.getMismatchResolution(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("referenceAgency"), CreditRatingAgencyEnum.class, (Object)this.getReferenceAgency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditNotation"), processor, FieldWithMetaCreditNotation.FieldWithMetaCreditNotationBuilder.class, this.getCreditNotation(), new AttributeMeta[0]);
        }

        public MultipleCreditNotationsBuilder prune();
    }
}

