/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.datetime.Frequency;
import cdm.base.math.DatedValue;
import cdm.base.math.Measure;
import cdm.base.math.Quantity;
import cdm.base.math.UnitType;
import cdm.observable.asset.meta.MoneyMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface Money
extends Quantity,
GlobalKey {
    public static final MoneyMeta metaData = new MoneyMeta();

    @Override
    public Money build();

    @Override
    public MoneyBuilder toBuilder();

    public MetaFields getMeta();

    default public RosettaMetaData<? extends Money> metaData() {
        return metaData;
    }

    public static MoneyBuilder builder() {
        return new MoneyBuilderImpl();
    }

    default public Class<? extends Money> getType() {
        return Money.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        Quantity.super.process(path, processor);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
    }

    public static class MoneyBuilderImpl
    extends Quantity.QuantityBuilderImpl
    implements MoneyBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public MoneyBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public MoneyBuilder setFrequency(Frequency frequency) {
            this.frequency = frequency == null ? null : frequency.toBuilder();
            return this;
        }

        @Override
        public MoneyBuilder setMultiplier(Measure multiplier) {
            this.multiplier = multiplier == null ? null : multiplier.toBuilder();
            return this;
        }

        @Override
        public MoneyBuilder addDatedValue(DatedValue datedValue) {
            if (datedValue != null) {
                this.datedValue.add(datedValue.toBuilder());
            }
            return this;
        }

        @Override
        public MoneyBuilder addDatedValue(DatedValue datedValue, int _idx) {
            this.getIndex(this.datedValue, _idx, () -> datedValue.toBuilder());
            return this;
        }

        @Override
        public MoneyBuilder addDatedValue(List<? extends DatedValue> datedValues) {
            if (datedValues != null) {
                for (DatedValue datedValue : datedValues) {
                    this.datedValue.add(datedValue.toBuilder());
                }
            }
            return this;
        }

        @Override
        public MoneyBuilder setDatedValue(List<? extends DatedValue> datedValues) {
            this.datedValue = datedValues == null ? new ArrayList() : (List)datedValues.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MoneyBuilder setUnit(UnitType unit) {
            this.unit = unit == null ? null : unit.toBuilder();
            return this;
        }

        @Override
        public MoneyBuilder setValue(BigDecimal value) {
            this.value = value == null ? null : value;
            return this;
        }

        @Override
        public Money build() {
            return new MoneyImpl(this);
        }

        @Override
        public MoneyBuilder toBuilder() {
            return this;
        }

        @Override
        public MoneyBuilder prune() {
            super.prune();
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public MoneyBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MoneyBuilder o = (MoneyBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Money _that = (Money)this.getType().cast(o);
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MoneyBuilder {meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static class MoneyImpl
    extends Quantity.QuantityImpl
    implements Money {
        private final MetaFields meta;

        protected MoneyImpl(MoneyBuilder builder) {
            super(builder);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Money build() {
            return this;
        }

        @Override
        public MoneyBuilder toBuilder() {
            MoneyBuilder builder = Money.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MoneyBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Money _that = (Money)this.getType().cast(o);
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Money {meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static interface MoneyBuilder
    extends Money,
    Quantity.QuantityBuilder,
    RosettaModelObjectBuilder {
        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public MoneyBuilder setMeta(MetaFields var1);

        @Override
        public MoneyBuilder setFrequency(Frequency var1);

        @Override
        public MoneyBuilder setMultiplier(Measure var1);

        @Override
        public MoneyBuilder addDatedValue(DatedValue var1);

        @Override
        public MoneyBuilder addDatedValue(DatedValue var1, int var2);

        @Override
        public MoneyBuilder addDatedValue(List<? extends DatedValue> var1);

        @Override
        public MoneyBuilder setDatedValue(List<? extends DatedValue> var1);

        @Override
        public MoneyBuilder setUnit(UnitType var1);

        @Override
        public MoneyBuilder setValue(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            Quantity.QuantityBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
        }

        @Override
        public MoneyBuilder prune();
    }
}

