/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.datetime.Period;
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.observable.asset.InterpolationMethodEnum;
import cdm.observable.asset.QuotationSideEnum;
import cdm.observable.asset.SwapCurveValuation;
import cdm.observable.asset.meta.MakeWholeAmountMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface MakeWholeAmount
extends SwapCurveValuation {
    public static final MakeWholeAmountMeta metaData = new MakeWholeAmountMeta();

    @Override
    public MakeWholeAmount build();

    @Override
    public MakeWholeAmountBuilder toBuilder();

    public FieldWithMetaDate getEarlyCallDate();

    public InterpolationMethodEnum getInterpolationMethod();

    default public RosettaMetaData<? extends MakeWholeAmount> metaData() {
        return metaData;
    }

    public static MakeWholeAmountBuilder builder() {
        return new MakeWholeAmountBuilderImpl();
    }

    default public Class<? extends MakeWholeAmount> getType() {
        return MakeWholeAmount.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        SwapCurveValuation.super.process(path, processor);
        processor.processBasic(path.newSubPath("interpolationMethod"), InterpolationMethodEnum.class, (Object)this.getInterpolationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("earlyCallDate"), processor, FieldWithMetaDate.class, this.getEarlyCallDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
    }

    public static class MakeWholeAmountBuilderImpl
    extends SwapCurveValuation.SwapCurveValuationBuilderImpl
    implements MakeWholeAmountBuilder {
        protected FieldWithMetaDate.FieldWithMetaDateBuilder earlyCallDate;
        protected InterpolationMethodEnum interpolationMethod;

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getEarlyCallDate() {
            return this.earlyCallDate;
        }

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateEarlyCallDate() {
            FieldWithMetaDate.FieldWithMetaDateBuilder result = this.earlyCallDate != null ? this.earlyCallDate : (this.earlyCallDate = FieldWithMetaDate.builder());
            return result;
        }

        @Override
        public InterpolationMethodEnum getInterpolationMethod() {
            return this.interpolationMethod;
        }

        @Override
        public MakeWholeAmountBuilder setEarlyCallDate(FieldWithMetaDate earlyCallDate) {
            this.earlyCallDate = earlyCallDate == null ? null : earlyCallDate.toBuilder();
            return this;
        }

        @Override
        public MakeWholeAmountBuilder setEarlyCallDateValue(Date earlyCallDate) {
            this.getOrCreateEarlyCallDate().setValue(earlyCallDate);
            return this;
        }

        @Override
        public MakeWholeAmountBuilder setInterpolationMethod(InterpolationMethodEnum interpolationMethod) {
            this.interpolationMethod = interpolationMethod == null ? null : interpolationMethod;
            return this;
        }

        @Override
        public MakeWholeAmountBuilder setFloatingRateIndex(FloatingRateIndexEnum floatingRateIndex) {
            this.floatingRateIndex = floatingRateIndex == null ? null : floatingRateIndex;
            return this;
        }

        @Override
        public MakeWholeAmountBuilder setIndexTenor(Period indexTenor) {
            this.indexTenor = indexTenor == null ? null : indexTenor.toBuilder();
            return this;
        }

        @Override
        public MakeWholeAmountBuilder setSide(QuotationSideEnum side) {
            this.side = side == null ? null : side;
            return this;
        }

        @Override
        public MakeWholeAmountBuilder setSpread(BigDecimal spread) {
            this.spread = spread == null ? null : spread;
            return this;
        }

        @Override
        public MakeWholeAmount build() {
            return new MakeWholeAmountImpl(this);
        }

        @Override
        public MakeWholeAmountBuilder toBuilder() {
            return this;
        }

        @Override
        public MakeWholeAmountBuilder prune() {
            super.prune();
            if (this.earlyCallDate != null && !this.earlyCallDate.prune().hasData()) {
                this.earlyCallDate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getEarlyCallDate() != null) {
                return true;
            }
            return this.getInterpolationMethod() != null;
        }

        @Override
        public MakeWholeAmountBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MakeWholeAmountBuilder o = (MakeWholeAmountBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEarlyCallDate(), (RosettaModelObjectBuilder)o.getEarlyCallDate(), this::setEarlyCallDate);
            merger.mergeBasic((Object)this.getInterpolationMethod(), (Object)o.getInterpolationMethod(), this::setInterpolationMethod, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MakeWholeAmount _that = (MakeWholeAmount)this.getType().cast(o);
            if (!Objects.equals(this.earlyCallDate, _that.getEarlyCallDate())) {
                return false;
            }
            return Objects.equals((Object)this.interpolationMethod, (Object)_that.getInterpolationMethod());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.earlyCallDate != null ? this.earlyCallDate.hashCode() : 0);
            _result = 31 * _result + (this.interpolationMethod != null ? ((Object)((Object)this.interpolationMethod)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MakeWholeAmountBuilder {earlyCallDate=" + this.earlyCallDate + ", interpolationMethod=" + (Object)((Object)this.interpolationMethod) + '}' + " " + super.toString();
        }
    }

    public static class MakeWholeAmountImpl
    extends SwapCurveValuation.SwapCurveValuationImpl
    implements MakeWholeAmount {
        private final FieldWithMetaDate earlyCallDate;
        private final InterpolationMethodEnum interpolationMethod;

        protected MakeWholeAmountImpl(MakeWholeAmountBuilder builder) {
            super(builder);
            this.earlyCallDate = Optional.ofNullable(builder.getEarlyCallDate()).map(f -> f.build()).orElse(null);
            this.interpolationMethod = builder.getInterpolationMethod();
        }

        @Override
        public FieldWithMetaDate getEarlyCallDate() {
            return this.earlyCallDate;
        }

        @Override
        public InterpolationMethodEnum getInterpolationMethod() {
            return this.interpolationMethod;
        }

        @Override
        public MakeWholeAmount build() {
            return this;
        }

        @Override
        public MakeWholeAmountBuilder toBuilder() {
            MakeWholeAmountBuilder builder = MakeWholeAmount.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MakeWholeAmountBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getEarlyCallDate()).ifPresent(builder::setEarlyCallDate);
            Optional.ofNullable(this.getInterpolationMethod()).ifPresent(builder::setInterpolationMethod);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MakeWholeAmount _that = (MakeWholeAmount)this.getType().cast(o);
            if (!Objects.equals(this.earlyCallDate, _that.getEarlyCallDate())) {
                return false;
            }
            return Objects.equals((Object)this.interpolationMethod, (Object)_that.getInterpolationMethod());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.earlyCallDate != null ? this.earlyCallDate.hashCode() : 0);
            _result = 31 * _result + (this.interpolationMethod != null ? ((Object)((Object)this.interpolationMethod)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MakeWholeAmount {earlyCallDate=" + this.earlyCallDate + ", interpolationMethod=" + (Object)((Object)this.interpolationMethod) + '}' + " " + super.toString();
        }
    }

    public static interface MakeWholeAmountBuilder
    extends MakeWholeAmount,
    SwapCurveValuation.SwapCurveValuationBuilder,
    RosettaModelObjectBuilder {
        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateEarlyCallDate();

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getEarlyCallDate();

        public MakeWholeAmountBuilder setEarlyCallDate(FieldWithMetaDate var1);

        public MakeWholeAmountBuilder setEarlyCallDateValue(Date var1);

        public MakeWholeAmountBuilder setInterpolationMethod(InterpolationMethodEnum var1);

        @Override
        public MakeWholeAmountBuilder setFloatingRateIndex(FloatingRateIndexEnum var1);

        @Override
        public MakeWholeAmountBuilder setIndexTenor(Period var1);

        @Override
        public MakeWholeAmountBuilder setSide(QuotationSideEnum var1);

        @Override
        public MakeWholeAmountBuilder setSpread(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            SwapCurveValuation.SwapCurveValuationBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("interpolationMethod"), InterpolationMethodEnum.class, (Object)this.getInterpolationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("earlyCallDate"), processor, FieldWithMetaDate.FieldWithMetaDateBuilder.class, this.getEarlyCallDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
        }

        @Override
        public MakeWholeAmountBuilder prune();
    }
}

