/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.observable.asset.InformationProviderEnum;
import cdm.observable.asset.meta.InformationSourceMeta;
import cdm.observable.asset.metafields.FieldWithMetaInformationProviderEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface InformationSource
extends RosettaModelObject {
    public static final InformationSourceMeta metaData = new InformationSourceMeta();

    public InformationSource build();

    public InformationSourceBuilder toBuilder();

    public FieldWithMetaString getSourcePage();

    public String getSourcePageHeading();

    public FieldWithMetaInformationProviderEnum getSourceProvider();

    default public RosettaMetaData<? extends InformationSource> metaData() {
        return metaData;
    }

    public static InformationSourceBuilder builder() {
        return new InformationSourceBuilderImpl();
    }

    default public Class<? extends InformationSource> getType() {
        return InformationSource.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("sourcePageHeading"), String.class, (Object)this.getSourcePageHeading(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sourcePage"), processor, FieldWithMetaString.class, this.getSourcePage(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sourceProvider"), processor, FieldWithMetaInformationProviderEnum.class, this.getSourceProvider(), new AttributeMeta[0]);
    }

    public static class InformationSourceBuilderImpl
    implements InformationSourceBuilder {
        protected FieldWithMetaString.FieldWithMetaStringBuilder sourcePage;
        protected String sourcePageHeading;
        protected FieldWithMetaInformationProviderEnum.FieldWithMetaInformationProviderEnumBuilder sourceProvider;

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getSourcePage() {
            return this.sourcePage;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateSourcePage() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.sourcePage != null ? this.sourcePage : (this.sourcePage = FieldWithMetaString.builder());
            return result;
        }

        @Override
        public String getSourcePageHeading() {
            return this.sourcePageHeading;
        }

        @Override
        public FieldWithMetaInformationProviderEnum.FieldWithMetaInformationProviderEnumBuilder getSourceProvider() {
            return this.sourceProvider;
        }

        @Override
        public FieldWithMetaInformationProviderEnum.FieldWithMetaInformationProviderEnumBuilder getOrCreateSourceProvider() {
            FieldWithMetaInformationProviderEnum.FieldWithMetaInformationProviderEnumBuilder result = this.sourceProvider != null ? this.sourceProvider : (this.sourceProvider = FieldWithMetaInformationProviderEnum.builder());
            return result;
        }

        @Override
        public InformationSourceBuilder setSourcePage(FieldWithMetaString sourcePage) {
            this.sourcePage = sourcePage == null ? null : sourcePage.toBuilder();
            return this;
        }

        @Override
        public InformationSourceBuilder setSourcePageValue(String sourcePage) {
            this.getOrCreateSourcePage().setValue(sourcePage);
            return this;
        }

        @Override
        public InformationSourceBuilder setSourcePageHeading(String sourcePageHeading) {
            this.sourcePageHeading = sourcePageHeading == null ? null : sourcePageHeading;
            return this;
        }

        @Override
        public InformationSourceBuilder setSourceProvider(FieldWithMetaInformationProviderEnum sourceProvider) {
            this.sourceProvider = sourceProvider == null ? null : sourceProvider.toBuilder();
            return this;
        }

        @Override
        public InformationSourceBuilder setSourceProviderValue(InformationProviderEnum sourceProvider) {
            this.getOrCreateSourceProvider().setValue(sourceProvider);
            return this;
        }

        @Override
        public InformationSource build() {
            return new InformationSourceImpl(this);
        }

        @Override
        public InformationSourceBuilder toBuilder() {
            return this;
        }

        @Override
        public InformationSourceBuilder prune() {
            if (this.sourcePage != null && !this.sourcePage.prune().hasData()) {
                this.sourcePage = null;
            }
            if (this.sourceProvider != null && !this.sourceProvider.prune().hasData()) {
                this.sourceProvider = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getSourcePage() != null) {
                return true;
            }
            if (this.getSourcePageHeading() != null) {
                return true;
            }
            return this.getSourceProvider() != null;
        }

        public InformationSourceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            InformationSourceBuilder o = (InformationSourceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSourcePage(), (RosettaModelObjectBuilder)o.getSourcePage(), this::setSourcePage);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSourceProvider(), (RosettaModelObjectBuilder)o.getSourceProvider(), this::setSourceProvider);
            merger.mergeBasic((Object)this.getSourcePageHeading(), (Object)o.getSourcePageHeading(), this::setSourcePageHeading, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            InformationSource _that = this.getType().cast(o);
            if (!Objects.equals(this.sourcePage, _that.getSourcePage())) {
                return false;
            }
            if (!Objects.equals(this.sourcePageHeading, _that.getSourcePageHeading())) {
                return false;
            }
            return Objects.equals(this.sourceProvider, _that.getSourceProvider());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.sourcePage != null ? this.sourcePage.hashCode() : 0);
            _result = 31 * _result + (this.sourcePageHeading != null ? this.sourcePageHeading.hashCode() : 0);
            _result = 31 * _result + (this.sourceProvider != null ? this.sourceProvider.getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "InformationSourceBuilder {sourcePage=" + this.sourcePage + ", sourcePageHeading=" + this.sourcePageHeading + ", sourceProvider=" + this.sourceProvider + '}';
        }
    }

    public static class InformationSourceImpl
    implements InformationSource {
        private final FieldWithMetaString sourcePage;
        private final String sourcePageHeading;
        private final FieldWithMetaInformationProviderEnum sourceProvider;

        protected InformationSourceImpl(InformationSourceBuilder builder) {
            this.sourcePage = Optional.ofNullable(builder.getSourcePage()).map(f -> f.build()).orElse(null);
            this.sourcePageHeading = builder.getSourcePageHeading();
            this.sourceProvider = Optional.ofNullable(builder.getSourceProvider()).map(f -> f.build()).orElse(null);
        }

        @Override
        public FieldWithMetaString getSourcePage() {
            return this.sourcePage;
        }

        @Override
        public String getSourcePageHeading() {
            return this.sourcePageHeading;
        }

        @Override
        public FieldWithMetaInformationProviderEnum getSourceProvider() {
            return this.sourceProvider;
        }

        @Override
        public InformationSource build() {
            return this;
        }

        @Override
        public InformationSourceBuilder toBuilder() {
            InformationSourceBuilder builder = InformationSource.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InformationSourceBuilder builder) {
            Optional.ofNullable(this.getSourcePage()).ifPresent(builder::setSourcePage);
            Optional.ofNullable(this.getSourcePageHeading()).ifPresent(builder::setSourcePageHeading);
            Optional.ofNullable(this.getSourceProvider()).ifPresent(builder::setSourceProvider);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            InformationSource _that = this.getType().cast(o);
            if (!Objects.equals(this.sourcePage, _that.getSourcePage())) {
                return false;
            }
            if (!Objects.equals(this.sourcePageHeading, _that.getSourcePageHeading())) {
                return false;
            }
            return Objects.equals(this.sourceProvider, _that.getSourceProvider());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.sourcePage != null ? this.sourcePage.hashCode() : 0);
            _result = 31 * _result + (this.sourcePageHeading != null ? this.sourcePageHeading.hashCode() : 0);
            _result = 31 * _result + (this.sourceProvider != null ? this.sourceProvider.getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "InformationSource {sourcePage=" + this.sourcePage + ", sourcePageHeading=" + this.sourcePageHeading + ", sourceProvider=" + this.sourceProvider + '}';
        }
    }

    public static interface InformationSourceBuilder
    extends InformationSource,
    RosettaModelObjectBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateSourcePage();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getSourcePage();

        public FieldWithMetaInformationProviderEnum.FieldWithMetaInformationProviderEnumBuilder getOrCreateSourceProvider();

        @Override
        public FieldWithMetaInformationProviderEnum.FieldWithMetaInformationProviderEnumBuilder getSourceProvider();

        public InformationSourceBuilder setSourcePage(FieldWithMetaString var1);

        public InformationSourceBuilder setSourcePageValue(String var1);

        public InformationSourceBuilder setSourcePageHeading(String var1);

        public InformationSourceBuilder setSourceProvider(FieldWithMetaInformationProviderEnum var1);

        public InformationSourceBuilder setSourceProviderValue(InformationProviderEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("sourcePageHeading"), String.class, (Object)this.getSourcePageHeading(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sourcePage"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getSourcePage(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sourceProvider"), processor, FieldWithMetaInformationProviderEnum.FieldWithMetaInformationProviderEnumBuilder.class, this.getSourceProvider(), new AttributeMeta[0]);
        }

        public InformationSourceBuilder prune();
    }
}

