/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.datetime.AdjustableDate;
import cdm.observable.asset.FxSettlementRateSource;
import cdm.observable.asset.meta.FxRateSourceFixingMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface FxRateSourceFixing
extends RosettaModelObject {
    public static final FxRateSourceFixingMeta metaData = new FxRateSourceFixingMeta();

    public FxRateSourceFixing build();

    public FxRateSourceFixingBuilder toBuilder();

    public AdjustableDate getFixingDate();

    public FxSettlementRateSource getSettlementRateSource();

    default public RosettaMetaData<? extends FxRateSourceFixing> metaData() {
        return metaData;
    }

    public static FxRateSourceFixingBuilder builder() {
        return new FxRateSourceFixingBuilderImpl();
    }

    default public Class<? extends FxRateSourceFixing> getType() {
        return FxRateSourceFixing.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("fixingDate"), processor, AdjustableDate.class, this.getFixingDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementRateSource"), processor, FxSettlementRateSource.class, this.getSettlementRateSource(), new AttributeMeta[0]);
    }

    public static class FxRateSourceFixingBuilderImpl
    implements FxRateSourceFixingBuilder {
        protected AdjustableDate.AdjustableDateBuilder fixingDate;
        protected FxSettlementRateSource.FxSettlementRateSourceBuilder settlementRateSource;

        @Override
        public AdjustableDate.AdjustableDateBuilder getFixingDate() {
            return this.fixingDate;
        }

        @Override
        public AdjustableDate.AdjustableDateBuilder getOrCreateFixingDate() {
            AdjustableDate.AdjustableDateBuilder result = this.fixingDate != null ? this.fixingDate : (this.fixingDate = AdjustableDate.builder());
            return result;
        }

        @Override
        public FxSettlementRateSource.FxSettlementRateSourceBuilder getSettlementRateSource() {
            return this.settlementRateSource;
        }

        @Override
        public FxSettlementRateSource.FxSettlementRateSourceBuilder getOrCreateSettlementRateSource() {
            FxSettlementRateSource.FxSettlementRateSourceBuilder result = this.settlementRateSource != null ? this.settlementRateSource : (this.settlementRateSource = FxSettlementRateSource.builder());
            return result;
        }

        @Override
        public FxRateSourceFixingBuilder setFixingDate(AdjustableDate fixingDate) {
            this.fixingDate = fixingDate == null ? null : fixingDate.toBuilder();
            return this;
        }

        @Override
        public FxRateSourceFixingBuilder setSettlementRateSource(FxSettlementRateSource settlementRateSource) {
            this.settlementRateSource = settlementRateSource == null ? null : settlementRateSource.toBuilder();
            return this;
        }

        @Override
        public FxRateSourceFixing build() {
            return new FxRateSourceFixingImpl(this);
        }

        @Override
        public FxRateSourceFixingBuilder toBuilder() {
            return this;
        }

        @Override
        public FxRateSourceFixingBuilder prune() {
            if (this.fixingDate != null && !this.fixingDate.prune().hasData()) {
                this.fixingDate = null;
            }
            if (this.settlementRateSource != null && !this.settlementRateSource.prune().hasData()) {
                this.settlementRateSource = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFixingDate() != null && this.getFixingDate().hasData()) {
                return true;
            }
            return this.getSettlementRateSource() != null && this.getSettlementRateSource().hasData();
        }

        public FxRateSourceFixingBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxRateSourceFixingBuilder o = (FxRateSourceFixingBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixingDate(), (RosettaModelObjectBuilder)o.getFixingDate(), this::setFixingDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementRateSource(), (RosettaModelObjectBuilder)o.getSettlementRateSource(), this::setSettlementRateSource);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxRateSourceFixing _that = this.getType().cast(o);
            if (!Objects.equals(this.fixingDate, _that.getFixingDate())) {
                return false;
            }
            return Objects.equals(this.settlementRateSource, _that.getSettlementRateSource());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementRateSource != null ? this.settlementRateSource.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxRateSourceFixingBuilder {fixingDate=" + this.fixingDate + ", settlementRateSource=" + this.settlementRateSource + '}';
        }
    }

    public static class FxRateSourceFixingImpl
    implements FxRateSourceFixing {
        private final AdjustableDate fixingDate;
        private final FxSettlementRateSource settlementRateSource;

        protected FxRateSourceFixingImpl(FxRateSourceFixingBuilder builder) {
            this.fixingDate = Optional.ofNullable(builder.getFixingDate()).map(f -> f.build()).orElse(null);
            this.settlementRateSource = Optional.ofNullable(builder.getSettlementRateSource()).map(f -> f.build()).orElse(null);
        }

        @Override
        public AdjustableDate getFixingDate() {
            return this.fixingDate;
        }

        @Override
        public FxSettlementRateSource getSettlementRateSource() {
            return this.settlementRateSource;
        }

        @Override
        public FxRateSourceFixing build() {
            return this;
        }

        @Override
        public FxRateSourceFixingBuilder toBuilder() {
            FxRateSourceFixingBuilder builder = FxRateSourceFixing.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxRateSourceFixingBuilder builder) {
            Optional.ofNullable(this.getFixingDate()).ifPresent(builder::setFixingDate);
            Optional.ofNullable(this.getSettlementRateSource()).ifPresent(builder::setSettlementRateSource);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxRateSourceFixing _that = this.getType().cast(o);
            if (!Objects.equals(this.fixingDate, _that.getFixingDate())) {
                return false;
            }
            return Objects.equals(this.settlementRateSource, _that.getSettlementRateSource());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementRateSource != null ? this.settlementRateSource.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxRateSourceFixing {fixingDate=" + this.fixingDate + ", settlementRateSource=" + this.settlementRateSource + '}';
        }
    }

    public static interface FxRateSourceFixingBuilder
    extends FxRateSourceFixing,
    RosettaModelObjectBuilder {
        public AdjustableDate.AdjustableDateBuilder getOrCreateFixingDate();

        @Override
        public AdjustableDate.AdjustableDateBuilder getFixingDate();

        public FxSettlementRateSource.FxSettlementRateSourceBuilder getOrCreateSettlementRateSource();

        @Override
        public FxSettlementRateSource.FxSettlementRateSourceBuilder getSettlementRateSource();

        public FxRateSourceFixingBuilder setFixingDate(AdjustableDate var1);

        public FxRateSourceFixingBuilder setSettlementRateSource(FxSettlementRateSource var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("fixingDate"), processor, AdjustableDate.AdjustableDateBuilder.class, this.getFixingDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementRateSource"), processor, FxSettlementRateSource.FxSettlementRateSourceBuilder.class, this.getSettlementRateSource(), new AttributeMeta[0]);
        }

        public FxRateSourceFixingBuilder prune();
    }
}

