/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.observable.asset.QuoteBasisEnum;
import cdm.observable.asset.QuotedCurrencyPair;
import cdm.observable.asset.meta.CrossRateMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface CrossRate
extends QuotedCurrencyPair {
    public static final CrossRateMeta metaData = new CrossRateMeta();

    @Override
    public CrossRate build();

    @Override
    public CrossRateBuilder toBuilder();

    public BigDecimal getForwardPoints();

    public BigDecimal getRate();

    public BigDecimal getSpotRate();

    default public RosettaMetaData<? extends CrossRate> metaData() {
        return metaData;
    }

    public static CrossRateBuilder builder() {
        return new CrossRateBuilderImpl();
    }

    default public Class<? extends CrossRate> getType() {
        return CrossRate.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        QuotedCurrencyPair.super.process(path, processor);
        processor.processBasic(path.newSubPath("forwardPoints"), BigDecimal.class, (Object)this.getForwardPoints(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CrossRateBuilderImpl
    extends QuotedCurrencyPair.QuotedCurrencyPairBuilderImpl
    implements CrossRateBuilder {
        protected BigDecimal forwardPoints;
        protected BigDecimal rate;
        protected BigDecimal spotRate;

        @Override
        public BigDecimal getForwardPoints() {
            return this.forwardPoints;
        }

        @Override
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        public CrossRateBuilder setForwardPoints(BigDecimal forwardPoints) {
            this.forwardPoints = forwardPoints == null ? null : forwardPoints;
            return this;
        }

        @Override
        public CrossRateBuilder setRate(BigDecimal rate) {
            this.rate = rate == null ? null : rate;
            return this;
        }

        @Override
        public CrossRateBuilder setSpotRate(BigDecimal spotRate) {
            this.spotRate = spotRate == null ? null : spotRate;
            return this;
        }

        @Override
        public CrossRateBuilder setCurrency1(FieldWithMetaString currency1) {
            this.currency1 = currency1 == null ? null : currency1.toBuilder();
            return this;
        }

        @Override
        public CrossRateBuilder setCurrency1Value(String currency1) {
            this.getOrCreateCurrency1().setValue(currency1);
            return this;
        }

        @Override
        public CrossRateBuilder setCurrency2(FieldWithMetaString currency2) {
            this.currency2 = currency2 == null ? null : currency2.toBuilder();
            return this;
        }

        @Override
        public CrossRateBuilder setCurrency2Value(String currency2) {
            this.getOrCreateCurrency2().setValue(currency2);
            return this;
        }

        @Override
        public CrossRateBuilder setQuoteBasis(QuoteBasisEnum quoteBasis) {
            this.quoteBasis = quoteBasis == null ? null : quoteBasis;
            return this;
        }

        @Override
        public CrossRate build() {
            return new CrossRateImpl(this);
        }

        @Override
        public CrossRateBuilder toBuilder() {
            return this;
        }

        @Override
        public CrossRateBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getForwardPoints() != null) {
                return true;
            }
            if (this.getRate() != null) {
                return true;
            }
            return this.getSpotRate() != null;
        }

        @Override
        public CrossRateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CrossRateBuilder o = (CrossRateBuilder)other;
            merger.mergeBasic((Object)this.getForwardPoints(), (Object)o.getForwardPoints(), this::setForwardPoints, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRate(), (Object)o.getRate(), this::setRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpotRate(), (Object)o.getSpotRate(), this::setSpotRate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CrossRate _that = (CrossRate)this.getType().cast(o);
            if (!Objects.equals(this.forwardPoints, _that.getForwardPoints())) {
                return false;
            }
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            return Objects.equals(this.spotRate, _that.getSpotRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.forwardPoints != null ? this.forwardPoints.hashCode() : 0);
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CrossRateBuilder {forwardPoints=" + this.forwardPoints + ", rate=" + this.rate + ", spotRate=" + this.spotRate + '}' + " " + super.toString();
        }
    }

    public static class CrossRateImpl
    extends QuotedCurrencyPair.QuotedCurrencyPairImpl
    implements CrossRate {
        private final BigDecimal forwardPoints;
        private final BigDecimal rate;
        private final BigDecimal spotRate;

        protected CrossRateImpl(CrossRateBuilder builder) {
            super(builder);
            this.forwardPoints = builder.getForwardPoints();
            this.rate = builder.getRate();
            this.spotRate = builder.getSpotRate();
        }

        @Override
        public BigDecimal getForwardPoints() {
            return this.forwardPoints;
        }

        @Override
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        public CrossRate build() {
            return this;
        }

        @Override
        public CrossRateBuilder toBuilder() {
            CrossRateBuilder builder = CrossRate.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CrossRateBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getForwardPoints()).ifPresent(builder::setForwardPoints);
            Optional.ofNullable(this.getRate()).ifPresent(builder::setRate);
            Optional.ofNullable(this.getSpotRate()).ifPresent(builder::setSpotRate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CrossRate _that = (CrossRate)this.getType().cast(o);
            if (!Objects.equals(this.forwardPoints, _that.getForwardPoints())) {
                return false;
            }
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            return Objects.equals(this.spotRate, _that.getSpotRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.forwardPoints != null ? this.forwardPoints.hashCode() : 0);
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CrossRate {forwardPoints=" + this.forwardPoints + ", rate=" + this.rate + ", spotRate=" + this.spotRate + '}' + " " + super.toString();
        }
    }

    public static interface CrossRateBuilder
    extends CrossRate,
    QuotedCurrencyPair.QuotedCurrencyPairBuilder,
    RosettaModelObjectBuilder {
        public CrossRateBuilder setForwardPoints(BigDecimal var1);

        public CrossRateBuilder setRate(BigDecimal var1);

        public CrossRateBuilder setSpotRate(BigDecimal var1);

        @Override
        public CrossRateBuilder setCurrency1(FieldWithMetaString var1);

        @Override
        public CrossRateBuilder setCurrency1Value(String var1);

        @Override
        public CrossRateBuilder setCurrency2(FieldWithMetaString var1);

        @Override
        public CrossRateBuilder setCurrency2Value(String var1);

        @Override
        public CrossRateBuilder setQuoteBasis(QuoteBasisEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            QuotedCurrencyPair.QuotedCurrencyPairBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("forwardPoints"), BigDecimal.class, (Object)this.getForwardPoints(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CrossRateBuilder prune();
    }
}

