/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.observable.asset.CashPriceTypeEnum;
import cdm.observable.asset.FeeTypeEnum;
import cdm.observable.asset.PremiumExpression;
import cdm.observable.asset.meta.CashPriceMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface CashPrice
extends RosettaModelObject {
    public static final CashPriceMeta metaData = new CashPriceMeta();

    public CashPrice build();

    public CashPriceBuilder toBuilder();

    public CashPriceTypeEnum getCashPriceType();

    public FeeTypeEnum getFeeType();

    public PremiumExpression getPremiumExpression();

    default public RosettaMetaData<? extends CashPrice> metaData() {
        return metaData;
    }

    public static CashPriceBuilder builder() {
        return new CashPriceBuilderImpl();
    }

    default public Class<? extends CashPrice> getType() {
        return CashPrice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("cashPriceType"), CashPriceTypeEnum.class, (Object)this.getCashPriceType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("feeType"), FeeTypeEnum.class, (Object)this.getFeeType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premiumExpression"), processor, PremiumExpression.class, this.getPremiumExpression(), new AttributeMeta[0]);
    }

    public static class CashPriceBuilderImpl
    implements CashPriceBuilder {
        protected CashPriceTypeEnum cashPriceType;
        protected FeeTypeEnum feeType;
        protected PremiumExpression.PremiumExpressionBuilder premiumExpression;

        @Override
        public CashPriceTypeEnum getCashPriceType() {
            return this.cashPriceType;
        }

        @Override
        public FeeTypeEnum getFeeType() {
            return this.feeType;
        }

        @Override
        public PremiumExpression.PremiumExpressionBuilder getPremiumExpression() {
            return this.premiumExpression;
        }

        @Override
        public PremiumExpression.PremiumExpressionBuilder getOrCreatePremiumExpression() {
            PremiumExpression.PremiumExpressionBuilder result = this.premiumExpression != null ? this.premiumExpression : (this.premiumExpression = PremiumExpression.builder());
            return result;
        }

        @Override
        public CashPriceBuilder setCashPriceType(CashPriceTypeEnum cashPriceType) {
            this.cashPriceType = cashPriceType == null ? null : cashPriceType;
            return this;
        }

        @Override
        public CashPriceBuilder setFeeType(FeeTypeEnum feeType) {
            this.feeType = feeType == null ? null : feeType;
            return this;
        }

        @Override
        public CashPriceBuilder setPremiumExpression(PremiumExpression premiumExpression) {
            this.premiumExpression = premiumExpression == null ? null : premiumExpression.toBuilder();
            return this;
        }

        @Override
        public CashPrice build() {
            return new CashPriceImpl(this);
        }

        @Override
        public CashPriceBuilder toBuilder() {
            return this;
        }

        @Override
        public CashPriceBuilder prune() {
            if (this.premiumExpression != null && !this.premiumExpression.prune().hasData()) {
                this.premiumExpression = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCashPriceType() != null) {
                return true;
            }
            if (this.getFeeType() != null) {
                return true;
            }
            return this.getPremiumExpression() != null && this.getPremiumExpression().hasData();
        }

        public CashPriceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CashPriceBuilder o = (CashPriceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPremiumExpression(), (RosettaModelObjectBuilder)o.getPremiumExpression(), this::setPremiumExpression);
            merger.mergeBasic((Object)this.getCashPriceType(), (Object)o.getCashPriceType(), this::setCashPriceType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFeeType(), (Object)o.getFeeType(), this::setFeeType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashPrice _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.cashPriceType, (Object)_that.getCashPriceType())) {
                return false;
            }
            if (!Objects.equals((Object)this.feeType, (Object)_that.getFeeType())) {
                return false;
            }
            return Objects.equals(this.premiumExpression, _that.getPremiumExpression());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashPriceType != null ? ((Object)((Object)this.cashPriceType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.feeType != null ? ((Object)((Object)this.feeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.premiumExpression != null ? this.premiumExpression.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashPriceBuilder {cashPriceType=" + (Object)((Object)this.cashPriceType) + ", feeType=" + (Object)((Object)this.feeType) + ", premiumExpression=" + this.premiumExpression + '}';
        }
    }

    public static class CashPriceImpl
    implements CashPrice {
        private final CashPriceTypeEnum cashPriceType;
        private final FeeTypeEnum feeType;
        private final PremiumExpression premiumExpression;

        protected CashPriceImpl(CashPriceBuilder builder) {
            this.cashPriceType = builder.getCashPriceType();
            this.feeType = builder.getFeeType();
            this.premiumExpression = Optional.ofNullable(builder.getPremiumExpression()).map(f -> f.build()).orElse(null);
        }

        @Override
        public CashPriceTypeEnum getCashPriceType() {
            return this.cashPriceType;
        }

        @Override
        public FeeTypeEnum getFeeType() {
            return this.feeType;
        }

        @Override
        public PremiumExpression getPremiumExpression() {
            return this.premiumExpression;
        }

        @Override
        public CashPrice build() {
            return this;
        }

        @Override
        public CashPriceBuilder toBuilder() {
            CashPriceBuilder builder = CashPrice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CashPriceBuilder builder) {
            Optional.ofNullable(this.getCashPriceType()).ifPresent(builder::setCashPriceType);
            Optional.ofNullable(this.getFeeType()).ifPresent(builder::setFeeType);
            Optional.ofNullable(this.getPremiumExpression()).ifPresent(builder::setPremiumExpression);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashPrice _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.cashPriceType, (Object)_that.getCashPriceType())) {
                return false;
            }
            if (!Objects.equals((Object)this.feeType, (Object)_that.getFeeType())) {
                return false;
            }
            return Objects.equals(this.premiumExpression, _that.getPremiumExpression());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashPriceType != null ? ((Object)((Object)this.cashPriceType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.feeType != null ? ((Object)((Object)this.feeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.premiumExpression != null ? this.premiumExpression.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashPrice {cashPriceType=" + (Object)((Object)this.cashPriceType) + ", feeType=" + (Object)((Object)this.feeType) + ", premiumExpression=" + this.premiumExpression + '}';
        }
    }

    public static interface CashPriceBuilder
    extends CashPrice,
    RosettaModelObjectBuilder {
        public PremiumExpression.PremiumExpressionBuilder getOrCreatePremiumExpression();

        @Override
        public PremiumExpression.PremiumExpressionBuilder getPremiumExpression();

        public CashPriceBuilder setCashPriceType(CashPriceTypeEnum var1);

        public CashPriceBuilder setFeeType(FeeTypeEnum var1);

        public CashPriceBuilder setPremiumExpression(PremiumExpression var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("cashPriceType"), CashPriceTypeEnum.class, (Object)this.getCashPriceType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("feeType"), FeeTypeEnum.class, (Object)this.getFeeType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premiumExpression"), processor, PremiumExpression.PremiumExpressionBuilder.class, this.getPremiumExpression(), new AttributeMeta[0]);
        }

        public CashPriceBuilder prune();
    }
}

