/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.observable.asset.CleanOrDirtyPrice;
import cdm.observable.asset.RelativePrice;
import cdm.observable.asset.meta.BondPriceAndYieldModelMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface BondPriceAndYieldModel
extends RosettaModelObject {
    public static final BondPriceAndYieldModelMeta metaData = new BondPriceAndYieldModelMeta();

    public BondPriceAndYieldModel build();

    public BondPriceAndYieldModelBuilder toBuilder();

    public BigDecimal getAllInPrice();

    public CleanOrDirtyPrice getCleanOrDirtyPrice();

    public BigDecimal getInflationFactor();

    public RelativePrice getRelativePrice();

    public BigDecimal getYieldToMaturity();

    default public RosettaMetaData<? extends BondPriceAndYieldModel> metaData() {
        return metaData;
    }

    public static BondPriceAndYieldModelBuilder builder() {
        return new BondPriceAndYieldModelBuilderImpl();
    }

    default public Class<? extends BondPriceAndYieldModel> getType() {
        return BondPriceAndYieldModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("allInPrice"), BigDecimal.class, (Object)this.getAllInPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("inflationFactor"), BigDecimal.class, (Object)this.getInflationFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("yieldToMaturity"), BigDecimal.class, (Object)this.getYieldToMaturity(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cleanOrDirtyPrice"), processor, CleanOrDirtyPrice.class, this.getCleanOrDirtyPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relativePrice"), processor, RelativePrice.class, this.getRelativePrice(), new AttributeMeta[0]);
    }

    public static class BondPriceAndYieldModelBuilderImpl
    implements BondPriceAndYieldModelBuilder {
        protected BigDecimal allInPrice;
        protected CleanOrDirtyPrice.CleanOrDirtyPriceBuilder cleanOrDirtyPrice;
        protected BigDecimal inflationFactor;
        protected RelativePrice.RelativePriceBuilder relativePrice;
        protected BigDecimal yieldToMaturity;

        @Override
        public BigDecimal getAllInPrice() {
            return this.allInPrice;
        }

        @Override
        public CleanOrDirtyPrice.CleanOrDirtyPriceBuilder getCleanOrDirtyPrice() {
            return this.cleanOrDirtyPrice;
        }

        @Override
        public CleanOrDirtyPrice.CleanOrDirtyPriceBuilder getOrCreateCleanOrDirtyPrice() {
            CleanOrDirtyPrice.CleanOrDirtyPriceBuilder result = this.cleanOrDirtyPrice != null ? this.cleanOrDirtyPrice : (this.cleanOrDirtyPrice = CleanOrDirtyPrice.builder());
            return result;
        }

        @Override
        public BigDecimal getInflationFactor() {
            return this.inflationFactor;
        }

        @Override
        public RelativePrice.RelativePriceBuilder getRelativePrice() {
            return this.relativePrice;
        }

        @Override
        public RelativePrice.RelativePriceBuilder getOrCreateRelativePrice() {
            RelativePrice.RelativePriceBuilder result = this.relativePrice != null ? this.relativePrice : (this.relativePrice = RelativePrice.builder());
            return result;
        }

        @Override
        public BigDecimal getYieldToMaturity() {
            return this.yieldToMaturity;
        }

        @Override
        public BondPriceAndYieldModelBuilder setAllInPrice(BigDecimal allInPrice) {
            this.allInPrice = allInPrice == null ? null : allInPrice;
            return this;
        }

        @Override
        public BondPriceAndYieldModelBuilder setCleanOrDirtyPrice(CleanOrDirtyPrice cleanOrDirtyPrice) {
            this.cleanOrDirtyPrice = cleanOrDirtyPrice == null ? null : cleanOrDirtyPrice.toBuilder();
            return this;
        }

        @Override
        public BondPriceAndYieldModelBuilder setInflationFactor(BigDecimal inflationFactor) {
            this.inflationFactor = inflationFactor == null ? null : inflationFactor;
            return this;
        }

        @Override
        public BondPriceAndYieldModelBuilder setRelativePrice(RelativePrice relativePrice) {
            this.relativePrice = relativePrice == null ? null : relativePrice.toBuilder();
            return this;
        }

        @Override
        public BondPriceAndYieldModelBuilder setYieldToMaturity(BigDecimal yieldToMaturity) {
            this.yieldToMaturity = yieldToMaturity == null ? null : yieldToMaturity;
            return this;
        }

        @Override
        public BondPriceAndYieldModel build() {
            return new BondPriceAndYieldModelImpl(this);
        }

        @Override
        public BondPriceAndYieldModelBuilder toBuilder() {
            return this;
        }

        @Override
        public BondPriceAndYieldModelBuilder prune() {
            if (this.cleanOrDirtyPrice != null && !this.cleanOrDirtyPrice.prune().hasData()) {
                this.cleanOrDirtyPrice = null;
            }
            if (this.relativePrice != null && !this.relativePrice.prune().hasData()) {
                this.relativePrice = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAllInPrice() != null) {
                return true;
            }
            if (this.getCleanOrDirtyPrice() != null && this.getCleanOrDirtyPrice().hasData()) {
                return true;
            }
            if (this.getInflationFactor() != null) {
                return true;
            }
            if (this.getRelativePrice() != null && this.getRelativePrice().hasData()) {
                return true;
            }
            return this.getYieldToMaturity() != null;
        }

        public BondPriceAndYieldModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BondPriceAndYieldModelBuilder o = (BondPriceAndYieldModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCleanOrDirtyPrice(), (RosettaModelObjectBuilder)o.getCleanOrDirtyPrice(), this::setCleanOrDirtyPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRelativePrice(), (RosettaModelObjectBuilder)o.getRelativePrice(), this::setRelativePrice);
            merger.mergeBasic((Object)this.getAllInPrice(), (Object)o.getAllInPrice(), this::setAllInPrice, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInflationFactor(), (Object)o.getInflationFactor(), this::setInflationFactor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getYieldToMaturity(), (Object)o.getYieldToMaturity(), this::setYieldToMaturity, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BondPriceAndYieldModel _that = this.getType().cast(o);
            if (!Objects.equals(this.allInPrice, _that.getAllInPrice())) {
                return false;
            }
            if (!Objects.equals(this.cleanOrDirtyPrice, _that.getCleanOrDirtyPrice())) {
                return false;
            }
            if (!Objects.equals(this.inflationFactor, _that.getInflationFactor())) {
                return false;
            }
            if (!Objects.equals(this.relativePrice, _that.getRelativePrice())) {
                return false;
            }
            return Objects.equals(this.yieldToMaturity, _that.getYieldToMaturity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.allInPrice != null ? this.allInPrice.hashCode() : 0);
            _result = 31 * _result + (this.cleanOrDirtyPrice != null ? this.cleanOrDirtyPrice.hashCode() : 0);
            _result = 31 * _result + (this.inflationFactor != null ? this.inflationFactor.hashCode() : 0);
            _result = 31 * _result + (this.relativePrice != null ? this.relativePrice.hashCode() : 0);
            _result = 31 * _result + (this.yieldToMaturity != null ? this.yieldToMaturity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BondPriceAndYieldModelBuilder {allInPrice=" + this.allInPrice + ", cleanOrDirtyPrice=" + this.cleanOrDirtyPrice + ", inflationFactor=" + this.inflationFactor + ", relativePrice=" + this.relativePrice + ", yieldToMaturity=" + this.yieldToMaturity + '}';
        }
    }

    public static class BondPriceAndYieldModelImpl
    implements BondPriceAndYieldModel {
        private final BigDecimal allInPrice;
        private final CleanOrDirtyPrice cleanOrDirtyPrice;
        private final BigDecimal inflationFactor;
        private final RelativePrice relativePrice;
        private final BigDecimal yieldToMaturity;

        protected BondPriceAndYieldModelImpl(BondPriceAndYieldModelBuilder builder) {
            this.allInPrice = builder.getAllInPrice();
            this.cleanOrDirtyPrice = Optional.ofNullable(builder.getCleanOrDirtyPrice()).map(f -> f.build()).orElse(null);
            this.inflationFactor = builder.getInflationFactor();
            this.relativePrice = Optional.ofNullable(builder.getRelativePrice()).map(f -> f.build()).orElse(null);
            this.yieldToMaturity = builder.getYieldToMaturity();
        }

        @Override
        public BigDecimal getAllInPrice() {
            return this.allInPrice;
        }

        @Override
        public CleanOrDirtyPrice getCleanOrDirtyPrice() {
            return this.cleanOrDirtyPrice;
        }

        @Override
        public BigDecimal getInflationFactor() {
            return this.inflationFactor;
        }

        @Override
        public RelativePrice getRelativePrice() {
            return this.relativePrice;
        }

        @Override
        public BigDecimal getYieldToMaturity() {
            return this.yieldToMaturity;
        }

        @Override
        public BondPriceAndYieldModel build() {
            return this;
        }

        @Override
        public BondPriceAndYieldModelBuilder toBuilder() {
            BondPriceAndYieldModelBuilder builder = BondPriceAndYieldModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BondPriceAndYieldModelBuilder builder) {
            Optional.ofNullable(this.getAllInPrice()).ifPresent(builder::setAllInPrice);
            Optional.ofNullable(this.getCleanOrDirtyPrice()).ifPresent(builder::setCleanOrDirtyPrice);
            Optional.ofNullable(this.getInflationFactor()).ifPresent(builder::setInflationFactor);
            Optional.ofNullable(this.getRelativePrice()).ifPresent(builder::setRelativePrice);
            Optional.ofNullable(this.getYieldToMaturity()).ifPresent(builder::setYieldToMaturity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BondPriceAndYieldModel _that = this.getType().cast(o);
            if (!Objects.equals(this.allInPrice, _that.getAllInPrice())) {
                return false;
            }
            if (!Objects.equals(this.cleanOrDirtyPrice, _that.getCleanOrDirtyPrice())) {
                return false;
            }
            if (!Objects.equals(this.inflationFactor, _that.getInflationFactor())) {
                return false;
            }
            if (!Objects.equals(this.relativePrice, _that.getRelativePrice())) {
                return false;
            }
            return Objects.equals(this.yieldToMaturity, _that.getYieldToMaturity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.allInPrice != null ? this.allInPrice.hashCode() : 0);
            _result = 31 * _result + (this.cleanOrDirtyPrice != null ? this.cleanOrDirtyPrice.hashCode() : 0);
            _result = 31 * _result + (this.inflationFactor != null ? this.inflationFactor.hashCode() : 0);
            _result = 31 * _result + (this.relativePrice != null ? this.relativePrice.hashCode() : 0);
            _result = 31 * _result + (this.yieldToMaturity != null ? this.yieldToMaturity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BondPriceAndYieldModel {allInPrice=" + this.allInPrice + ", cleanOrDirtyPrice=" + this.cleanOrDirtyPrice + ", inflationFactor=" + this.inflationFactor + ", relativePrice=" + this.relativePrice + ", yieldToMaturity=" + this.yieldToMaturity + '}';
        }
    }

    public static interface BondPriceAndYieldModelBuilder
    extends BondPriceAndYieldModel,
    RosettaModelObjectBuilder {
        public CleanOrDirtyPrice.CleanOrDirtyPriceBuilder getOrCreateCleanOrDirtyPrice();

        @Override
        public CleanOrDirtyPrice.CleanOrDirtyPriceBuilder getCleanOrDirtyPrice();

        public RelativePrice.RelativePriceBuilder getOrCreateRelativePrice();

        @Override
        public RelativePrice.RelativePriceBuilder getRelativePrice();

        public BondPriceAndYieldModelBuilder setAllInPrice(BigDecimal var1);

        public BondPriceAndYieldModelBuilder setCleanOrDirtyPrice(CleanOrDirtyPrice var1);

        public BondPriceAndYieldModelBuilder setInflationFactor(BigDecimal var1);

        public BondPriceAndYieldModelBuilder setRelativePrice(RelativePrice var1);

        public BondPriceAndYieldModelBuilder setYieldToMaturity(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("allInPrice"), BigDecimal.class, (Object)this.getAllInPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("inflationFactor"), BigDecimal.class, (Object)this.getInflationFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("yieldToMaturity"), BigDecimal.class, (Object)this.getYieldToMaturity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cleanOrDirtyPrice"), processor, CleanOrDirtyPrice.CleanOrDirtyPriceBuilder.class, this.getCleanOrDirtyPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relativePrice"), processor, RelativePrice.RelativePriceBuilder.class, this.getRelativePrice(), new AttributeMeta[0]);
        }

        public BondPriceAndYieldModelBuilder prune();
    }
}

