/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.staticdata.asset.common.Bond;
import cdm.base.staticdata.asset.common.ConvertibleBond;
import cdm.observable.asset.meta.BondChoiceModelMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface BondChoiceModel
extends RosettaModelObject {
    public static final BondChoiceModelMeta metaData = new BondChoiceModelMeta();

    public BondChoiceModel build();

    public BondChoiceModelBuilder toBuilder();

    public Bond getBond();

    public ConvertibleBond getConvertibleBond();

    default public RosettaMetaData<? extends BondChoiceModel> metaData() {
        return metaData;
    }

    public static BondChoiceModelBuilder builder() {
        return new BondChoiceModelBuilderImpl();
    }

    default public Class<? extends BondChoiceModel> getType() {
        return BondChoiceModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("bond"), processor, Bond.class, this.getBond(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("convertibleBond"), processor, ConvertibleBond.class, this.getConvertibleBond(), new AttributeMeta[0]);
    }

    public static class BondChoiceModelBuilderImpl
    implements BondChoiceModelBuilder {
        protected Bond.BondBuilder bond;
        protected ConvertibleBond.ConvertibleBondBuilder convertibleBond;

        @Override
        public Bond.BondBuilder getBond() {
            return this.bond;
        }

        @Override
        public Bond.BondBuilder getOrCreateBond() {
            Bond.BondBuilder result = this.bond != null ? this.bond : (this.bond = Bond.builder());
            return result;
        }

        @Override
        public ConvertibleBond.ConvertibleBondBuilder getConvertibleBond() {
            return this.convertibleBond;
        }

        @Override
        public ConvertibleBond.ConvertibleBondBuilder getOrCreateConvertibleBond() {
            ConvertibleBond.ConvertibleBondBuilder result = this.convertibleBond != null ? this.convertibleBond : (this.convertibleBond = ConvertibleBond.builder());
            return result;
        }

        @Override
        public BondChoiceModelBuilder setBond(Bond bond) {
            this.bond = bond == null ? null : bond.toBuilder();
            return this;
        }

        @Override
        public BondChoiceModelBuilder setConvertibleBond(ConvertibleBond convertibleBond) {
            this.convertibleBond = convertibleBond == null ? null : convertibleBond.toBuilder();
            return this;
        }

        @Override
        public BondChoiceModel build() {
            return new BondChoiceModelImpl(this);
        }

        @Override
        public BondChoiceModelBuilder toBuilder() {
            return this;
        }

        @Override
        public BondChoiceModelBuilder prune() {
            if (this.bond != null && !this.bond.prune().hasData()) {
                this.bond = null;
            }
            if (this.convertibleBond != null && !this.convertibleBond.prune().hasData()) {
                this.convertibleBond = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBond() != null && this.getBond().hasData()) {
                return true;
            }
            return this.getConvertibleBond() != null && this.getConvertibleBond().hasData();
        }

        public BondChoiceModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BondChoiceModelBuilder o = (BondChoiceModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBond(), (RosettaModelObjectBuilder)o.getBond(), this::setBond);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getConvertibleBond(), (RosettaModelObjectBuilder)o.getConvertibleBond(), this::setConvertibleBond);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BondChoiceModel _that = this.getType().cast(o);
            if (!Objects.equals(this.bond, _that.getBond())) {
                return false;
            }
            return Objects.equals(this.convertibleBond, _that.getConvertibleBond());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.bond != null ? this.bond.hashCode() : 0);
            _result = 31 * _result + (this.convertibleBond != null ? this.convertibleBond.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BondChoiceModelBuilder {bond=" + this.bond + ", convertibleBond=" + this.convertibleBond + '}';
        }
    }

    public static class BondChoiceModelImpl
    implements BondChoiceModel {
        private final Bond bond;
        private final ConvertibleBond convertibleBond;

        protected BondChoiceModelImpl(BondChoiceModelBuilder builder) {
            this.bond = Optional.ofNullable(builder.getBond()).map(f -> f.build()).orElse(null);
            this.convertibleBond = Optional.ofNullable(builder.getConvertibleBond()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Bond getBond() {
            return this.bond;
        }

        @Override
        public ConvertibleBond getConvertibleBond() {
            return this.convertibleBond;
        }

        @Override
        public BondChoiceModel build() {
            return this;
        }

        @Override
        public BondChoiceModelBuilder toBuilder() {
            BondChoiceModelBuilder builder = BondChoiceModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BondChoiceModelBuilder builder) {
            Optional.ofNullable(this.getBond()).ifPresent(builder::setBond);
            Optional.ofNullable(this.getConvertibleBond()).ifPresent(builder::setConvertibleBond);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BondChoiceModel _that = this.getType().cast(o);
            if (!Objects.equals(this.bond, _that.getBond())) {
                return false;
            }
            return Objects.equals(this.convertibleBond, _that.getConvertibleBond());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.bond != null ? this.bond.hashCode() : 0);
            _result = 31 * _result + (this.convertibleBond != null ? this.convertibleBond.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BondChoiceModel {bond=" + this.bond + ", convertibleBond=" + this.convertibleBond + '}';
        }
    }

    public static interface BondChoiceModelBuilder
    extends BondChoiceModel,
    RosettaModelObjectBuilder {
        public Bond.BondBuilder getOrCreateBond();

        @Override
        public Bond.BondBuilder getBond();

        public ConvertibleBond.ConvertibleBondBuilder getOrCreateConvertibleBond();

        @Override
        public ConvertibleBond.ConvertibleBondBuilder getConvertibleBond();

        public BondChoiceModelBuilder setBond(Bond var1);

        public BondChoiceModelBuilder setConvertibleBond(ConvertibleBond var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("bond"), processor, Bond.BondBuilder.class, this.getBond(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("convertibleBond"), processor, ConvertibleBond.ConvertibleBondBuilder.class, this.getConvertibleBond(), new AttributeMeta[0]);
        }

        public BondChoiceModelBuilder prune();
    }
}

