/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common.validation.datarule;

import cdm.legaldocumentation.common.LegalAgreement;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="LegalAgreementConsistentlyExecutedAgreements")
@ImplementedBy(value=Default.class)
public interface LegalAgreementConsistentlyExecutedAgreements
extends Validator<LegalAgreement> {
    public static final String NAME = "LegalAgreementConsistentlyExecutedAgreements";
    public static final String DEFINITION = "if relatedAgreements exists and agreementDate exists then relatedAgreements -> agreementDate exists";

    public ValidationResult<LegalAgreement> validate(RosettaPath var1, LegalAgreement var2);

    public static class NoOp
    implements LegalAgreementConsistentlyExecutedAgreements {
        @Override
        public ValidationResult<LegalAgreement> validate(RosettaPath path, LegalAgreement legalAgreement) {
            return ValidationResult.success((String)LegalAgreementConsistentlyExecutedAgreements.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegalAgreement", (RosettaPath)path, (String)LegalAgreementConsistentlyExecutedAgreements.DEFINITION);
        }
    }

    public static class Default
    implements LegalAgreementConsistentlyExecutedAgreements {
        @Override
        public ValidationResult<LegalAgreement> validate(RosettaPath path, LegalAgreement legalAgreement) {
            ComparisonResult result = this.executeDataRule(legalAgreement);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)LegalAgreementConsistentlyExecutedAgreements.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegalAgreement", (RosettaPath)path, (String)LegalAgreementConsistentlyExecutedAgreements.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition LegalAgreementConsistentlyExecutedAgreements failed.";
            }
            return ValidationResult.failure((String)LegalAgreementConsistentlyExecutedAgreements.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegalAgreement", (RosettaPath)path, (String)LegalAgreementConsistentlyExecutedAgreements.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(LegalAgreement legalAgreement) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)legalAgreement).mapC("getRelatedAgreements", _legalAgreement -> _legalAgreement.getRelatedAgreements())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)legalAgreement).map("getAgreementDate", legalAgreementBase -> legalAgreementBase.getAgreementDate()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)legalAgreement).mapC("getRelatedAgreements", _legalAgreement -> _legalAgreement.getRelatedAgreements()).map("getAgreementDate", legalAgreementBase -> legalAgreementBase.getAgreementDate()));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

