/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common.functions;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.legaldocumentation.common.AgreementTerms;
import cdm.legaldocumentation.common.LegalAgreement;
import cdm.legaldocumentation.common.LegalAgreementIdentification;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@ImplementedBy(value=Create_LegalAgreementWithPartyReferenceDefault.class)
public abstract class Create_LegalAgreementWithPartyReference
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public LegalAgreement evaluate(AgreementTerms agreementTerms, Date agreementDate, Date effectiveDate, List<? extends Identifier> identifier, LegalAgreementIdentification legalAgreementType, List<? extends Party> contractualParty, List<? extends PartyRole> otherParty) {
        LegalAgreement.LegalAgreementBuilder legalAgreement = this.doEvaluate(agreementTerms, agreementDate, effectiveDate, identifier, legalAgreementType, contractualParty, otherParty);
        if (legalAgreement != null) {
            this.objectValidator.validate(LegalAgreement.class, (RosettaModelObject)legalAgreement);
        }
        return legalAgreement;
    }

    protected abstract LegalAgreement.LegalAgreementBuilder doEvaluate(AgreementTerms var1, Date var2, Date var3, List<? extends Identifier> var4, LegalAgreementIdentification var5, List<? extends Party> var6, List<? extends PartyRole> var7);

    public static class Create_LegalAgreementWithPartyReferenceDefault
    extends Create_LegalAgreementWithPartyReference {
        @Override
        protected LegalAgreement.LegalAgreementBuilder doEvaluate(AgreementTerms agreementTerms, Date agreementDate, Date effectiveDate, List<? extends Identifier> identifier, LegalAgreementIdentification legalAgreementType, List<? extends Party> contractualParty, List<? extends PartyRole> otherParty) {
            LegalAgreement.LegalAgreementBuilder legalAgreement = LegalAgreement.builder();
            return this.assignOutput(legalAgreement, agreementTerms, agreementDate, effectiveDate, identifier, legalAgreementType, contractualParty, otherParty);
        }

        protected LegalAgreement.LegalAgreementBuilder assignOutput(LegalAgreement.LegalAgreementBuilder legalAgreement, AgreementTerms agreementTerms, Date agreementDate, Date effectiveDate, List<? extends Identifier> identifier, LegalAgreementIdentification legalAgreementType, List<? extends Party> contractualParty, List<? extends PartyRole> otherParty) {
            legalAgreement.setAgreementTerms((AgreementTerms)MapperS.of((Object)agreementTerms).get());
            legalAgreement.setAgreementDate((Date)MapperS.of((Object)agreementDate).get());
            legalAgreement.setEffectiveDate((Date)MapperS.of((Object)effectiveDate).get());
            legalAgreement.addIdentifier(MapperC.of(identifier).getMulti());
            legalAgreement.setLegalAgreementIdentification((LegalAgreementIdentification)MapperS.of((Object)legalAgreementType).get());
            legalAgreement.setContractualParty(MapperC.of(contractualParty).getItems().map(item -> ReferenceWithMetaParty.builder().setExternalReference(((Party)item.getMappedObject()).getMeta().getExternalKey()).setGlobalReference(((Party)item.getMappedObject()).getMeta().getGlobalKey()).build()).collect(Collectors.toList()));
            legalAgreement.addOtherParty(MapperC.of(otherParty).getMulti());
            return Optional.ofNullable(legalAgreement).map(o -> o.prune()).orElse(null);
        }
    }
}

